/**
 * Copper Swapper -- goat tile swapper game
 *
 * Copyright (C) 2005 Atani Software
 *
 * This code is licensed under the GPL v2.
 *
 * copperswapper.cpp -- Entry point for game
 */

#include "copperswapper.h"
extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT | INIT_NO_DCLOAD);
KOS_INIT_ROMDISK(romdisk);

Texture *bgTitle;
Texture *bgOverLay;
Texture *titleText;
Texture *titleGoat;
Texture *titleStart;

Texture *selectorTileTxr[4];
Font *baseFont;

Sound *selectSound = NULL;

Color colorMenuSelected = Color(1, 1, 0, 1);
Color colorMenuDefault = Color(1, 1, 1, 1);

MainMenu *mainMenu;
InGame *ingame;
HighScoreMenu *highscoreMenu;

score_table_t *scoreTable;

int musicVolume = 240;

int main(int argc, char *argv[])
{
	pvr_init_defaults();
	seedMT(time(NULL));

	goat_init();

	scoreTable = goat_load_score_table(COPPER_SWAPPER_GAME_ID);
	if(scoreTable == NULL)
	{
		scoreTable = (score_table_t *)malloc(SCORE_TABLE_SIZE_CNT(10));
		initScoreTable();
	}
	printScoreTable();

	loadTextures();
	loadSounds();

	titleScreen();

	loadMenus();

	mainMenu->doMenu();

	goat_save_score_table(COPPER_SWAPPER_GAME_ID, scoreTable);

	goat_exit();

	return 0;
}

void printScoreTable()
{
	printf("PLACE\tID\tLEVEL\tSCORE\n");
	for(int i = 0; i < 10; i++)
	{
		printf("%u\t%s\t%u\t%u\n", i + 1, scoreTable->entries[i].name, scoreTable->entries[i].level_reached, scoreTable->entries[i].score);
	}
}

void initScoreTable()
{
	scoreTable->bitfield = SCORE_NAME | SCORE_SCORE | SCORE_LEVEL;
	scoreTable->score_cnt = 10;
	scoreTable->play_cnt = 0;
	scoreTable->settings[0] = 0;
	scoreTable->settings[1] = 0;
	for(int i = 0; i < 10; i++)
	{
		strcpy(scoreTable->entries[i].name, "N/A");
		scoreTable->entries[i].score = 1000 - (i*100);
		scoreTable->entries[i].level_reached = 1;
		scoreTable->entries[i].difficulty = 0;
		scoreTable->entries[i].time_lasted = 0;
	}
}

const char *songList[] =
{
	"/rd/cr1.ogg",
	// null entry, make sure this is last in the list
	"<null>",
};

SONG_ID currentSong = SONG_NULL;
SONG_ID getCurrentSong() { return currentSong; }

void switchMusic(SONG_ID song, int loop)
{
	sndoggvorbis_volume(musicVolume);
	const char *songName = songList[song];
	if(song != SONG_NULL)
	{
		sndoggvorbis_start(songName, loop);
	}
	currentSong = song;
}

void loadTextures()
{
	baseFont = new Font("/rd/typewriter.txf");
	selectorTileTxr[0] = new Texture("/rd/selector00.kmg.bz2", true);
	selectorTileTxr[1] = new Texture("/rd/selector01.kmg.bz2", true);
	selectorTileTxr[2] = new Texture("/rd/selector02.kmg.bz2", true);
	selectorTileTxr[3] = new Texture("/rd/selector03.kmg.bz2", true);

	bgOverLay = new Texture("/rd/blacb_bar.kmg.bz2", true);
	bgTitle = new Texture("/rd/bgtitle.kmg.bz2", true);
	titleText = new Texture("/rd/menu_title.kmg.bz2", true);
	titleGoat = new Texture("/rd/copper.kmg.bz2", true);
	titleStart = new Texture("/rd/menu_start.kmg.bz2", true);
}

void loadSounds()
{
	snd_stream_init();
	sndoggvorbis_init();
}

void loadMenus()
{
	mainMenu = new MainMenu();
	ingame = new InGame();
	highscoreMenu = new HighScoreMenu();
}

void titleScreen()
{
	RefPtr<Scene> scene = new Scene();
	RefPtr<Banner> bg = new Banner(PVR_LIST_TR_POLY, bgTitle);
	RefPtr<Banner> start = new Banner(PVR_LIST_TR_POLY, titleStart);
	RefPtr<Banner> goat = new Banner(PVR_LIST_TR_POLY, titleGoat);
	RefPtr<Banner> title = new Banner(PVR_LIST_TR_POLY, titleText);
	scene->setTranslate(Vector(320, 240, 10));
	bg->setSize(640.0f, 480.0f);
	bg->setTranslate(Vector(0, 0, 10));
	start->setSize(128.0f, 64.0f);
	start->setTranslate(Vector(0, 150, 11));
	goat->setSize(256.0f, 128.0f);
	goat->setTranslate(Vector(-225, -150, 11));
	title->setSize(512.0f, 256.0f);
	title->setTranslate(Vector(50, -100, 11));

	scene->subAdd(bg);
	scene->subAdd(start);
	scene->subAdd(goat);
	scene->subAdd(title);

	switchMusic(SONG_MENU, 1);

	int done = 0;
	while(!done)
	{
		scene->subRemoveFinished();

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PLX_LIST_OP_POLY);
		scene->draw(PLX_LIST_OP_POLY);
		pvr_list_begin(PLX_LIST_TR_POLY);
		scene->draw(PLX_LIST_TR_POLY);
		pvr_scene_finish();
		scene->nextFrame();

		MAPLE_FOREACH_BEGIN(MAPLE_FUNC_CONTROLLER, cont_state_t, t)
			if (t->buttons & CONT_START)
			{
				done = 1;
			}
		MAPLE_FOREACH_END()
	}
}
