#ifndef LCAV_LCAVITY_H
#define LCAV_LCAVITY_H

#include <iostream>
#include "SDL.h"
#include "acceleration.h"
#include "gamecol.h"

namespace Lcav
{

  class Lcavity
  {
    public:
      Lcavity(int argc,char* argv[]);
      ~Lcavity();
      void setConfig();
      int initSDL();
      void playGame();
      void drawColumn(int x,int pointheight,int top,int bottom);
      bool grabKeyInput();
      void stepOn();
      void checkKeyInput();
      void updateScreen();
      void changeCave();
      int getTop(int position);
      int getBottom(int position);
    private:
      SDL_Surface* screen;
      Acceleration accel;
      int width;
      int height;
      int hposition;
      Gamecol *cols[640];
      int colPosition;
      int caveChangedistance;
      int prevCavetop;
      int prevCaveheight;
      int nextCavetop;
      int nextCaveheight;
  }; //class Lcavity

}; //namespace Lcav
#endif //LCAV_LCAVITY_H
