#include "acceleration.h"

using namespace Lcav;

/* creates an acceleration object
 */
Acceleration::Acceleration(float accel,float startspeed,float startposition)
{
  acceleration=accel;
  speed=startspeed;
  position=startposition;
} // Acceleration::Acceleration()

/* destroys the object
 */
Acceleration::~Acceleration()
{
} // Acceleration::~Acceleration()

/* returns the position after a certain time
 */
float Acceleration::getPosition(float time)
{
  return (acceleration*time+speed)*time+position;
} // float Acceleration::getPosition()

/* returns the speed after a certain time
 */
float Acceleration::getSpeed(float time)
{
  return (acceleration*time+speed);
} // float Acceleration::getSpeed()

/* sets all start values to the current values
 * which results in a quasi new acceleration object using the current values
 * as start values.
 */
void Acceleration::setToCurrent(float time)
{
  float newposition=getPosition(time);
  float newspeed=getSpeed(time);
  position=newposition;
  speed=newspeed;
} // void Acceleration::setToCurrent()

/* sets a different acceleration
 */
void Acceleration::setAcceleration(float accel)
{
  acceleration=accel;
} // void Acceleration::setAcceleration()

/* get the current acceleration
 */
float Acceleration::getAcceleration()
{
  return acceleration;
} // float Acceleration::getAcceleration
