#include <stdio.h>
#include <stdlib.h>

#ifdef DREAMCAST
	#include <kos.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
	extern uint8 romdisk[];
	KOS_INIT_ROMDISK(romdisk);
#endif

#include <SDL/SDL.h>

#ifdef DREAMCAST
	#include <SDL/SDL_dreamcast.h>	
#endif

#include "tongits/includes/CTongIts.h"

int main(int argc, char *argv[])
{
	SDL_Surface *screen;
	CTongIts	Game;

	#ifdef DREAMCAST
	    printf("Starting...\n");
	    fs_chdir("/rd");
	#endif

	//Options
	bool Aggressive = false;
	unsigned int Video = SDL_SWSURFACE|SDL_HWPALETTE;

	//check for command-line arguments
	while ( argc > 1 ) {
	
		if ( strcmp(argv[1], "--aggressive") == 0 ) {

			Aggressive = true;
			argv++;
			argc--;
		} else
		
  		if ( strcmp(argv[1], "--fullscreen") == 0 ) {

			Video |= SDL_FULLSCREEN;
			argv++;
			argc--;
		} else break;
	}

	if( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO|SDL_INIT_JOYSTICK) < 0 ) {

		printf("Unable to initialize SDL: %s\n", SDL_GetError());
		exit(1);
	} 
	
	atexit(SDL_Quit);
	screen = SDL_SetVideoMode(640, 480,  0, Video);	//'0' lets the game 'adapt' to the color depth

	if(screen == NULL) {

		printf("Unable to set 640x480 video: %s\n", SDL_GetError());
		exit(1);
	}

	#ifdef DREAMCAST
	    SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button to exit
		SDL_JoystickOpen(0);
		SDL_JoystickEventState(SDL_ENABLE);
	#endif

	Game.SetAggresive(Aggressive);
	Game.Initialize(screen);
	int done = Game.HandleIntro();	//show the intro screen

	SDL_Event event;

	SDL_EventState (SDL_ACTIVEEVENT, SDL_IGNORE);

	//the game loop
	while(done == 0)
	{
		while(SDL_PollEvent(&event))
		{
			Game.HandleEvents(event, &done);
			if(event.type == SDL_QUIT) return 0;
		}
		SDL_Delay(SDL_TIMESLICE);
	}
	
	return 0;
}

