/*
 * DCSketch
 * Completely rewritten for KOS 2.x (14 years later!!!!).
 * Specially New Maple system and KOS system.
 */

#include "draw.h"
#include "pal.h"
#include <kos.h>

KOS_INIT_FLAGS(INIT_DEFAULT); 

/* Syscall to return to boot menu */
void exit_to_menu()
{
  (*(void(**)())0x8c0000e0)(1);
}

/* Call to paint screen of white */
void clear_screen()   {
   int i;
   for(i = 0; i < 640 * 480; i++)   {
      vram_s[i] = 0xffff;
   }
}


int main()
{
	maple_device_t * mcont;
	cont_state_t * cond;

	int cursor[2] = { 320, 240 };	/* start the cursor at x 320 y 240 */

	/* Set up the screen */
	int dc_region, ct;
  
	dc_region = flashrom_get_region();
	ct = vid_check_cable();
 
	/* Prompt the user for whether to run in PAL50 or PAL60 if the flashrom says
	the Dreamcast is European and a VGA Box is not hooked up. */
	if(dc_region == FLASHROM_REGION_EUROPE && ct != CT_VGA) {
		if(pal_menu()) {
			vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
		}
		else {
			vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
		}
	}
	else vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
	
	clear_screen();
	
	//Set font colour (thanks Chilly Willy! :D)
	bfont_set_foreground_color(0x00000000);
	bfont_set_background_color(0xffffffff);

	/* Maple Controller (KOS2) */
	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	if (!mcont)  {
		return 1;
	}
	
	bfont_draw_str(vram_s + 10 * 640 + 10, 640, 1, "DCSketch - A:Clear START:Exit");

	/* Main Loop - check input and respond, exit if start is pressed */
	for(;;) {

		/* draw the cursor cross-hair */
		draw_pixel( cursor[0], cursor[1], 0x0 );
		draw_pixel( cursor[0]-1, cursor[1], 0x0 );
		draw_pixel( cursor[0]+1, cursor[1], 0x0 );
		draw_pixel( cursor[0], cursor[1]-1, 0x0 );
		draw_pixel( cursor[0], cursor[1]+1, 0x0 );

		/* Query controller condition */
		cond = (cont_state_t *) maple_dev_status(mcont);
		
		if (cond) {
			/* Check controller input */
			if(cond->buttons & CONT_DPAD_LEFT) {
				if( cursor[0] > 0 )
					cursor[0]--;
			}

			if(cond->buttons & CONT_DPAD_RIGHT) {
				if( cursor[0] < 639 )
					cursor[0]++;
			}

			if(cond->buttons & CONT_DPAD_UP) {
				if( cursor[1] > 0 )
					cursor[1]--;
			}

			if(cond->buttons & CONT_DPAD_DOWN) {
				if( cursor[1] < 479 )
					cursor[1]++;
			}
			
			if(cond->buttons & CONT_A) {
				clear_screen();		
				bfont_draw_str(vram_s + 10 * 640 + 10, 640, 1, "DCSketch - A:Clear START:Exit");
			}

			if(cond->buttons & CONT_START)
				exit_to_menu();
		}
		//Replace dc_waitvbl() for vid_waitvbl()
		vid_waitvbl();
		
	}
}
