/* Draw a pixel at x,y in colour */
void draw_pixel( unsigned int x, unsigned int y, unsigned short colour ) 
{
	unsigned short *pixel;
	pixel = ((unsigned short*)0xa5000000)+(640*y);
	pixel[x] = colour;
}


/* Line drawing function based on y=mx+c */
void draw_line( unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned short colour ) 
{
	unsigned int greater, lesser;	/* greater x and lesser x */
	unsigned int i;
	float m, c;
	
	/* if the x values are the same, theres no gradient, so just loop */
	if( x1 == x2 )
	{
		/* find the greater and lesser y values for looping */
		greater = ( y1 > y2 ) ? y1 : y2;
		lesser = ( y1 > y2 ) ? y2 : y1;

		for( i=lesser; i<=greater; i++ )
			draw_pixel( x1, i, colour );
	
	} else {
		/* find the greater and lesser x values for looping */
		greater = ( x1 > x2 ) ? x1 : x2;
		lesser = ( x1 > x2 ) ? x2 : x1;
		
		/* Calculate m and c for y = mx+c */
		m = ((float)y2 - (float)y1) / ((float)x2 - (float)x1);
		c = y1 - (m * x1);

		//if( m == (y2 - y1) / (x2 - x1) )
		//	return;

		/* loop between x values */
		for( i=lesser; i<=greater; i++ ) 
			draw_pixel( i, m*i+c, colour );
	}
} 