#ifndef TIL_H
#define TIL_H

#define TIL_CALCULATE_UV                        /* undef to use lookup tables */

typedef struct til_set                                   /* tileset structure */
{
  pvr_poly_hdr_t  header;                                       /* pvr header */
  pvr_ptr_t       texture;                                 /* texture pointer */
  uint32          texture_width;                      /* width of the texture */
  uint8          *mask;                             /* collision mask pointer */
  uint8           halftilewidth;                           /* half tile width */
  uint8           halftileheight;                         /* half tile height */
  uint8           loaded;                          /* number of load requests */
  #if defined(TIL_CALCULATE_UV)
  float           width_delta;        /* difference in pvr co-ords of 1 width */
  float           height_delta;      /* difference in pvr co-ords of 1 height */
  #endif
}
til_set_t;

#define TIL_LOAD_TEXTURE 1                   /* create a texture when loading */
#define TIL_LOAD_MASK    2                      /* create a mask when loading */
#define TIL_MASK_FLAT    4                            /* create a 'flat' mask */
#define TIL_MASK_SPECIAL 8                     /* special mask - non-standard */

#define TIL_LOAD_BOTH (TIL_LOAD_TEXTURE | TIL_LOAD_MASK)

#define TIL_TILES_PER_LINE    8                 /* how many tiles on each row */
#define TIL_MAX_SETS          256         /* maximum number of conurrent sets */
#define TIL_DEF_PREFIX        "TS"       /* gfx file prefix if none specified */
#define TIL_DEF_FILETYPE      "til"     /* filetype for tile description file */
#define TIL_DEF_GFX_FILETYPE  "png"        /* filetype for tile graphics file */

#define TIL_SET_MASK  0xFF000000            /* mask to get set from an 'info' */
#define TIL_TILE_MASK 0x00FF0000           /* mask to get tile from an 'info' */

/* FUNCTIONS */

void  til_init(void);

void  til_term(void);

uint8 til_set_load(uint8 set,                                   /* set number */
                   uint8 mode);                 /* TIL_LOAD_TEXTURE/MASK/BOTH */
                   
void  til_set_unload(uint8 set);                                /* set number */

int   til_render(uint8 set,                                     /* set number */
                 uint8 tile,                                   /* tile number */
                 int32 map_x,              /* map x position (centre of tile) */
                 int32 map_y,              /* map y position (centre of tile) */
                 float z_order,                       /* z-value for the tile */
                 int32 rotation,                       /* rotation in degrees */
                 float scale,                             /* scale the object */
                 float fade,                              /* colour intensity */
                 uint32 colour);                      /* r << 16 | g << 8 | b */

int   til_render_obj(uint32 info,                         /* tile information */
                     uint32 unused,    
                     int32 map_x,          /* map x position (centre of tile) */
                     int32 map_y,          /* map y position (centre of tile) */
                     float z_order,                   /* z-value for the tile */
                     int32 rotation,                   /* rotation in degrees */
                     float scale,                         /* scale the object */
                     float fade,                          /* colour intensity */
                     uint32 colour);                  /* r << 16 | g << 8 | b */
                   
uint32 til_getwidth(uint32 info);                         /* tile information */

uint32 til_getheight(uint32 info);                        /* tile information */

uint8 *til_getmask(uint32 info,                           /* tile information */
                   int32 rotation);                  /* rotation (in degrees) */

uint32 til_obj_create_str(char *string);           /* tile string description */

void til_obj_free(uint32 info);                           /* tile information */

uint32 til_inst_create(uint32 info);                      /* tile information */

void til_inst_free(uint32 info);                 /* tile instance information */

#endif
