#ifndef SND_H
#define SND_H

/* ---------- */                
/* Structures */
/* ---------- */

typedef struct sound 
{
  uint32  left_addr;
  uint32  right_addr;
  uint8   fmt;
  uint32  len;
  uint32  rate;
  uint8   stereo;
  uint32  loop;
  uint32  loopstart;
  uint32  loopend;
} 
sound_t;

typedef struct channel
{
  uint32  lock_until;
}
channel_t;

#define CHANNELS 64

/* --------- */
/* Functions */
/* --------- */

typedef enum
{
  BG_NONE = 0,
  BG_MOD,
  BG_MP3,
  BG_OGG
} BGTYPE;

#define MAX_BG 5

#define BG_MODIFY_INSERT    0
#define BG_MODIFY_SWITCH    1
#define BG_MODIFY_SETVOLUME 2
#define BG_MODIFY_PAUSE     3
#define BG_MODIFY_RESTART   4

#if defined(SND_C)
int auto_pan = 0;
int snd_fx_volume = 255;
int snd_bg_volume = 255;
#if !defined(SND_BG_MP3)
int sa_c = 0;
#endif
#else 
extern int auto_pan;
extern int sa_c;
#endif

#if defined(_WIN32)
#define snd_all_init()
#define snd_all_term()
#define snd_bg_load(filename) 0
#define snd_bg_unload(bg_num)
#define snd_bg_obj_create_str(string) 1
#define snd_bg_obj_free(info)
#define snd_bg_start(bg_num)
#define snd_bg_modify(modifytype,op1,op2)
#define snd_bg_poll()
#define snd_bg_stop()
#define snd_fx_load(filename) 0
#define snd_fx_unload(fx_num)
#define snd_fx_obj_create_str(string) 1
#define snd_fx_obj_free(info)
#define snd_fx_inst_create(info) 0
#define snd_fx_inst_free(info)
#define snd_fx_render(fx_num,unused,map_x,map_y) 1
#else
void snd_all_init(void);
void snd_all_term(void);

int snd_bg_load(char *filename);
void snd_bg_unload(int bg_num);
uint32 snd_bg_obj_create_str(char *string);
void snd_bg_obj_free(uint32 info);

void snd_bg_start(int bg_num);
void snd_bg_modify(int modifytype, int op1, int op2);
void snd_bg_poll(void);
void snd_bg_stop(void);

int snd_fx_load(char *filename);
void snd_fx_unload(int fx_num);
uint32 snd_fx_obj_create_str(char *string);
void snd_fx_obj_free(uint32 info);
uint32 snd_fx_inst_create(uint32 info);
void snd_fx_inst_free(uint32 info);
int snd_fx_render(uint32 fx_num,                                 /* fx number */
                  uint32 unused,    
                  int32 map_x,                             /* map x position! */
                  int32 map_y);                            /* map y position! */
#endif

#define MAX_FX 256
#define FIRST_FREE_FX_CHANNEL 2
#define FX_NOLOCK 0

#endif
