#ifndef ANI_H
#define ANI_H

#define ANI_MAX_PATHS         300

typedef struct ani_info                                     /* animation info */
{
  int32   dirchange;    /* How often this ani changes direction toward player */
  int32   score;                         /* Score achieved when one is killed */
  int32  *path[ANI_MAX_PATHS];                /* All animation paths possible */
}
ani_info_t;

#define ANI_PATH_MOVE                             0
#define ANI_PATH_MOVE_NORTH                       1
#define ANI_PATH_MOVE_NORTHEAST                   2
#define ANI_PATH_MOVE_EAST                        3
#define ANI_PATH_MOVE_SOUTHEAST                   4
#define ANI_PATH_MOVE_SOUTH                       5
#define ANI_PATH_MOVE_SOUTHWEST                   6
#define ANI_PATH_MOVE_WEST                        7 
#define ANI_PATH_MOVE_NORTHWEST                   8 
                                                  
#define ANI_PATH_STOP                             9
#define ANI_PATH_STOP_NORTH                       10
#define ANI_PATH_STOP_NORTHEAST                   11
#define ANI_PATH_STOP_EAST                        12
#define ANI_PATH_STOP_SOUTHEAST                   13
#define ANI_PATH_STOP_SOUTH                       14
#define ANI_PATH_STOP_SOUTHWEST                   15
#define ANI_PATH_STOP_WEST                        16
#define ANI_PATH_STOP_NORTHWEST                   17
                                                  
#define ANI_PATH_STOP_TO_MOVE                     20
#define ANI_PATH_STOP_TO_MOVE_NORTH               21
#define ANI_PATH_STOP_TO_MOVE_NORTHEAST           22
#define ANI_PATH_STOP_TO_MOVE_EAST                23
#define ANI_PATH_STOP_TO_MOVE_SOUTHEAST           24
#define ANI_PATH_STOP_TO_MOVE_SOUTH               25
#define ANI_PATH_STOP_TO_MOVE_SOUTHWEST           26
#define ANI_PATH_STOP_TO_MOVE_WEST                27
#define ANI_PATH_STOP_TO_MOVE_NORTHWEST           28
                                                  
#define ANI_PATH_STOP_NORTH_TO_MOVE               29
#define ANI_PATH_STOP_NORTH_TO_MOVE_NORTH         30
#define ANI_PATH_STOP_NORTH_TO_MOVE_NORTHEAST     31
#define ANI_PATH_STOP_NORTH_TO_MOVE_EAST          32
#define ANI_PATH_STOP_NORTH_TO_MOVE_SOUTHEAST     33
#define ANI_PATH_STOP_NORTH_TO_MOVE_SOUTH         34
#define ANI_PATH_STOP_NORTH_TO_MOVE_SOUTHWEST     35
#define ANI_PATH_STOP_NORTH_TO_MOVE_WEST          36
#define ANI_PATH_STOP_NORTH_TO_MOVE_NORTHWEST     37

#define ANI_PATH_STOP_NORTHEAST_TO_MOVE           38
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_NORTH     39
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_NORTHEAST 40
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_EAST      41
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_SOUTHEAST 42
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_SOUTH     43
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_SOUTHWEST 44
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_WEST      45
#define ANI_PATH_STOP_NORTHEAST_TO_MOVE_NORTHWEST 46

#define ANI_PATH_STOP_EAST_TO_MOVE                47
#define ANI_PATH_STOP_EAST_TO_MOVE_NORTH          48
#define ANI_PATH_STOP_EAST_TO_MOVE_NORTHEAST      49
#define ANI_PATH_STOP_EAST_TO_MOVE_EAST           50
#define ANI_PATH_STOP_EAST_TO_MOVE_SOUTHEAST      51
#define ANI_PATH_STOP_EAST_TO_MOVE_SOUTH          52
#define ANI_PATH_STOP_EAST_TO_MOVE_SOUTHWEST      53
#define ANI_PATH_STOP_EAST_TO_MOVE_WEST           54
#define ANI_PATH_STOP_EAST_TO_MOVE_NORTHWEST      55

#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE           56
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_NORTH     57
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_NORTHEAST 58
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_EAST      59
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_SOUTHEAST 60
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_SOUTH     61
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_SOUTHWEST 62
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_WEST      63
#define ANI_PATH_STOP_SOUTHEAST_TO_MOVE_NORTHWEST 64

#define ANI_PATH_STOP_SOUTH_TO_MOVE               65
#define ANI_PATH_STOP_SOUTH_TO_MOVE_NORTH         66
#define ANI_PATH_STOP_SOUTH_TO_MOVE_NORTHEAST     67
#define ANI_PATH_STOP_SOUTH_TO_MOVE_EAST          68
#define ANI_PATH_STOP_SOUTH_TO_MOVE_SOUTHEAST     69
#define ANI_PATH_STOP_SOUTH_TO_MOVE_SOUTH         70
#define ANI_PATH_STOP_SOUTH_TO_MOVE_SOUTHWEST     71
#define ANI_PATH_STOP_SOUTH_TO_MOVE_WEST          72
#define ANI_PATH_STOP_SOUTH_TO_MOVE_NORTHWEST     73

#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE           74
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_NORTH     75
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_NORTHEAST 76
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_EAST      77
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_SOUTHEAST 78
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_SOUTH     79
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_SOUTHWEST 80
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_WEST      81
#define ANI_PATH_STOP_SOUTHWEST_TO_MOVE_NORTHWEST 82

#define ANI_PATH_STOP_WEST_TO_MOVE                83
#define ANI_PATH_STOP_WEST_TO_MOVE_NORTH          84
#define ANI_PATH_STOP_WEST_TO_MOVE_NORTHEAST      85
#define ANI_PATH_STOP_WEST_TO_MOVE_EAST           86
#define ANI_PATH_STOP_WEST_TO_MOVE_SOUTHEAST      87
#define ANI_PATH_STOP_WEST_TO_MOVE_SOUTH          88
#define ANI_PATH_STOP_WEST_TO_MOVE_SOUTHWEST      89
#define ANI_PATH_STOP_WEST_TO_MOVE_WEST           90
#define ANI_PATH_STOP_WEST_TO_MOVE_NORTHWEST      91

#define ANI_PATH_STOP_NORTHWEST_TO_MOVE           92
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_NORTH     93
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_NORTHEAST 94
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_EAST      95
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_SOUTHEAST 96
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_SOUTH     97
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_SOUTHWEST 98
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_WEST      99
#define ANI_PATH_STOP_NORTHWEST_TO_MOVE_NORTHWEST 100

#define ANI_PATH_MOVE_EAST_TO_MOVE_WEST           101
#define ANI_PATH_MOVE_WEST_TO_MOVE_EAST           102

#define ANI_PATH_EVENTSTART                       110
#define ANI_PATH_SHOOT                            110
#define ANI_PATH_SHOOT_NORTH                      111
#define ANI_PATH_SHOOT_NORTHEAST                  112
#define ANI_PATH_SHOOT_EAST                       113
#define ANI_PATH_SHOOT_SOUTHEAST                  114
#define ANI_PATH_SHOOT_SOUTH                      115
#define ANI_PATH_SHOOT_SOUTHWEST                  116
#define ANI_PATH_SHOOT_WEST                       117
#define ANI_PATH_SHOOT_NORTHWEST                  118
#define ANI_PATH_HIT                              119
#define ANI_PATH_HIT_NORTH                        120
#define ANI_PATH_HIT_NORTHEAST                    121
#define ANI_PATH_HIT_EAST                         122
#define ANI_PATH_HIT_SOUTHEAST                    123
#define ANI_PATH_HIT_SOUTH                        124
#define ANI_PATH_HIT_SOUTHWEST                    125
#define ANI_PATH_HIT_WEST                         126
#define ANI_PATH_HIT_NORTHWEST                    127
#define ANI_PATH_DEAD                             128
#define ANI_PATH_DEAD_NORTH                       129
#define ANI_PATH_DEAD_NORTHEAST                   130
#define ANI_PATH_DEAD_EAST                        131
#define ANI_PATH_DEAD_SOUTHEAST                   132
#define ANI_PATH_DEAD_SOUTH                       133
#define ANI_PATH_DEAD_SOUTHWEST                   134
#define ANI_PATH_DEAD_WEST                        135
#define ANI_PATH_DEAD_NORTHWEST                   136
#define ANI_PATH_BOUNDARY_1                       137
#define ANI_PATH_BOUNDARY_1_NORTH                 138
#define ANI_PATH_BOUNDARY_1_NORTHEAST             139
#define ANI_PATH_BOUNDARY_1_EAST                  140
#define ANI_PATH_BOUNDARY_1_SOUTHEAST             141
#define ANI_PATH_BOUNDARY_1_SOUTH                 142
#define ANI_PATH_BOUNDARY_1_SOUTHWEST             143
#define ANI_PATH_BOUNDARY_1_WEST                  144
#define ANI_PATH_BOUNDARY_1_NORTHWEST             145
#define ANI_PATH_BOUNDARY_2                       146
#define ANI_PATH_BOUNDARY_2_NORTH                 147
#define ANI_PATH_BOUNDARY_2_NORTHEAST             148
#define ANI_PATH_BOUNDARY_2_EAST                  149
#define ANI_PATH_BOUNDARY_2_SOUTHEAST             150
#define ANI_PATH_BOUNDARY_2_SOUTH                 151
#define ANI_PATH_BOUNDARY_2_SOUTHWEST             152
#define ANI_PATH_BOUNDARY_2_WEST                  153
#define ANI_PATH_BOUNDARY_2_NORTHWEST             154
#define ANI_PATH_BOUNDARY_3                       155
#define ANI_PATH_BOUNDARY_3_NORTH                 156
#define ANI_PATH_BOUNDARY_3_NORTHEAST             157
#define ANI_PATH_BOUNDARY_3_EAST                  158
#define ANI_PATH_BOUNDARY_3_SOUTHEAST             159
#define ANI_PATH_BOUNDARY_3_SOUTH                 160
#define ANI_PATH_BOUNDARY_3_SOUTHWEST             161
#define ANI_PATH_BOUNDARY_3_WEST                  162
#define ANI_PATH_BOUNDARY_3_NORTHWEST             163
#define ANI_PATH_BOUNDARY_4                       164
#define ANI_PATH_BOUNDARY_4_NORTH                 165
#define ANI_PATH_BOUNDARY_4_NORTHEAST             166
#define ANI_PATH_BOUNDARY_4_EAST                  167
#define ANI_PATH_BOUNDARY_4_SOUTHEAST             168
#define ANI_PATH_BOUNDARY_4_SOUTH                 169
#define ANI_PATH_BOUNDARY_4_SOUTHWEST             170
#define ANI_PATH_BOUNDARY_4_WEST                  171
#define ANI_PATH_BOUNDARY_4_NORTHWEST             172
#define ANI_PATH_BOUNDARY_5                       173
#define ANI_PATH_BOUNDARY_5_NORTH                 174
#define ANI_PATH_BOUNDARY_5_NORTHEAST             175
#define ANI_PATH_BOUNDARY_5_EAST                  176
#define ANI_PATH_BOUNDARY_5_SOUTHEAST             177
#define ANI_PATH_BOUNDARY_5_SOUTH                 178
#define ANI_PATH_BOUNDARY_5_SOUTHWEST             179
#define ANI_PATH_BOUNDARY_5_WEST                  180
#define ANI_PATH_BOUNDARY_5_NORTHWEST             181

#define ANI_PATH_UNIQUE_START                     200
#define ANI_PATH_REVIVE                           200
#define ANI_PATH_UNIQUE_END                       290
#define ANI_PATH_EVENTEND                         290

#define ANI_PATH_TRACK_1                          291
#define ANI_PATH_TRACK_2                          292
#define ANI_PATH_TRACK_3                          293

#define ANI_PATH_UNDEFINED                        299

#define ANI_CMD_NEXT              0  // NEXT
#define ANI_CMD_COPY              1  // COPY
#define ANI_CMD_GOTO              2  // GOTO
#define ANI_CMD_REVERT            3  // REVERT
#define ANI_CMD_GETGOING          4  // GETGOING
#define ANI_CMD_RAND              5  // RAND
#define ANI_CMD_CALC              6  // CALC
#define ANI_CMD_SETTRACK          7  // SETTRACK
#define ANI_CMD_SETTRACK_VAR      8  // SETTRACK_VAR

#define ANI_CMD_OBJECT            20 // OBJECT
#define ANI_CMD_OBJECT_VAR        21 // OBJECT_VAR
#define ANI_CMD_PAUSE             22 // PAUSE
#define ANI_CMD_PAUSE_VAR         23 // PAUSE_VAR
#define ANI_CMD_ADDINST           24 // ADDINST
#define ANI_CMD_ADDINST_VAR       25 // ADDINST_VAR
#define ANI_CMD_ADDINSTLOOP       26 // ADDINSTLOOP
#define ANI_CMD_ADDINSTLOOP_VAR   27 // ADDINSTLOOP_VAR
#define ANI_CMD_DIE               28 // DIE
#define ANI_CMD_DIE_VAR           29 // DIE_VAR
#define ANI_CMD_SETEOL            30 // SETEOL
#define ANI_CMD_SETEOL_VAR        31 // SETEOL_VAR
#define ANI_CMD_BOUNCE            32 // BOUNCE
#define ANI_CMD_MOVEBACK          33 // MOVEBACK
#define ANI_CMD_MOVEBACK_VAR      34 // MOVEBACK_VAR
#define ANI_CMD_SETSPD            35 // SETSPD
#define ANI_CMD_SETSPD_VAR        36 // SETSPD_VAR
#define ANI_CMD_MODSPD            37 // MODSPD
#define ANI_CMD_MODSPD_VAR        38 // MODSPD_VAR
#define ANI_CMD_SETDIR            39 // SETDIR
#define ANI_CMD_SETDIR_VAR        40 // SETDIR_VAR
#define ANI_CMD_MODDIR            41 // MODDIR
#define ANI_CMD_MODDIR_VAR        42 // MODDIR_VAR
#define ANI_CMD_SETZ              43 // SETZ
#define ANI_CMD_SETZ_VAR          44 // SETZ_VAR
#define ANI_CMD_MODZ              45 // MODZ
#define ANI_CMD_MODZ_VAR          46 // MODZ_VAR
#define ANI_CMD_SETSCALE          47 // SETSCALE
#define ANI_CMD_SETSCALE_VAR      48 // SETSCALE_VAR
#define ANI_CMD_MODSCALE          49 // MODSCALE
#define ANI_CMD_MODSCALE_VAR      50 // MODSCALE_VAR
#define ANI_CMD_SETROT            51 // SETROT
#define ANI_CMD_SETROT_VAR        52 // SETROT_VAR
#define ANI_CMD_MODROT            53 // MODROT
#define ANI_CMD_MODROT_VAR        54 // MODROT_VAR
#define ANI_CMD_SETFADE           55 // SETFADE
#define ANI_CMD_SETFADE_VAR       56 // SETFADE_VAR
#define ANI_CMD_MODFADE           57 // MODFADE
#define ANI_CMD_MODFADE_VAR       58 // MODFADE_VAR
#define ANI_CMD_SETCOL            59 // SETCOL
#define ANI_CMD_SETCOL_VAR        60 // SETCOL_VAR
#define ANI_CMD_MODCOL            61 // MODCOL
#define ANI_CMD_MODCOL_VAR        62 // MODCOL_VAR
#define ANI_CMD_SETX              63 // SETX
#define ANI_CMD_SETX_VAR          64 // SETX_VAR
#define ANI_CMD_MODX              65 // MODX
#define ANI_CMD_MODX_VAR          66 // MODX_VAR
#define ANI_CMD_SETY              67 // SETY
#define ANI_CMD_SETY_VAR          68 // SETY_VAR
#define ANI_CMD_MODY              69 // MODY
#define ANI_CMD_MODY_VAR          70 // MODY_VAR
#define ANI_CMD_SETVIEWROT        71 // SETVIEWROT
#define ANI_CMD_SETVIEWROT_VAR    72 // SETVIEWROT_VAR
#define ANI_CMD_MODVIEWROT        73 // MODVIEWROT
#define ANI_CMD_MODVIEWROT_VAR    74 // MODVIEWROT

#define ANI_ARG_X                 0x7F000000
#define ANI_ARG_Y                 0x7F000001
#define ANI_ARG_EOL               0x7F000002
#define ANI_ARG_VAR               0x7F000003

#define ANI_OP_PLUS               0
#define ANI_OP_MINUS              1
#define ANI_OP_MULT               2
#define ANI_OP_DIV                3
#define ANI_OP_MOD                4
#define ANI_OP_AND                5
#define ANI_OP_OR                 6

#define CHECK_MOVEPATH_NAME(c,t,n) if (!strcmp((t),#n)) (c) = ANI_PATH_MOVE_##n
#define CHECK_PATH_NAME(c,t,n) if (!strncmp((t),#n,sizeof(#n)-1)) \
                                 (c) = ANI_PATH_##n + get_path_for_word(&t[sizeof(#n)-1])
#define CHECK_CMD_NAME(c,t,n) if (!strncmp((t),#n,sizeof(#n)-1)) \
                                (c) = ANI_CMD_##n + get_cmd_for_word(&t[sizeof(#n)-1])
#define CHECK_ARG_NAME(c,t,n) if (!strcmp((t),#n)) (c) = ANI_ARG_##n
#define CHECK_OP_NAME(c,t,n) if (!strcmp((t),#n)) (c) = ANI_OP_##n

typedef struct ani_inst                     /* animation instance information */
{
  ani_info_t *anim;                                      /* anim info pointer */
  
  int32 obj;                                                /* current object */
  int32 old_rot;                                         /* previous rotation */
  int32 old_dir;                                        /* previous direction */
  int32 old_speed;                                          /* previous speed */
  int32 old_frame;                                          /* previous frame */
  
  int32 pause_until;                                     /* how long to pause */
  int32 pause_count;                                   /* current pause count */
  int32 *anipos;                                             /* animation pos */
  
  int32 prev_pause_until;                       /* previous pause_until value */
  int32 prev_pause_count;                       /* previous pause_count value */
  int32 *prev_anipos;                                /* previous anipos value */
  
  int32 track_pause_until;                               /* how long to pause */
  int32 track_pause_count;                       /* current track pause count */
  int32 *trackpos;                                               /* track pos */

  int32 stored_var;                                        /* stored variable */
}
ani_inst_t;  

#define ANI_MAX_ANIMS         100      /* maximum number of conurrent sprites */
#define ANI_DEF_PREFIX        "AN"       /* gfx file prefix if none specified */
#define ANI_DEF_FILETYPE      "ani"     /* filetype for sprite animation file */

#define ANI_RUNMODE_ANIM         0
#define ANI_RUNMODE_TRACK        1

#define ANI_RUN_CONTINUE         0
#define ANI_RUN_FINISH           1
#define ANI_RUN_REVERTED         2
#define ANI_RUN_CHANGE_DIRECTION 3

#define ANI_FLOAT_MULT           0.001f

/* FUNCTIONS */

void   ani_init(void);
void   ani_term(void);
int    ani_get_obj(uint32 inst);                          /* anim information */
void   ani_setevent(obj_inst_t *obj_inst, int event);     /* process an event */
int32  ani_getattribute(uint32 inst_ref, int attribute);  /* get an attribute */
int    ani_animate(obj_inst_t *obj_inst);                      /* object info */
uint32 ani_obj_create_str(char *string);           /* anim string description */
void ani_inst_reset(uint32 info);                         /* reset animations */
void   ani_obj_free(uint32 info);                         /* anim information */
uint32 ani_inst_create(uint32 info);                      /* anim information */
void   ani_inst_free(uint32 info);               /* anim instance information */

#endif
