#ifndef JOGGLE_H
#define JOGGLE_H

#define HIGHSCORE_FREQUENCY   1800                              /* 30 seconds */


#define RND_DEF_PREFIX        "RD"                       /* round file prefix */
#define RND_DEF_FILETYPE      "rnd"                /* filetype for round file */
#define GAM_DEF_FILETYPE      "gam"                 /* filetype for game file */

#define MAX_HIGHLIGHT         10

#define LEFT_MARGIN           32
#define RIGHT_MARGIN          448
#define TOP_MARGIN            32
#define BOTTOM_MARGIN         448
#define GRID_SIZE             32           /* Size of a grid square in pixels */

#define XY_TO_SQUARE(x,y,w) (((y) - (TOP_MARGIN+GRID_SIZE/2))/GRID_SIZE) * (w) + \
                            (((x) - (LEFT_MARGIN+GRID_SIZE/2))/GRID_SIZE)

#define DIGITAL_MOVEMENT      4

#define CLOCK_SEGMENTS       12

#define HISCORES             10
#define HISCORE_COLOURS      3

typedef enum
{
  RND_ACT_SHOW_OBJECTIVE = 0,
  RND_ACT_PLAY,
  RND_ACT_PAUSE,
  RND_ACT_END,
  RND_ACT_LAYOUT
}
activity_t;

#define RND_END_MILLIS       2000

#define OBJ_TYPE_MASK               0x000000FF
#define OBJ_MIN_SCORE               0x00000000
#define OBJ_MIN_WORDS_STARTING_WITH 0x00000001
#define OBJ_JOGGWORD                0x00000002
#define OBJ_MIN_THREE_LETTER_WORDS  0x00000003
#define OBJ_MIN_FOUR_LETTER_WORDS   0x00000004
#define OBJ_MIN_FIVE_LETTER_WORDS   0x00000005
#define OBJ_MIN_SIX_LETTER_WORDS    0x00000006
#define OBJ_CLEARBOARD              0x0000000A

#define OBJ_DROP_MASK               0x00000F00
#define OBJ_DROP_LETTERS            0x00000000
#define OBJ_LEAVE_LETTERS           0x00000100
#define OBJ_REPLACE_LETTERS         0x00000200

#define OBJ_FLAG_MASK               0x000FF000
#define OBJ_FLAG_INVALID_DEDUCT     0x00001000
#define OBJ_FLAG_NO_DUPLICATES      0x00002000

#define OBJ_MISC_MASK               0x00F00000
#define OBJ_FLAG_RANDOM_DELAY       0x00100000
#define OBJ_FLAG_INFINITE           0x00200000
#define OBJ_FLAG_LAYOUT             0x00400000

typedef enum
{
  HUMAN = 0,
  CPU,
  RETIRED,
  GOING,
  GONE
}
player_t;

typedef struct
{
  unsigned char letter;
  unsigned char collectable;
  int           orig_square;
  int           owner;
  uint32        action;
  int32         x;
  int32         y;
  obj_inst_t   *tile;
}
grid_square_t;

#define COL_NONE       0
#define COL_MULT_TWO   'A'
#define COL_MULT_THREE 'B'

typedef struct
{
  player_t      type;
  int           score;
  int           hi_word_score;
  int           hi_word_length;
  int           square;
  int32         x;
  int32         y;
  int32         colour;
  int           cur_delay;
  unsigned char chain[50];
  int           chain_pos;
  unsigned char word[50];
  int           objective_count;
  int           cont;
  int           inactivity;
  obj_inst_t   *status_area;
}
player_info_t;

typedef struct
{
  int32 x;
  int32 y;
  int32 rot;
  int32 colour;
}
clock_info_t;

typedef struct
{
  unsigned char  chain[20];
  int            length;
  unsigned char *clue;
}
joggword_info_t;

typedef struct
{
  int score;
  int hi_word_score;
  int hi_word_length;
  unsigned char initials[4];
}
hiscore_info_t;

#define MAX_JOGGWORDS 100

#define DEFAULT_GAME "ENGLISH"

#define RST_MAX    10

#define TXT_PAUSED                      0
#define TXT_LOADING                     1
#define TXT_ROUND_NUM                   2
#define TXT_READY                       3
#define TXT_TIME_UP                     4
#define TXT_START_TO                    5
#define TXT_OBJECTIVE                   6
#define TXT_SUCCESS                     7
#define TXT_FAILURE                     8
#define TXT_TIME_LIMIT                  9
#define TXT_REPLACE_LETTERS             10
#define TXT_PLAY                        11
#define TXT_CONTINUE                    12
#define TXT_DESCRIPTION                 13
#define TXT_LEAVE_LETTERS               14
#define TXT_INVALID_DEDUCT              15
#define TXT_NO_DUPLICATES               16
#define TXT_TILE_LIMIT                  17
#define TXT_START_GAME                  18
#define TXT_HIGH_SCORES                 19
#define TXT_CONFIG                      20
#define TXT_HIGH_SCORE_HEADING          21
#define TXT_SCORE                       22
#define TXT_WORD_SCORE                  23
#define TXT_WORD_LENGTH                 24
#define TXT_GOT_HIGH_SCORE              25
#define TXT_ENTER_NAME                  26

#define TXT_OBJ_TILES_LEFT              27
#define TXT_OBJ_CLEARBOARD_RESULTS      28
#define TXT_OBJ_RESULT                  29

#define TXT_OBJ_MIN_SCORE               30
#define TXT_OBJ_MIN_WORDS_STARTING_WITH 31
#define TXT_OBJ_MIN_THREE_LETTER_WORDS  33
#define TXT_OBJ_MIN_FOUR_LETTER_WORDS   34
#define TXT_OBJ_MIN_FIVE_LETTER_WORDS   35
#define TXT_OBJ_MIN_SIX_LETTER_WORDS    36
#define TXT_OBJ_CLEARBOARD              40

#define TXT_VIDSELECT_NTSC              50
#define TXT_VIDSELECT_PAL               51
#define TXT_PERCENT_COMPLETE            52

#define TXT_MAX               100

#define WML_MAX               10

#define BLANK_LETTER          ' '

#define ACT_NOTHING          0x00000000 /* Tile not removed                   */
#define ACT_RANDOM_DELAY     0x00000008 /* Wait a random time and then 'fade' */
#define ACT_REPLACE          0x10000000 /* Replace with rnd A-Z (un-weighted) */
#define ACT_LEAVE            0x20000000 /* Leave the existing letter in place */

#define BON_NONE             0x00000000 /* No bonuses                         */
#define BON_WORD_LENGTH      0x00000001 /* Bonus for word length              */
#define BON_SAME_COLOUR      0x00000002 /* Bonus for all letters same colour  */
#define BON_FIRST_COMPLETER  0x00000004 /* Bonus for the first task completer */

#define ITM_NOTHING                   0
#define ITM_LOGO                      1 /* Game logo                          */
#define ITM_INGAME_BACKDROP_BOARD     2 /* Board backdrop (512x480 = 512x512) */
#define ITM_INGAME_BACKDROP_STATUS    3 /* Stats backdrop (128x480 = 128x512) */
#define ITM_SECOND_DOWN               5 /* Item to create when second 'ticks' */
#define ITM_STATUS_AREA               6 /* Status area, where scores written  */
#define ITM_TILE                      7 /* A letter tile                      */
#define ITM_TITLE_BACKDROP_BOARD      8 /* Title screens backdrop             */
#define ITM_TITLE_BACKDROP_STATUS     9 /* Title screens backdrop             */
#define ITM_10SECOND_DOWN            10 /* Item created last 10 seconds tick  */
#define ITM_TILE_CLEAR               11 /* Created for each tile that going   */
#define ITM_3_LETTER_WORD            20 /* Three letter word                  */
#define ITM_4_LETTER_WORD            21 /* Four letter word                   */
#define ITM_5_LETTER_WORD            22 /* Five letter word                   */
#define ITM_6_LETTER_WORD            23 /* Six letter word                    */
#define ITM_7_LETTER_WORD            24 /* Seven letter word                  */
#define ITM_BIG_WORD                 25 /* Bigger than seven letters          */
#define MAX_ITEMS                   100

#define STATUS_AREA_X               561
#define STATUS_AREA_Y               205

#define CLOCK_Z                3
#define GRID_Z                 3

#ifdef JOGGLE_C

clock_info_t clock_info[CLOCK_SEGMENTS] = {{560, 24,  0,1},
                                           {590, 32, 30,1},
                                           {612, 54, 60,1},
                                           {620, 84, 90,1},
                                           {612,114,120,1},
                                           {590,136,150,1},
                                           {560,144,180,1},
                                           {530,136,210,1},
                                           {508,114,240,1},
                                           {500, 84,270,1},
                                           {508, 54,300,1},
                                           {530, 32,330,1}};

int32 word_multiplier[WML_MAX] = {10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000};

hiscore_info_t hiscore[HISCORES] = {{1000,100,3,"JOG"},
                                    { 900,100,3,"GLE"},
                                    { 800,100,3,"IST"},
                                    { 700,100,3,"HEG"},
                                    { 600,100,3,"REA"},
                                    { 500,100,3,"TES"},
                                    { 400,100,3,"TWO"},
                                    { 300,100,3,"RDG"},
                                    { 200,100,3,"AME"},
                                    { 100,100,3,"EVA"}};

uint32 hiscore_colours[HISCORE_COLOURS] = {0xFF6666,0x33CC66,0x6699CC};

typedef enum
{
  MAIN_STATE_QUIT = 0,
  MAIN_STATE_VIDSELECT,
  MAIN_STATE_MENU,
  MAIN_STATE_HIGHSCORE,
  MAIN_STATE_CONFIG,
  MAIN_STATE_GAME
}
main_state_t;

#define VIDSELECT_ROWS 2

#define MENU_ROWS    3

#define CONFIG_ROWS        10
#define MAX_CONFIG_COLUMNS 5

int32 config_columns[CONFIG_ROWS] = {1,1,1,1,1,1,1,1,1,1};
int32 config_value[CONFIG_ROWS][MAX_CONFIG_COLUMNS];

#endif

#endif
