#ifndef DCT_H
#define DCT_H
    
#define TWO_CHAR_TABLE_ENTRIES   (26*26)
#define TWO_CHAR_TABLE_SIZE      (TWO_CHAR_TABLE_ENTRIES*sizeof(unsigned char))
#define TWO_CHAR_TABLE_OFFSET    0
#define THREE_CHAR_TABLE_ENTRIES (26*26*26)
#define THREE_CHAR_TABLE_SIZE    (THREE_CHAR_TABLE_ENTRIES*sizeof(unsigned char *))
#define THREE_CHAR_TABLE_OFFSET  TWO_CHAR_TABLE_SIZE
#define WORD_TABLE_OFFSET        THREE_CHAR_TABLE_OFFSET + THREE_CHAR_TABLE_SIZE

#define DCT_MIN_WORD_LENGTH      3
#define DCT_NO_MORE_WORDS_MARKER 0xFFFF
#define DCT_DEF_FILETYPE         "dct"

typedef unsigned char  *dict_t;
typedef unsigned char  *two_char_table;
typedef unsigned char   two_char_table_entry;
typedef unsigned char **three_char_table;
typedef unsigned char  *three_char_table_entry;

dict_t dct_load(char *filename);
void   dct_free(dict_t dictionary);
int    dct_find(dict_t dictionary, unsigned char *word);

#endif
