#ifndef VID_H
#define VID_H

#if defined(DEBUG_PERFORMANCE) && !defined(_WIN32)
#define VID_PERFORMANCE(r,g,b) vid_border_color(r,g,b)
#else
#define VID_PERFORMANCE(r,g,b)
#endif

#define VID_INIT_PLAYAREA_W 640
#define VID_INIT_PLAYAREA_H 480
#define VID_INIT_VIEW_W     640
#define VID_INIT_VIEW_H     480
#define VID_INIT_VIEW_X     0 + (VID_INIT_VIEW_W/2)
#define VID_INIT_VIEW_Y     0 + (VID_INIT_VIEW_H/2)
#define VID_INIT_VIEW_ROT   0

#define VID_SCREEN_W        640
#define VID_SCREEN_H        480

#define VID_RAINBOW_COLOUR   0x01000000
#define VID_BLACK_BORDER     0x02000000
#define VID_FIRE_COLOUR      0x04000000
#define VID_EXPLOSION_COLOUR 0x08000000
#define VID_COLOUR_CHANGE    0x10000000
#define VID_COLOUR_INC       0x20000000
#define VID_RGB_MASK         0x00FFFFFF

#ifdef VID_C
int   vid_playarea_w;
int   vid_playarea_h;
int   vid_gun_screen;
int   view_x;
int   view_y;
int   view_w;
int   view_half_w;
int   view_h;
int   view_half_h;
int   view_rot;
float view_scale;
float view_mid_x;
float view_mid_y;
float view_rcos;
float view_rsin;
int   curr_frame = 0;
#else
extern int   vid_playarea_w;
extern int   vid_playarea_h;
extern int   vid_gun_screen;
extern int   view_x;
extern int   view_y;
extern int   view_w;
extern int   view_half_w;
extern int   view_h;
extern int   view_half_h;
extern int   view_rot;
extern float view_scale;
extern float view_mid_x;
extern float view_mid_y;
extern float view_rcos;
extern float view_rsin;
extern int curr_frame;
#endif

/* FUNCTIONS */

void vid_screen_init(int mode);
void vid_screen_begin_rgb(uint32 colour, int opaque);
void vid_screen_begin(float red, float green, float blue, int opaque);
void vid_screen_continue();
void vid_screen_end(void);
void vid_screen_term(void);

void vid_view_set(int x, int y, int w, int h, int rot);
void vid_playarea_set(int w, int h);

void vid_shadow(float fade, float z, uint32 colour);
void vid_box(int x, int y, int w, int h, float fade, float z, uint32 colour);

#endif
