#define DCT_C

/* BOOGLE Dictionary Functions */

#include <kos.h>

#include "utils.h"
#include "dict.h"

/* dct_load _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

dict_t dct_load(char *filename)
{
  dict_t dct_data = 0;

  DBG_ENTRY(99,("dct_load(%s)",filename?filename:"NULL_POINTER"));

  if (filename)
  {
    FILE *fp = 0;

    unsigned char name[256];

    sprintf(name,"%s/game/%s.%s",data_dir,filename,DCT_DEF_FILETYPE);

    if ((fp = fopen(name,"rb")))
    {
      long size = 0;

      fseek(fp, 0, 2);

      size = ftell(fp);

      fseek(fp, 0, 0);

      dct_data = (dict_t)utl_malloc(size);

      if (fread(dct_data, sizeof(unsigned char), size, fp) == size)
      {
        int fixed = 0;

        int entry;
          
        three_char_table tct = (three_char_table)(&dct_data[THREE_CHAR_TABLE_OFFSET]);

        /* ----------------------------------- */
        /* Now need to fix up the 3 char table */
        /* ----------------------------------- */

        for (entry=0;entry<THREE_CHAR_TABLE_ENTRIES;entry++)
        {
          if (tct[entry])
          {
            tct[entry] = (three_char_table_entry)((unsigned int)tct[entry]+(unsigned int)dct_data);

            #if 0 /* DEBUG */
            if (!fixed)
            {
              if ((unsigned int)tct[entry]-(unsigned int)dct_data != WORD_TABLE_OFFSET)                    
              {
                printf("ERROR INVALID DICTIONARY '%s'\n",filename);
                free(dct_data);
                dct_data = 0;
                break;
              }
            }
            #endif
              
            fixed++;
          }
        }

        DBG_PRINT(99,("Fixed up %d entries (dct_data=%p)",fixed,dct_data));
      }
      DBG_ELSE(99,("fread(%p,%d,%ld,%p) failed",dct_data,sizeof(unsigned char),size,fp));

      fclose(fp);
    }
    DBG_ELSE(99,("fopen(%s,\"rb\" failed",filename));
  }
  DBG_ELSE(99,("filename was NULL"));

  DBG_EXIT(99,("dct_load rc=%p",dct_data));

  return dct_data;
}

/* dct_free _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void dct_free(dict_t dictionary)
{
  DBG_ENTRY(99,("dct_free(%p)",dictionary));

  utl_free(dictionary);

  DBG_EXIT(99,("dct_free"));

  return;
}

/* dct_bsearch ______________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

int dct_bsearch(unsigned char *key, int key_len, unsigned char *a, int len, int beg_i, int end_i)
{
  int cur_i = beg_i + (end_i - beg_i) / 2;

  int mc = memcmp(key,&a[len*cur_i],key_len);

  DBG_PRINT(99,("key='%s' key_len=%d len=%d beg_i=%d end_i=%d cur_i=%d",key, key_len, len, beg_i, end_i, cur_i));

  if (!mc)
    return 1;
  if (beg_i > end_i)
    return 0;
  if (mc > 0)
    return dct_bsearch(key, key_len, a, len, cur_i+1, end_i);

  return dct_bsearch(key, key_len, a, len, beg_i, cur_i-1);
}

/* dct_find _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

int dct_find(dict_t dictionary, unsigned char *word)
{
  int found = 0;

  DBG_ENTRY(99,("dct_find(%p,%s)",dictionary,(char *)word?(char *)word:"NULL_POINTER"));

  if (dictionary && word)
  {
    int word_len = strlen(word);

    if (word_len >= DCT_MIN_WORD_LENGTH)
    {
      three_char_table tct   = (three_char_table)(&dictionary[THREE_CHAR_TABLE_OFFSET]);
      unsigned char   *data  = tct[((word[0]-'A')*676)+((word[1]-'A')*26)+(word[2]-'A')];

      if (data)
      {
        unsigned short count = 0;
        int cur_len = 0;

        word_len = word_len - DCT_MIN_WORD_LENGTH;
        word     = &word[DCT_MIN_WORD_LENGTH];
        
        /* --------------------------- */
        /* find the appropriate length */
        /* --------------------------- */
        while(cur_len < word_len)
        {
          count = *data|*(data+1)<<8;

          DBG_PRINT(99,("count=%d",count));

          if (count == DCT_NO_MORE_WORDS_MARKER)
            break;
          else
            data += (count * cur_len) + sizeof(unsigned short);

          cur_len++;
        }

        /* --------------------------------------- */
        /* if there are any of that word length... */
        /* --------------------------------------- */
        if (cur_len == word_len)
        {
          count = *data|*(data+1)<<8;

          DBG_PRINT(99,("cur_len=%d count=%d",cur_len,count));

          if (count)
            found = dct_bsearch(word,word_len,data+sizeof(unsigned short),cur_len,0,count);
        }
      }
    }
    DBG_ELSE(99,("word less than %d characters", DCT_MIN_WORD_LENGTH));
  }
  DBG_ELSE(99,("either dictionary=%p or word=%p was NULL",dictionary,word));

  DBG_EXIT(99,("dct_find rc=%d",found));

  return found;
}
#undef DCT_C

