#define UTL_C

#include <kos.h>

#include "utils.h"

/* utl_malloc _______________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void *utl_malloc(int size)
{
  void *area = malloc(size);
  
  DBG_ENTRY(99,("utl_malloc(%d)",size));
  
  if (area)
    memset(area,0x00,size);
  
  DBG_EXIT(99,("utl_malloc rc=%p",area));
    
  return(area);
}

/* utl_realloc ______________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void *utl_realloc(void *area, int size)
{
  void *new_area = realloc(area, size);
  
  DBG_ENTRY(99,("utl_realloc(%p,%d)",area,size));
  
  DBG_EXIT(99,("utl_realloc rc=%p",new_area));
    
  return(new_area);
}


/* utl_free _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void utl_free(void *area)
{
  DBG_ENTRY(99,("utl_free(%p)",area));

  if (area)
    free(area);

  DBG_EXIT(99,("utl_free"));
}

#undef UTL_C
