#ifndef IMG_H
#define IMG_H

typedef struct img                                         /* image structure */
{
  pvr_poly_hdr_t  header;                                       /* pvr header */
  pvr_ptr_t       texture;                                 /* texture pointer */
  uint32          width;                                             /* width */
  uint32          height;                                           /* height */
  float           u2;
  float           v2;
  uint8           loaded;                          /* number of load requests */
}
img_t;

#define IMG_MAX_IMGS          100          /* maximum number of conurrent imgs */
#define IMG_DEF_PREFIX        "IM"       /* gfx file prefix if none specified */
#define IMG_DEF_FILETYPE      "img"      /* filetype for img description file */
#define IMG_DEF_GFX_FILETYPE  "png"        /* filetype for tile graphics file */

/* FUNCTIONS */

void  img_init(void);

void  img_term(void);

uint8 img_load(uint8 img);                                      /* img number */
                   
void  img_unload(uint8 img);                                    /* img number */

int   img_render(uint32 img,                                    /* img number */
                 int32 map_x,              /* map x position (centre of tile) */
                 int32 map_y,              /* map y position (centre of tile) */
                 float z_order,                       /* z-value for the tile */
                 int32 rotation,                       /* rotation in degrees */
                 float scale,                             /* scale the object */
                 float fade,                              /* colour intensity */
                 uint32 colour);                      /* r << 16 | g << 8 | b */

int   img_render_obj(uint32 info,                          /* img information */
                     uint32 unused,  
                     int32 map_x,          /* map x position (centre of tile) */
                     int32 map_y,          /* map y position (centre of tile) */
                     float z_order,                   /* z-value for the tile */
                     int32 rotation,                   /* rotation in degrees */
                     float scale,                         /* scale the object */
                     float fade,                          /* colour intensity */
                     uint32 colour);                  /* r << 16 | g << 8 | b */
                   
uint32 img_getwidth(uint8 img);                                 /* img number */
uint32 img_getwidth_obj(uint32 info);                      /* img information */

uint32 img_getheight(uint8 img);                                /* img number */
uint32 img_getheight_obj(uint32 info);                     /* img information */

uint32 img_obj_create_str(char *string);          /* image string description */

void img_obj_free(uint32 info);                            /* img information */

uint32 img_inst_create(uint32 info);                       /* img information */

void img_inst_free(uint32 info);                  /* img instance information */

#endif
