#ifndef CNT_H
#define CNT_H

typedef struct cnt_info          /* player structure */
{
  maple_device_t *dev;           /* maple device being used     */
  int             port;          /* maple port plugged into     */
  uint8           type;          /* type of device (cont etc)   */
  uint32          buttons;       /* buttons being pressed...    */
  uint32          prev_buttons;  /* ...and previous ones        */
  int             xmod;          /* gun calib x modification    */
  int             ymod;          /* gun calib y modification    */
  int             x;             /* joystick x diff / mouse x   */
  int             y;             /* joystick y diff / mouse y   */
  int             cnt_x;         /* view based current x pos    */
  int             cnt_y;         /* view based current y pos    */
}
cnt_info_t;

#define CNT_CONT      0x00    /* standard controller */
#define CNT_GUN       0x01    /* lightgun            */
#define CNT_KBD       0x02    /* keyboard            */
#define CNT_MOUSE     0x04    /* mouse               */
#define CNT_FISHING   0x08    /* fishing controller  */
#define CNT_DEVMASK   0x0F    /* mask in case other bits used */

/* FUNCTIONS */

int cnt_enum(cnt_info_t *player);
int cnt_init(cnt_info_t *player);
void cnt_state(cnt_info_t *cont);
void cnt_state_all(cnt_info_t *cont);

#endif
