#define CNT_C

#include <kos.h>

#include "utils.h"
#include "cont.h"
#include "video.h"

/* cnt_enum _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

int cnt_enum(cnt_info_t *player) {
  int port, unit;

  int found_conts = 0;

  for (port=0; port < MAPLE_PORT_COUNT; port++)
    for (unit=0; unit < MAPLE_UNIT_COUNT; unit++)
    {
      player[found_conts].port = port;

	  maple_device_t * dev = maple_enum_dev(port, unit);
	  
      if (dev->info.functions == MAPLE_FUNC_CONTROLLER) {
        maple_devinfo_t *info = &maple_state.ports[port].units[unit].info;

        if (dev->info.functions == MAPLE_FUNC_LIGHTGUN)
        {
          player[found_conts].type = CNT_GUN;
          player[found_conts].xmod = 0;
          player[found_conts].ymod = 0;
        }
        else if (strstr(info->product_name,"Fishing"))
          player[found_conts].type = CNT_FISHING;

        player[found_conts++].dev = maple_enum_dev(port,unit);

        unit = MAPLE_UNIT_COUNT;
      }
      else if (dev->info.functions == MAPLE_FUNC_MOUSE) {
        player[found_conts].type = CNT_MOUSE;

        player[found_conts++].dev = maple_enum_dev(port,unit);

        unit = MAPLE_UNIT_COUNT;
      }
      else if (dev->info.functions == MAPLE_FUNC_KEYBOARD) {
        player[found_conts].type = CNT_KBD;

        player[found_conts++].dev = maple_enum_dev(port,unit);

        unit = MAPLE_UNIT_COUNT;
      }
    }
  
  return found_conts;
}

/* cnt_init _________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

int cnt_init(cnt_info_t *player)
{
  memset(player,0x00,sizeof(cnt_info_t)*(MAPLE_PORT_COUNT+1));

  return(cnt_enum(player));
}

/* cnt_state ________________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void cnt_state(cnt_info_t *player)
{
  player->prev_buttons = player->buttons;

  if (!(player->type & CNT_KBD))
  {
    cont_state_t *stat = maple_dev_status(player->dev);
    mouse_state_t *mstat = (mouse_state_t *)stat;

    if (stat)
    {
      switch(player->type & CNT_DEVMASK)
      {
        case CNT_MOUSE:
          player->buttons = mstat->buttons;
          /* need something here for x / y */
          break;

        case CNT_GUN:
        {
          uint32 repeat = (stat->buttons & 0xffff0000) >> 16;

          player->buttons = stat->buttons;

          if (repeat == 0x0001)
            vid_gun_screen = 1;
          else if ((player->buttons & CONT_A) && !(player->prev_buttons & CONT_A))
          {
            if ((stat->joyx == stat->joy2x) && (stat->joyy == stat->joy2y))
              player->x = player->cnt_x = player->y = player->cnt_y = -999;
            else
            {
              player->x = stat->joyx;
              player->y = stat->joyy;
              if (player->x < 300)
                player->x += 860;
              player->cnt_x = view_x + (int)((float)view_w*((float)(player->x-vid_min_x)/vid_x_delta)) + player->xmod;
              player->cnt_y = view_y + (int)((float)view_h*((float)(player->y-vid_min_y)/vid_y_delta)) + player->ymod;
            }
          }
        }
        break;

        default:
          player->buttons = stat->buttons;
          player->x = stat->joyx;
          player->y = stat->joyy;
          player->cnt_x = view_x + view_half_w+(int)(((float)stat->joyx/128.0f)*(float)view_half_w);
          player->cnt_y = view_y + view_half_h+(int)(((float)stat->joyy/128.0f)*(float)view_half_h);
          break;
      }
    }
  }
  else /* KEYBOARD */
  {
    int key = kbd_get_key();

    player->buttons = 0;

    switch(key)
    {
      case -1:
        break;

      /* F1 == START */

      case 14848:
        player->buttons = CONT_START;
        break;

      /* F12 == A & B */

      case 17664:
        player->buttons = (CONT_A | CONT_B);
        break;

      /* ENTER == FIRE */

      case 13:
        player->buttons = CONT_A;
        break;

      /* SOMETHING ELSE */

      default:
        //printf("%d",key);
        break;
    }
  }

  return;
}

/* cnt_state_all ____________________________________________________________ */
/*                                                                            */
/* __________________________________________________________________________ */

void cnt_state_all(cnt_info_t *player)
{
  int n = 0;

  while(player[n].dev)
  {
    cnt_state(&player[n]);

    n++;
  }

  return;
}

#undef CNT_C
