#ifndef __SMASHH__
#define __SMASHH__

#include <kos.h>

#define MAXIMUM_PLAYERS 3

#define TRUE -1
#define FALSE 0

#define EFFECT_ENEMYDEATH	0
#define EFFECT_GEMINISPLIT	1
#define EFFECT_BOMBDEATH	2
#define EFFECT_BULLETHIT	3
#define EFFECT_ROCKETHIT	4
#define EFFECT_COMPLETEALL	5

#define WEAPON_BULLET	0
#define WEAPON_ROCKET	1

#define ITEM_1UP	0
#define ITEM_MINE	1
#define ITEM_MONEY	2
#define ITEM_SILVER	3
#define ITEM_GOLD	4
#define ITEM_ROCKET	5

//KOS 2.X : Replace #defines of wav sounds to sfxhnd_t structures :D
sfxhnd_t SAMPLE_PLAYERSHOOT;
sfxhnd_t SAMPLE_ENEMYDEATH;
sfxhnd_t SAMPLE_ENEMYHURT;
sfxhnd_t SAMPLE_GEMINISPLIT;
sfxhnd_t SAMPLE_PLAYERDEATH;
sfxhnd_t SAMPLE_LEVELSTART;
sfxhnd_t SAMPLE_ROOMDONE;
sfxhnd_t SAMPLE_ITEMGRAB;
sfxhnd_t SAMPLE_ITEMGRABMINE;
sfxhnd_t SAMPLE_ITEMGRAB1UP;
sfxhnd_t SAMPLE_BOSSHURT;

#define GAMEMODE_NORMAL		0
#define GAMEMODE_VS			1
#define GAMEMODE_NORMALVS	2

#define DIFFICULTY_EASY		0
#define DIFFICULTY_NORMAL	1
#define DIFFICULTY_HARD		2
#define DIFFICULTY_SADISTIC	3

#define MAX_ENEMIES 30
#define MAX_BULLETS 50
#define MAX_PLAYERS 4

#define DISPLAY_WIDTH 640
#define DISPLAY_HEIGHT 480

#define SNAKEMAN	0
#define SKULLMAN	1
#define GEMINIMAN	2
#define WOODMAN		3
#define NEEDLEMAN	4
#define BOMBMAN		5
#define	TOPMAN		6
#define PHARAOHMAN	7
#define DRWILY		99

#define	UP	0
#define	DOWN	1
#define	LEFT	2
#define	RIGHT	3
#define UPLEFT	4
#define UPRIGHT	5
#define	DOWNLEFT	6
#define DOWNRIGHT	7

#define WALKING		0
#define STANDING	1

// item struct..
typedef struct
{
	int8 Active;
	uint8 Type;
	uint32 XPos, YPos;

} _item;

// the room..
typedef struct
{
	int8 Completed;
	int8 BossRoom;
	uint8 EnemiesPerWave;
	uint8 EnemiesPos;
	uint8 SpawnDelay;
	uint8 SpawnDelayPos;
	uint8 Waves;
	uint8 CurrentWave;
	uint8 LastDoorUsed;

	uint8 North, South, East, West;
	uint8 Floor, Overlay;

	_item Items[MAX_ENEMIES];

} _room;

// Player bullet..
typedef struct
{
	uint8 Type;
	int8 Active;
	uint32 XPos, YPos;
	uint8 Owner;

	uint8 Direction;
	uint8 Speed;
}_playerbullet;

// Animation..
typedef struct
{
	pvr_ptr_t Frames[10]; //replaced uint32 for pvr_ptr_t :)

	int NumOfFrames;
    int LoopFrame;
	int Speed;
}Animation;

// An effect..
typedef struct
{
	int8 Active;
	uint8 Type;
	uint32 XPos, YPos;
	uint8 Duration;
	uint8 DurationPos;
	uint32 Width, Height;

	uint8 AnimFrame;
	uint8 AnimPos;

} _effect;

// The enemy Struct..
typedef struct
{
	uint8 Type;
	int32 Life;
	uint32 Points;

	uint8 PlayerTarget;

	int8 Active;
	uint32 XPos, YPos;
	float WalkingSpeed;

	uint8 CurrentAction;
	uint8 WalkingDirection;

	uint8 AnimFrame;
	uint8 AnimPos;

	uint32 Width, Height;
	uint32 DrawWidth, DrawHeight;

} _enemy;

// The player struct..
typedef struct
{
	int8 Active;
	int8 Alive;
	uint32 XPos, YPos;
	uint8 WalkingSpeed;

	uint8 Weapon;

	int8 SkipFrame;

	int8 Invincible;
	uint32 InvDuration;
	uint32 InvPosition;

	uint8 ShootDelay;
	uint8 ShootPos;

	uint32 DeathReSpawn;
	uint32 DeathReSpawnPos;

	uint8 CurrentAction;
	uint8 WalkingDirection;
	uint8 ShootingDirection;
	uint8 SpeedAdjustment;
	int8 Shooting;

	uint8 TorsoFrame;
	uint8 TorsoAnimPos;
	uint8 LegFrame;
	uint8 LegAnimPos;

	uint8 Lives;
	int Score;

	uint8 ActiveItem;

}_player;

// Control Set struct..
typedef struct
{
	int8 Exit;
	int8 Up, Down, Left, Right;
	int8 UpLeft, UpRight;
	int8 DownLeft, DownRight;

	int8 ShootUp,ShootDown,ShootLeft,ShootRight;

}_controlset;

//For PVR functions, change uint32 for pvr_ptr_t
void ProcessPlayer( int PlayerIndex, int ControlSet );
void UpdateControlSet( uint8 index );
void LoadTextures();
void DrawFloor( pvr_ptr_t floorindex );
void DrawSprite( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight );
void UpdatePlayerLegAnimation( int playerindex );
void DrawPlayerLegs( int playerindex );
void DrawPlayerFrame( Animation Anim, int playerindex, int frame );
void DrawEnemyFrame( Animation Anim, int enemyindex, int frame );
void DrawRedPlayerTorso( int playerindex );
void DrawYellowPlayerTorso( int playerindex );
void DrawGreenPlayerTorso( int playerindex );
void DrawBluePlayerTorso( int playerindex );
void ResetPlayerAnim( int playerindex, int torso );
void UpdatePlayerAnim( Animation Anim, int playerindex, int torso, int reverse );
void UpdateRedPlayerTorsoAnimation( int playerindex );
void UpdateYellowPlayerTorsoAnimation( int playerindex );
void UpdateGreenPlayerTorsoAnimation( int playerindex );
void UpdateBluePlayerTorsoAnimation( int playerindex );
void ProcessPlayers();
void DrawPlayers();
void UpdateControls();
void UpdateAnimation();
void DrawPlayerBullets();
void DrawPlayerBullet( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height );
void SpawnPlayerBullet( int playerindex, int xpos, int ypos, int direction );
void ProcessPlayerBullets();
void DrawRoom();
void DrawOverlay( pvr_ptr_t overlayindex );
int SpawnEnemy( int xpos, int ypos, int direction, int type );
void DrawEnemies();
void DrawSnakeMan( int enemyindex );
void UpdateSnakeManAnimation( int enemyindex );
void UpdateEnemyAnim( Animation Anim, int enemyindex );
void UpdateEnemyAnimations();
void ProcessEnemies();
int EnemyPlayerCollision( int enemyindex, int playerindex );
int BulletEnemyCollision( int enemyindex, int bulletindex );
void CheckforEnemyBulletCollisions();
void CheckforEnemyPlayerCollisions();
void DrawNumber( char * number, int xpos, int ypos, int z );
void DrawLifePanels();
int PadInPort( int port );
void ProcessEffects();
void SpawnEffect( int effecttype, int xpos, int ypos, int width, int height, int duration );
void UpdateEffectAnim( Animation Anim, int explosionindex );
void DrawEffectFrame( Animation Anim, int playerindex, int frame );
void UpdateEffectsAnimations();
void DrawEffects();
void LoadSoundEffects();
void DoSplashScreens();
void DoTitleMenu();
void GameLoop();
void BeginLoadingScreen();
void EndLoadingScreen();
void InitPlayers( int player1, int player2, int player3, int player4 );
int EnemyEnemyCollision( int enemyindex1, int enemyindex2 );
void InitRooms();
void ChangeRoom( int roomindex, int direction );
void ResetEffectAnim( int effectindex );
void KillPlayersInBox( int xpos, int ypos, int width, int height );
int EnemiesActive();
void DoPause( int playerindex );
void DoIntro();
void SpawnItem( int type, int xpos, int ypos );
int ItemPlayerCollision( int itemindex, int playerindex );
void CheckforItemPlayerCollisions();
void DrawItems();
void DrawExitArrow( int direction, int xpos, int ypos, int lit );
int AllRoomsComplete();
void DoWin();
void DoGameOver();
int NearestPlayer( int enemyindex );

#endif
