#include "smashdc.h"
#include "vars.h"

void KillPlayersInBox( int xpos, int ypos, int width, int height )
{
	int i;

	for ( i=0; i<MAX_PLAYERS; i++ )
	{
		if ( Players[i].XPos > xpos && Players[i].XPos < xpos+width )
			if ( Players[i].YPos > ypos && Players[i].YPos < ypos+height )
		{
			if ( Players[i].Lives == 0 )
			{
				// Player is gameover..
			}
			else
			{
				// Player has lost a life..
				Players[i].Lives--;
			}
			//printf( "Players[%d] Hit by death bomb!\n\r", i );
		}
	}
}

void ProcessPlayerDeath( int playerindex )
{
	if ( Players[playerindex].DeathReSpawnPos == Players[playerindex].DeathReSpawn )
	{
		// respawn player..
		Players[playerindex].Alive=TRUE;
		Players[playerindex].DeathReSpawnPos=0;
		Players[playerindex].Invincible=TRUE;
		//printf( "Respawn Player..\n\r" );
	}
	else
		Players[playerindex].DeathReSpawnPos++;

	if ( ControlSets[playerindex].Exit == TRUE )
	{
		StartPressed=TRUE;
		DoPause( playerindex );
	}
}

void ProcessPlayers()
{
	if ( Players[0].Active == TRUE )
	{
		if ( Players[0].Alive == FALSE )
			ProcessPlayerDeath( 0 );
		else
			ProcessPlayer(0, 0);
	}

	if ( Players[0].Active == TRUE )
	{
		if ( Players[1].Alive == FALSE )
			ProcessPlayerDeath( 1 );
		else
			ProcessPlayer(1, 1);
	}

	if ( Players[0].Active == TRUE )
	{
		if ( Players[2].Alive == FALSE )
			ProcessPlayerDeath( 2 );
		else
			ProcessPlayer(2, 2);
	}

	if ( Players[0].Active == TRUE )
	{
		if ( Players[3].Alive == FALSE )
			ProcessPlayerDeath( 3 );
		else
			ProcessPlayer(3, 3);
	}
}

void ChangeDirection( int playerindex, int direction, int animrest )
{
	if ( Players[playerindex].WalkingDirection != direction )
	{
		Players[playerindex].WalkingDirection=direction;
		ResetPlayerAnim( playerindex, FALSE );
	}
}

void ChangeShootingDirection( int playerindex, int direction, int animrest )
{
	if ( Players[playerindex].ShootingDirection != direction )
	{
		Players[playerindex].ShootingDirection=direction;
		ResetPlayerAnim( playerindex, TRUE );
		ResetPlayerAnim( playerindex, FALSE );
	}
}

void MovePlayer( uint8 index, uint32 xamount, uint32 yamount )
{
	if ( Players[index].XPos+xamount > 50 && Players[index].XPos+xamount < 590 )
			Players[index].XPos+=xamount;

	if ( Players[index].YPos+yamount > 100 && Players[index].YPos+yamount < 480 )
			Players[index].YPos+=yamount;
}

void ProcessPlayer( int PlayerIndex, int ControlSet )
{
	if ( ControlSets[PlayerIndex].Exit == TRUE )
	{
		StartPressed=TRUE;
		DoPause( PlayerIndex );
	}

	if ( Players[PlayerIndex].Invincible == TRUE )
	{
		//printf ( "Player is invincable!\n\r" );
		if ( Players[PlayerIndex].SkipFrame == TRUE )
			Players[PlayerIndex].SkipFrame=FALSE;
		else
			Players[PlayerIndex].SkipFrame=TRUE;

		if ( Players[PlayerIndex].InvPosition == Players[PlayerIndex].InvDuration )
		{
			Players[PlayerIndex].Invincible=FALSE;
			Players[PlayerIndex].InvPosition=0;
		}
		else
			Players[PlayerIndex].InvPosition++;
	}
	else
	{
		Players[PlayerIndex].SkipFrame=FALSE;
	}

	if ( Rooms[CurrentRoom].Completed==TRUE )
	{
		//printf ( "able to enter door way....\n\r" );

		if ( Players[PlayerIndex].XPos == 585 )
		{
			if ( Players[PlayerIndex].YPos > 250 &&
				Players[PlayerIndex].YPos < 320 )
					ChangeRoom( Rooms[CurrentRoom].East, RIGHT );
		}
		else if ( Players[PlayerIndex].XPos <= 55 )
		{
			if ( Players[PlayerIndex].YPos > 250 &&
				Players[PlayerIndex].YPos < 320 )
			ChangeRoom( Rooms[CurrentRoom].West, LEFT );
		}
		else if ( Players[PlayerIndex].YPos >= 475 )
		{
			if ( Players[PlayerIndex].XPos > 270 &&
				Players[PlayerIndex].XPos < 365 )
			ChangeRoom( Rooms[CurrentRoom].South, DOWN );
		}
		else if ( Players[PlayerIndex].YPos <= 105 )
		{
			if ( Players[PlayerIndex].XPos > 270 &&
				Players[PlayerIndex].XPos < 365 )
					ChangeRoom( Rooms[CurrentRoom].North, UP );
		}
	}

	if ( ControlSets[ControlSet].ShootUp == FALSE &&
		 ControlSets[ControlSet].ShootDown == FALSE &&
		 ControlSets[ControlSet].ShootLeft == FALSE &&
		 ControlSets[ControlSet].ShootRight == FALSE )
		{
			Players[PlayerIndex].Shooting=FALSE;
			Players[PlayerIndex].ShootPos=0;
		}
	else
		Players[PlayerIndex].Shooting=TRUE;

	// Not Shooting..
	//if ( Players[PlayerIndex].Shooting == FALSE )
	//{
		if ( ControlSets[ControlSet].Left == TRUE &&
			ControlSets[ControlSet].Up == FALSE &&
			ControlSets[ControlSet].Down == FALSE )
		{
			ChangeDirection( PlayerIndex, LEFT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				-(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment), 0 );
		}
		else if ( ControlSets[ControlSet].Right == TRUE &&
			ControlSets[ControlSet].Up == FALSE &&
			ControlSets[ControlSet].Down == FALSE )
		{
			ChangeDirection( PlayerIndex, RIGHT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment), 0 );
		}

		if ( ControlSets[ControlSet].Up == TRUE &&
			ControlSets[ControlSet].Left == FALSE &&
			ControlSets[ControlSet].Right == FALSE )
		{
			ChangeDirection( PlayerIndex, UP, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				0 , -(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}
		else if ( ControlSets[ControlSet].Down == TRUE &&
			ControlSets[ControlSet].Left == FALSE &&
			ControlSets[ControlSet].Right == FALSE )
		{
			ChangeDirection( PlayerIndex, DOWN, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				0 , (Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}

		if ( ControlSets[ControlSet].Up == TRUE &&
			ControlSets[ControlSet].Left == TRUE &&
			ControlSets[ControlSet].Right == FALSE )
		{
			ChangeDirection( PlayerIndex, UPLEFT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				-(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment),
				-(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}
		else if ( ControlSets[ControlSet].Up == TRUE &&
			ControlSets[ControlSet].Left == FALSE &&
			ControlSets[ControlSet].Right == TRUE )
		{
			ChangeDirection( PlayerIndex, UPRIGHT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment),
				-(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}

		if ( ControlSets[ControlSet].Down == TRUE &&
			ControlSets[ControlSet].Left == TRUE &&
			ControlSets[ControlSet].Right == FALSE )
		{
			ChangeDirection( PlayerIndex, DOWNLEFT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				-(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment),
				(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}
		else if ( ControlSets[ControlSet].Down == TRUE &&
			ControlSets[ControlSet].Left == FALSE &&
			ControlSets[ControlSet].Right == TRUE )
		{
			ChangeDirection( PlayerIndex, DOWNRIGHT, TRUE );
			Players[PlayerIndex].CurrentAction=WALKING;

			MovePlayer( PlayerIndex,
				(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment),
				(Players[PlayerIndex].WalkingSpeed+Players[PlayerIndex].SpeedAdjustment) );
		}

		if ( ControlSets[ControlSet].Up == FALSE &&
			ControlSets[ControlSet].Down == FALSE &&
			ControlSets[ControlSet].Left == FALSE &&
			ControlSets[ControlSet].Right == FALSE )
			Players[PlayerIndex].CurrentAction=STANDING;
	//}

	// Shooting....
	if ( Players[PlayerIndex].Shooting == TRUE )
	{
		if ( ControlSets[ControlSet].ShootUp == TRUE &&
			ControlSets[ControlSet].ShootLeft == FALSE &&
			ControlSets[ControlSet].ShootRight == FALSE &&
			ControlSets[ControlSet].ShootDown == FALSE )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, UP, TRUE );
				ChangeShootingDirection( PlayerIndex, UP, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos,
					Players[PlayerIndex].YPos-45, UP );
			}

		else if ( ControlSets[ControlSet].ShootDown == TRUE &&
			ControlSets[ControlSet].ShootLeft == FALSE &&
			ControlSets[ControlSet].ShootRight == FALSE &&
			ControlSets[ControlSet].ShootUp == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, DOWN, TRUE );
				ChangeShootingDirection( PlayerIndex, DOWN, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos,
					Players[PlayerIndex].YPos-15, DOWN );
			}

		if ( ControlSets[ControlSet].ShootLeft == TRUE &&
			ControlSets[ControlSet].ShootUp == FALSE &&
			ControlSets[ControlSet].ShootDown == FALSE &&
			ControlSets[ControlSet].ShootRight == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, LEFT, TRUE );
				ChangeShootingDirection( PlayerIndex, LEFT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos-25,
					Players[PlayerIndex].YPos-39, LEFT );
			}

		else if ( ControlSets[ControlSet].ShootRight == TRUE &&
			ControlSets[ControlSet].ShootUp == FALSE &&
			ControlSets[ControlSet].ShootDown == FALSE &&
			ControlSets[ControlSet].ShootLeft == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, RIGHT, TRUE );
				ChangeShootingDirection( PlayerIndex, RIGHT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos+25,
					Players[PlayerIndex].YPos-39, RIGHT );
			}

		if ( ControlSets[ControlSet].ShootUp == TRUE &&
			ControlSets[ControlSet].ShootLeft == TRUE &&
			ControlSets[ControlSet].ShootRight == FALSE &&
			ControlSets[ControlSet].ShootDown == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, UPLEFT, TRUE );
				ChangeShootingDirection( PlayerIndex, UPLEFT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos-14,
					Players[PlayerIndex].YPos-52, UPLEFT );
			}

		else if ( ControlSets[ControlSet].ShootUp == TRUE &&
			ControlSets[ControlSet].ShootLeft == FALSE &&
			ControlSets[ControlSet].ShootRight == TRUE &&
			ControlSets[ControlSet].ShootDown == FALSE )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, UPRIGHT, TRUE );
				ChangeShootingDirection( PlayerIndex, UPRIGHT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos+14,
					Players[PlayerIndex].YPos-52, UPRIGHT );
			}

		if ( ControlSets[ControlSet].ShootDown == TRUE &&
			ControlSets[ControlSet].ShootLeft == TRUE &&
			ControlSets[ControlSet].ShootRight == FALSE &&
			ControlSets[ControlSet].ShootUp == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, DOWNLEFT, TRUE );
				ChangeShootingDirection( PlayerIndex, DOWNLEFT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos-18,
					Players[PlayerIndex].YPos-18, DOWNLEFT );
			}

		else if ( ControlSets[ControlSet].ShootDown == TRUE &&
			ControlSets[ControlSet].ShootLeft == FALSE &&
			ControlSets[ControlSet].ShootRight == TRUE &&
			ControlSets[ControlSet].ShootUp == FALSE  )
			{
				if ( Players[PlayerIndex].CurrentAction == STANDING )
					ChangeDirection( PlayerIndex, DOWNRIGHT, TRUE );
				ChangeShootingDirection( PlayerIndex, DOWNRIGHT, TRUE );
				SpawnPlayerBullet( PlayerIndex, Players[PlayerIndex].XPos+18,
					Players[PlayerIndex].YPos-18, DOWNRIGHT );
			}
	}

}

