#include <kos.h>
#include <stdlib.h>
#include "smashdc.h"
#include "vars.h"

void ProcessEnemy( int enemyindex );
void ChangeEnemyDirection( int enemyindex, int direction );

int NearestPlayer( int enemyindex )
{
	int p1x,p1y;
	int p2x,p2y;
	int p3x,p3y;
	int p4x,p4y;

	int GreatestX=0;
	int GreatestY=0;

	int retval=0;

	// x distance..
	if ( Enemies[enemyindex].XPos >= Players[0].XPos )
		p1x=Enemies[enemyindex].XPos - Players[0].XPos;
	else
		p1x=Players[0].XPos - Enemies[enemyindex].XPos;

	if ( Enemies[enemyindex].XPos >= Players[1].XPos )
		p2x=Enemies[enemyindex].XPos - Players[1].XPos;
	else
		p2x=Players[1].XPos - Enemies[enemyindex].XPos;

	if ( Enemies[enemyindex].XPos >= Players[2].XPos )
		p3x=Enemies[enemyindex].XPos - Players[2].XPos;
	else
		p3x=Players[2].XPos - Enemies[enemyindex].XPos;

	if ( Enemies[enemyindex].XPos >= Players[3].XPos )
		p4x=Enemies[enemyindex].XPos - Players[3].XPos;
	else
		p4x=Players[3].XPos - Enemies[enemyindex].XPos;

	// Y distances..
	if ( Enemies[enemyindex].YPos >= Players[0].YPos )
		p1y=Enemies[enemyindex].YPos - Players[0].YPos;
	else
		p1y=Players[0].YPos - Enemies[enemyindex].YPos;

	if ( Enemies[enemyindex].YPos >= Players[1].YPos )
		p2y=Enemies[enemyindex].YPos - Players[1].YPos;
	else
		p2y=Players[1].YPos - Enemies[enemyindex].YPos;

	if ( Enemies[enemyindex].YPos >= Players[2].YPos )
		p3y=Enemies[enemyindex].YPos - Players[2].YPos;
	else
		p3y=Players[2].YPos - Enemies[enemyindex].YPos;

	if ( Enemies[enemyindex].YPos >= Players[3].YPos )
		p4y=Enemies[enemyindex].YPos - Players[3].YPos;
	else
		p4y=Players[3].YPos - Enemies[enemyindex].YPos;

	if ( p1x > p2x && p1x > p3x && p1x > p4x && Players[0].Active == TRUE )
		GreatestX=p1x;
	else if ( p2x > p1x && p2x > p3x && p2x > p4x && Players[1].Active == TRUE )
		GreatestX=p2x;
	else if ( p3x > p1x && p2x > p3x && p3x > p4x && Players[2].Active == TRUE )
		GreatestX=p3x;
	else if ( p4x > p1x && p4x > p2x && p3x > p4x && Players[3].Active == TRUE )
		GreatestX=p4x;

	if ( p1y > p2y && p1y > p3y && p1y > p4y && Players[0].Active == TRUE )
		GreatestX=p1y;
	else if ( p2y > p1y && p2y > p3y && p2y > p4y && Players[1].Active == TRUE )
		GreatestX=p2y;
	else if ( p3y > p1y && p2y > p3y && p3y > p4y && Players[2].Active == TRUE )
		GreatestX=p3y;
	else if ( p4y > p1y && p4y > p2y && p3y > p4y && Players[3].Active == TRUE )
		GreatestX=p4y;

	if ( GreatestX > GreatestY )
	{
		if ( GreatestX == p1x )
			retval = 0;
		else if ( GreatestX == p2x )
			retval = 1;
		else if ( GreatestX == p3x )
			retval = 2;
		else if ( GreatestX == p4x )
			retval = 3;
	}
	else
	{
		if ( GreatestY == p1y )
			retval = 0;
		else if ( GreatestY == p2y )
			retval = 1;
		else if ( GreatestY == p3y )
			retval = 2;
		else if ( GreatestY == p4y )
			retval = 3;
	}

	// blah.. not working.. hacky cheaty
	retval= rand()%4;

	while ( Players[retval].Active == FALSE )
	{
		retval=rand()%4;
	}

	return retval;
}

int EnemiesActive()
{
	int i, count=0;

	for ( i=0; i < MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
			count++;
	}

	return count;
}

void ProcessEnemies()
{
	int i;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
		{
			switch( Enemies[i].Type )
			{
				case SNAKEMAN:
					ProcessEnemy(i);
					break;
				case SKULLMAN:
					ProcessEnemy(i);
					break;
				case GEMINIMAN:
					ProcessEnemy(i);
					break;
				case TOPMAN:
					ProcessEnemy(i);
					break;
				case NEEDLEMAN:
					ProcessEnemy(i);
					break;
				case PHARAOHMAN:
					ProcessEnemy(i);
					break;
				case WOODMAN:
					ProcessEnemy(i);
					break;
				case BOMBMAN:
					ProcessEnemy(i);
					break;
				case DRWILY:
					ProcessEnemy(i);
					break;
			}
		}
	}
}

void MoveEnemy( int enemyindex, int xoffset, int yoffset )
{
	int i;
	uint32 OriginalXpos, OriginalYpos;

	OriginalXpos=Enemies[enemyindex].XPos;
	OriginalYpos=Enemies[enemyindex].YPos;

	Enemies[enemyindex].XPos+=xoffset;
	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
		{
			if ( i != enemyindex )
			{
				if ( EnemyEnemyCollision( enemyindex, i ) )
				{
					if ( Enemies[enemyindex].XPos+xoffset > 50 && Enemies[enemyindex].XPos+xoffset < 590 )
						Enemies[enemyindex].XPos=OriginalXpos;
				}
			}
		}
	}

	Enemies[enemyindex].YPos+=yoffset;
	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
		{
			if ( i != enemyindex )
			{
				if ( EnemyEnemyCollision( enemyindex, i ) )
				{
					if ( Enemies[enemyindex].YPos+yoffset > 100 && Enemies[enemyindex].YPos+yoffset < 480 )
						Enemies[enemyindex].YPos=OriginalYpos;
				}
			}
		}
	}

}

void ProcessEnemy( int enemyindex )
{
	//uint32 i;
	//uint32 secs, msecs;

	// Find nearest player..
	int ClosestPlayer = Enemies[enemyindex].PlayerTarget;

	if ( Enemies[enemyindex].XPos < Players[ClosestPlayer].XPos )
	{
		ChangeEnemyDirection( enemyindex, RIGHT );
		MoveEnemy( enemyindex, Enemies[enemyindex].WalkingSpeed, 0 );
	}
	else if ( Enemies[enemyindex].XPos > Players[ClosestPlayer].XPos )
	{
		ChangeEnemyDirection( enemyindex, LEFT );
		MoveEnemy( enemyindex, -(Enemies[enemyindex].WalkingSpeed), 0 );
	}

	if ( Enemies[enemyindex].YPos < Players[ClosestPlayer].YPos )
	{
		ChangeEnemyDirection( enemyindex, DOWN );
		MoveEnemy( enemyindex, 0, Enemies[enemyindex].WalkingSpeed );
	}
	else if ( Enemies[enemyindex].YPos > Players[ClosestPlayer].YPos )
	{
		ChangeEnemyDirection( enemyindex, UP );
		MoveEnemy( enemyindex, 0, -(Enemies[enemyindex].WalkingSpeed) );
	}

	// Enemy type specific stuff..
	/*switch ( Enemies[enemyindex].Type )
	{
		case GEMINIMAN:
			timer_ms_gettime( &secs, &msecs);
			srand( msecs );
			i=(rand()%100);

			//printf( "%d\n\r", i );

			if ( i == 1 )
			{
				// Spawn gemini split anim
				if ( SpawnEnemy( Enemies[enemyindex].XPos-50, Enemies[enemyindex].YPos,
					LEFT, GEMINIMAN ) == TRUE )
				{
					if ( SpawnEnemy( Enemies[enemyindex].XPos+50, Enemies[enemyindex].YPos,
					RIGHT, GEMINIMAN ) == TRUE )
					{
						SpawnEffect( EFFECT_GEMINISPLIT, Enemies[enemyindex].XPos,
							Enemies[enemyindex].YPos, Enemies[enemyindex].Width*2,
							Enemies[enemyindex].Height*2, 50 );
						snd_sfx_play(SAMPLE_GEMINISPLIT, 255, 128);
						Enemies[enemyindex].Active=FALSE;
					}
				}
			}
			break;
	}*/
}

void ChangeEnemyDirection( int enemyindex, int direction )
{
	// Find nearest player..
	int ClosestPlayer = 0;

	if ( Players[ClosestPlayer].YPos == Enemies[enemyindex].YPos )
	{
		if ( Players[ClosestPlayer].XPos > Enemies[enemyindex].XPos )
		{
			Enemies[enemyindex].WalkingDirection=RIGHT;
		}
		else
		{
			Enemies[enemyindex].WalkingDirection=LEFT;
		}
	}

	if ( Players[ClosestPlayer].XPos == Enemies[enemyindex].XPos )
	{
		if ( Players[ClosestPlayer].YPos > Enemies[enemyindex].YPos )
		{
			Enemies[enemyindex].WalkingDirection=DOWN;
		}
		else
		{
			Enemies[enemyindex].WalkingDirection=UP;
		}
	}

	if ( Players[ClosestPlayer].XPos > Enemies[enemyindex].XPos &&
		Players[ClosestPlayer].YPos < Enemies[enemyindex].YPos )
	{
		if ( (Players[ClosestPlayer].XPos-320) <= (240-Players[ClosestPlayer].YPos) )
			Enemies[enemyindex].WalkingDirection=UP;
		else
			Enemies[enemyindex].WalkingDirection=RIGHT;
	}
	else if ( Players[ClosestPlayer].XPos < Enemies[enemyindex].XPos &&
		Players[ClosestPlayer].YPos < Enemies[enemyindex].YPos )
	{
		if ( (320-Players[ClosestPlayer].XPos) <= (240-Players[ClosestPlayer].YPos) )
			Enemies[enemyindex].WalkingDirection=UP;
		else
			Enemies[enemyindex].WalkingDirection=LEFT;
	}
	else if ( Players[ClosestPlayer].XPos < Enemies[enemyindex].XPos &&
		Players[ClosestPlayer].YPos > Enemies[enemyindex].YPos )
	{
		if ( (320-Players[ClosestPlayer].XPos) <= (Players[ClosestPlayer].YPos-240) )
			Enemies[enemyindex].WalkingDirection=DOWN;
		else
			Enemies[enemyindex].WalkingDirection=LEFT;
	}
	else if ( Players[ClosestPlayer].XPos > Enemies[enemyindex].XPos &&
		Players[ClosestPlayer].YPos > Enemies[enemyindex].YPos )
	{
		if ( (Players[ClosestPlayer].XPos-320) <= (Players[ClosestPlayer].YPos-240) )
			Enemies[enemyindex].WalkingDirection=DOWN;
		else
			Enemies[enemyindex].WalkingDirection=RIGHT;
	}
}



