#include <kos.h>
#include <png/png.h>
#include <oggvorbis/sndoggvorbis.h>
#include "smashdc.h"
#include "vars.h"

void DrawLoadingScreen( pvr_ptr_t splash, float rgb );

void BeginLoadingScreen()
{
	uint32 w, h;
	pvr_ptr_t loadingscreen;

	png_load_texture("/cd/data/splash/loading.png", &loadingscreen, PNG_NO_ALPHA, &w, &h);

	//Indiket note: gamers hate waiting times, so simplify and do not any alpha effect!
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	DrawLoadingScreen( loadingscreen, 1.00f );
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
	pvr_list_finish();
	pvr_scene_finish();
	
	pvr_mem_reset();
	sndoggvorbis_stop();
}

void EndLoadingScreen()
{
	int done;
	uint32 w, h;
	float rgb;
	pvr_ptr_t loadingscreen;

	png_load_texture("/cd/data/splash/loading.png", &loadingscreen, PNG_NO_ALPHA, &w, &h);

	done=FALSE; rgb=1.0f;
	while ( done == FALSE )
	{
		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawLoadingScreen( loadingscreen, rgb );
		
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		pvr_list_finish();
		pvr_scene_finish();

		if ( rgb < 0.00f )
		{
			done=TRUE;
		}
		else
			rgb-=0.01f;
	}
	pvr_mem_reset();
}

void DrawLoadingScreen( pvr_ptr_t splash, float rgb )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, splash, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, rgb, rgb, rgb);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = 0;
  vert.y = 0;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 0;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 0;
  vert.y = 480;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 480;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

