//Translate all TA old code into the new PVR functions of KOS!

#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawSprite( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;

  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, texwidth, texheight, spriteindex, PVR_FILTER_NONE);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = xpos-(width/2);
  vert.y = ypos-height;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos-height;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-(width/2);
  vert.y = ypos;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
