#include <kos.h>
#include <png/png.h>
#include "smashdc.h"
#include "vars.h"

void DrawArrow( pvr_ptr_t index, int xpos, int ypos, int width, int height );

void UpdateExitUp( Animation Anim, int index )
{
	if ( UpArrowAnimPos>=Anim.Speed )
	{
		UpArrowAnimFrame++;
		UpArrowAnimPos=0;
	}
	else
		UpArrowAnimPos++;

	if ( UpArrowAnimFrame>Anim.NumOfFrames )
		UpArrowAnimFrame=Anim.LoopFrame;

}

void UpdateExitDown( Animation Anim, int index )
{
	if ( DownArrowAnimPos>=Anim.Speed )
	{
		DownArrowAnimFrame++;
		DownArrowAnimPos=0;
	}
	else
		DownArrowAnimPos++;

	if ( DownArrowAnimFrame>Anim.NumOfFrames )
		DownArrowAnimFrame=Anim.LoopFrame;
}

void UpdateExitLeft( Animation Anim, int index )
{
	if ( LeftArrowAnimPos>=Anim.Speed )
	{
		LeftArrowAnimFrame++;
		LeftArrowAnimPos=0;
	}
	else
		LeftArrowAnimPos++;

	if ( LeftArrowAnimFrame>Anim.NumOfFrames )
		LeftArrowAnimFrame=Anim.LoopFrame;
}

void UpdateExitRight( Animation Anim, int index )
{
	if ( RightArrowAnimPos>=Anim.Speed )
	{
		RightArrowAnimFrame++;
		RightArrowAnimPos=0;
	}
	else
		RightArrowAnimPos++;

	if ( RightArrowAnimFrame>Anim.NumOfFrames )
		RightArrowAnimFrame=Anim.LoopFrame;
}

void DrawExitArrow( int direction, int xpos, int ypos, int lit )
{
	switch ( direction )
	{
		case UP:
			if ( lit == TRUE )
			{
				DrawArrow( ExitUp.Frames[UpArrowAnimFrame], xpos, ypos, 85, 80 );
				UpdateExitUp( ExitUp, UpArrowAnimFrame );
			}
			else
				DrawArrow( ExitUp.Frames[3], xpos, ypos, 85, 80 );
			break;
		case DOWN:
			if ( lit == TRUE )
			{
				DrawArrow( ExitDown.Frames[DownArrowAnimFrame], xpos, ypos, 85, 80 );
				UpdateExitDown( ExitDown, DownArrowAnimFrame );
			}
			else
				DrawArrow( ExitDown.Frames[3], xpos, ypos, 85, 80 );
			break;
		case LEFT:
			if ( lit == TRUE )
			{
				DrawArrow( ExitLeft.Frames[LeftArrowAnimFrame], xpos, ypos, 85, 80 );
				UpdateExitLeft( ExitLeft, LeftArrowAnimFrame );
			}
			else
				DrawArrow( ExitLeft.Frames[3], xpos, ypos, 85, 80 );
			break;
		case RIGHT:
			if ( lit == TRUE )
			{
				DrawArrow( ExitRight.Frames[RightArrowAnimFrame], xpos, ypos, 85, 80 );
				UpdateExitRight( ExitRight, RightArrowAnimFrame );
			}
			else
				DrawArrow( ExitRight.Frames[3], xpos, ypos, 85, 80 );
			break;
	}
}

void DrawArrow( pvr_ptr_t index, int xpos, int ypos, int width, int height )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 32, 32, index, PVR_FILTER_NONE);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos-(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
