#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawSkullMan( int enemyindex );
void DrawGeminiMan( int enemyindex );
void DrawSnakeMan( int enemyindex );
void DrawWoodMan( int enemyindex );
void DrawNeedleMan( int enemyindex );
void DrawBombMan( int enemyindex );
void DrawTopMan( int enemyindex );
void DrawPharaohMan( int enemyindex );
void DrawDrWily( int enemyindex );

void UpdateSkullManAnimation( int enemyindex );
void UpdateGeminiManAnimation( int enemyindex );
void UpdateTopManAnimation( int enemyindex );
void UpdateNeedleManAnimation( int enemyindex );
void UpdateWoodManAnimation( int enemyindex );
void UpdatePharaohManAnimation( int enemyindex );
void UpdateBombManAnimation( int enemyindex );
void UpdateSnakeManAnimation( int enemyindex );
void UpdateDrWilyAnimation( int enemyindex );

void DrawEnemies()
{
	int i;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
		{
			switch ( Enemies[i].Type )
			{
				case SNAKEMAN:
					DrawSnakeMan(i);
					break;
				case GEMINIMAN:
					DrawGeminiMan(i);
					break;
				case SKULLMAN:
					DrawSkullMan(i);
					break;
				case NEEDLEMAN:
					DrawNeedleMan(i);
					break;
				case TOPMAN:
					DrawTopMan(i);
					break;
				case PHARAOHMAN:
					DrawPharaohMan(i);
					break;
				case WOODMAN:
					DrawWoodMan(i);
					break;
				case BOMBMAN:
					DrawBombMan(i);
					break;
				case DRWILY:
					DrawDrWily(i);
					break;
			}
		}
	}
}

void UpdateEnemyAnimations()
{
	int i;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Enemies[i].Active == TRUE )
		{
			switch ( Enemies[i].Type )
			{
				case SNAKEMAN:
					UpdateSnakeManAnimation(i);
					break;
				case GEMINIMAN:
					UpdateGeminiManAnimation(i);
					break;
				case SKULLMAN:
					UpdateSkullManAnimation(i);
					break;
				case DRWILY:
					UpdateDrWilyAnimation(i);
					break;
				case WOODMAN:
					UpdateSnakeManAnimation(i);
					break;
				case TOPMAN:
					UpdateGeminiManAnimation(i);
					break;
				case BOMBMAN:
					UpdateSkullManAnimation(i);
					break;
				case NEEDLEMAN:
					UpdateDrWilyAnimation(i);
					break;
				case PHARAOHMAN:
					UpdateDrWilyAnimation(i);
					break;
			}
		}
	}

}

void UpdateSnakeManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( SnakeManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( SnakeManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( SnakeManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( SnakeManWalkRight, enemyindex );
			break;
	}
}

void UpdateBombManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( BombManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( BombManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( BombManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( BombManWalkRight, enemyindex );
			break;
	}
}

void UpdateGeminiManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( GeminiManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( GeminiManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( GeminiManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( GeminiManWalkRight, enemyindex );
			break;
	}
}

void UpdateWoodManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( WoodManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( WoodManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( WoodManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( WoodManWalkRight, enemyindex );
			break;
	}
}

void UpdateNeedleManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( NeedleManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( NeedleManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( NeedleManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( NeedleManWalkRight, enemyindex );
			break;
	}
}

void UpdateSkullManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( SkullManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( SkullManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( SkullManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( SkullManWalkRight, enemyindex );
			break;
	}
}

void UpdatePharaohManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( PharaohManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( PharaohManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( PharaohManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( PharaohManWalkRight, enemyindex );
			break;
	}
}

void UpdateTopManAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( TopManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( TopManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( TopManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( TopManWalkRight, enemyindex );
			break;
	}
}

void UpdateDrWilyAnimation( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			UpdateEnemyAnim( SnakeManWalkUp, enemyindex );
			break;

		case DOWN:
			UpdateEnemyAnim( SnakeManWalkDown, enemyindex );
			break;

		case LEFT:
			UpdateEnemyAnim( SnakeManWalkLeft, enemyindex );
			break;

		case RIGHT:
			UpdateEnemyAnim( SnakeManWalkRight, enemyindex );
			break;
	}
}

void DrawSnakeMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( SnakeManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( SnakeManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( SnakeManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( SnakeManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawTopMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( TopManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( TopManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( TopManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( TopManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawWoodMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( WoodManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( WoodManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( WoodManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( WoodManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawNeedleMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( NeedleManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( NeedleManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( NeedleManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( NeedleManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawPharaohMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( PharaohManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( PharaohManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( PharaohManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( PharaohManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawBombMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( BombManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( BombManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( BombManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( BombManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawSkullMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( SkullManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( SkullManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( SkullManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( SkullManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawGeminiMan( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( GeminiManWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( GeminiManWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( GeminiManWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( GeminiManWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}

void DrawDrWily( int enemyindex )
{
	switch (  Enemies[enemyindex].WalkingDirection )
	{
		case UP:
			DrawEnemyFrame( DrWilyWalkUp, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case DOWN:
			DrawEnemyFrame( DrWilyWalkDown, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case LEFT:
			DrawEnemyFrame( DrWilyWalkLeft, enemyindex, Enemies[enemyindex].AnimFrame );
			break;

		case RIGHT:
			DrawEnemyFrame( DrWilyWalkRight, enemyindex, Enemies[enemyindex].AnimFrame );
			break;
	}

}
