#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawPlayerBullets()
{
	int i;

	for ( i=0; i<MAX_BULLETS; i++ )
	{
		if ( PlayerBullets[i].Active == TRUE )
		{
			switch( PlayerBullets[i].Type )
			{
				case WEAPON_BULLET:
					switch( PlayerBullets[i].Direction )
					{
						case UP:
							DrawPlayerBullet( NormalBulletUp.Frames[0], PlayerBullets[i].XPos,
							PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWN:
							DrawPlayerBullet( NormalBulletDown.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case LEFT:
							DrawPlayerBullet( NormalBulletLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case RIGHT:
							DrawPlayerBullet( NormalBulletRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case UPLEFT:
							DrawPlayerBullet( NormalBulletUpLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case UPRIGHT:
							DrawPlayerBullet( NormalBulletUpRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWNLEFT:
							DrawPlayerBullet( NormalBulletDownLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWNRIGHT:
							DrawPlayerBullet( NormalBulletDownRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
					}
					break;
				case WEAPON_ROCKET:
					switch( PlayerBullets[i].Direction )
					{
						case UP:
							DrawPlayerBullet( RocketBulletUp.Frames[0], PlayerBullets[i].XPos,
							PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWN:
							DrawPlayerBullet( RocketBulletDown.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case LEFT:
							DrawPlayerBullet( RocketBulletLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case RIGHT:
							DrawPlayerBullet( RocketBulletRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case UPLEFT:
							DrawPlayerBullet( RocketBulletUpLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case UPRIGHT:
							DrawPlayerBullet( RocketBulletUpRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWNLEFT:
							DrawPlayerBullet( RocketBulletDownLeft.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
						case DOWNRIGHT:
							DrawPlayerBullet( RocketBulletDownRight.Frames[0], PlayerBullets[i].XPos,
								PlayerBullets[i].YPos, 16, 16 );
							break;
					}
					break;
				}
		}
	}

}

void DrawPlayerBullet( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height )
{

  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 8, 8, spriteindex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = xpos-(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
