#include <kos.h>
#include <oggvorbis/sndoggvorbis.h>
#include "smashdc.h"
#include "vars.h"

void ProcessPlayerBullet( int bulletindex );

void SpawnPlayerBullet( int playerindex, int xpos, int ypos, int direction )
{
	int i=0;
	int done=FALSE;

	if ( Players[playerindex].ShootPos == 0 )
	{
		while ( done == FALSE )
		{
			if ( i < MAX_BULLETS )
			{
				if ( PlayerBullets[i].Active == FALSE )
				{
					PlayerBullets[i].Active=TRUE;
					PlayerBullets[i].Owner=playerindex;
					PlayerBullets[i].Type=Players[playerindex].Weapon;
					PlayerBullets[i].XPos=xpos;
					PlayerBullets[i].YPos=ypos;
					PlayerBullets[i].Direction=direction;
					PlayerBullets[i].Speed=10;
					done=TRUE;

					snd_sfx_play( SAMPLE_PLAYERSHOOT, 128, 128 );
				}
				else i++;
			}
			else
				done=TRUE;
		}
	}

	if ( Players[playerindex].ShootPos == Players[playerindex].ShootDelay )
		Players[playerindex].ShootPos=0;
	else
		Players[playerindex].ShootPos++;


}

void ProcessPlayerBullets()
{
	int i;

	for ( i=0; i < MAX_BULLETS; i++ )
	{
		if ( PlayerBullets[i].Active == TRUE )
			ProcessPlayerBullet( i );
	}
}

void ProcessPlayerBullet( int bulletindex )
{
	if ( PlayerBullets[bulletindex].XPos < 20 || PlayerBullets[bulletindex].XPos > 605 )
		PlayerBullets[bulletindex].Active=FALSE;
	if ( PlayerBullets[bulletindex].YPos < 60 || PlayerBullets[bulletindex].YPos > 480 )
		PlayerBullets[bulletindex].Active=FALSE;

	switch( PlayerBullets[bulletindex].Direction )
	{
		case UP:
			PlayerBullets[bulletindex].YPos-=PlayerBullets[bulletindex].Speed;
			break;
		case DOWN:
			PlayerBullets[bulletindex].YPos+=PlayerBullets[bulletindex].Speed;
			break;
		case LEFT:
			PlayerBullets[bulletindex].XPos-=PlayerBullets[bulletindex].Speed;
			break;
		case RIGHT:
			PlayerBullets[bulletindex].XPos+=PlayerBullets[bulletindex].Speed;
			break;

		case UPLEFT:
			PlayerBullets[bulletindex].YPos-=PlayerBullets[bulletindex].Speed;
			PlayerBullets[bulletindex].XPos-=PlayerBullets[bulletindex].Speed;
			break;
		case UPRIGHT:
			PlayerBullets[bulletindex].XPos+=PlayerBullets[bulletindex].Speed;
			PlayerBullets[bulletindex].YPos-=PlayerBullets[bulletindex].Speed;
			break;
		case DOWNLEFT:
			PlayerBullets[bulletindex].YPos+=PlayerBullets[bulletindex].Speed;
			PlayerBullets[bulletindex].XPos-=PlayerBullets[bulletindex].Speed;
			break;
		case DOWNRIGHT:
			PlayerBullets[bulletindex].YPos+=PlayerBullets[bulletindex].Speed;
			PlayerBullets[bulletindex].XPos+=PlayerBullets[bulletindex].Speed;
			break;

	}
}
