#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void UpdateAnimation()
{
	if ( Players[0].Active == TRUE )
	{
		UpdatePlayerLegAnimation(0);
		UpdateRedPlayerTorsoAnimation(0);
	}

	if ( Players[1].Active == TRUE )
	{
		UpdatePlayerLegAnimation(1);
		UpdateYellowPlayerTorsoAnimation(1);
	}

	if ( Players[2].Active == TRUE )
	{
		UpdatePlayerLegAnimation(2);
		UpdateGreenPlayerTorsoAnimation(2);
	}

	if ( Players[3].Active == TRUE )
	{
		UpdatePlayerLegAnimation(3);
		UpdateBluePlayerTorsoAnimation(3);
	}
}

void ResetPlayerAnim( int playerindex, int torso )
{
	if ( torso == TRUE )
	{
		Players[playerindex].TorsoAnimPos=0;
		Players[playerindex].TorsoFrame=0;
	}
	else
	{
		Players[playerindex].LegAnimPos=0;
		Players[playerindex].LegFrame=0;
	}
}

void ResetEffectAnim( int effectindex )
{
	Effects[effectindex].AnimPos=0;
	Effects[effectindex].AnimFrame=0;
}

void UpdatePlayerAnim( Animation Anim, int playerindex, int torso, int reverse )
{
	if ( torso == TRUE )
	{
		if ( reverse == FALSE )
		{
			if ( Players[playerindex].TorsoAnimPos>=Anim.Speed )
			{
				Players[playerindex].TorsoFrame++;
				Players[playerindex].TorsoAnimPos=0;
			}
			else
				Players[playerindex].TorsoAnimPos++;

			if ( Players[playerindex].TorsoFrame>Anim.NumOfFrames )
				Players[playerindex].TorsoFrame=Anim.LoopFrame;
		}
		else
		{
			if ( Players[playerindex].TorsoAnimPos>=Anim.Speed )
			{
				Players[playerindex].TorsoFrame--;
				Players[playerindex].TorsoAnimPos=0;
			}
			else
				Players[playerindex].TorsoAnimPos++;

			if ( Players[playerindex].TorsoFrame<Anim.LoopFrame )
				Players[playerindex].TorsoFrame=Anim.NumOfFrames;
		}
	}
	else
	{
		if ( reverse == FALSE )
			{
				if ( Players[playerindex].LegAnimPos>=Anim.Speed )
				{
					Players[playerindex].LegFrame++;
					Players[playerindex].LegAnimPos=0;
				}
				else
					Players[playerindex].LegAnimPos++;

				if ( Players[playerindex].LegFrame>Anim.NumOfFrames )
					Players[playerindex].LegFrame=Anim.LoopFrame;
			}
			else
			{
				if ( Players[playerindex].LegAnimPos>=Anim.Speed )
				{
					Players[playerindex].LegFrame--;
					Players[playerindex].LegAnimPos=0;
				}
				else
					Players[playerindex].LegAnimPos++;

				if ( Players[playerindex].LegFrame<Anim.LoopFrame )
					Players[playerindex].LegFrame=Anim.NumOfFrames;
		}
	}
}

void UpdateEnemyAnim( Animation Anim, int enemyindex )
{
	if ( Enemies[enemyindex].AnimPos>=Anim.Speed )
	{
		Enemies[enemyindex].AnimFrame++;
		Enemies[enemyindex].AnimPos=0;
	}
	else
		Enemies[enemyindex].AnimPos++;

	if ( Enemies[enemyindex].AnimFrame>Anim.NumOfFrames )
		Enemies[enemyindex].AnimFrame=Anim.LoopFrame;

}

void UpdateEffectAnim( Animation Anim, int effectindex )
{
	if ( Effects[effectindex].AnimPos>=Anim.Speed )
	{
		Effects[effectindex].AnimFrame++;
		Effects[effectindex].AnimPos=0;
	}
	else
		Effects[effectindex].AnimPos++;

	if ( Effects[effectindex].AnimFrame>Anim.NumOfFrames )
		Effects[effectindex].AnimFrame=Anim.LoopFrame;

}

