#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawDigit( pvr_ptr_t tex, int xpos, int ypos, int z );

void DrawNumber( char * number, int xpos, int ypos, int z )
{
	int i;
	int length=strlen(number);

	for ( i=0; i<length; i++ )
	{
		switch( number[i] )
		{
			case '0':
				DrawDigit( NumberTextures[0], xpos+(i*16), ypos, z );
				break;
			case '1':
				DrawDigit( NumberTextures[1], xpos+(i*16), ypos, z );
				break;
			case '2':
				DrawDigit( NumberTextures[2], xpos+(i*16), ypos, z );
				break;
			case '3':
				DrawDigit( NumberTextures[3], xpos+(i*16), ypos, z );
				break;
			case '4':
				DrawDigit( NumberTextures[4], xpos+(i*16), ypos, z );
				break;
			case '5':
				DrawDigit( NumberTextures[5], xpos+(i*16), ypos, z );
				break;
			case '6':
				DrawDigit( NumberTextures[6], xpos+(i*16), ypos, z );
				break;
			case '7':
				DrawDigit( NumberTextures[7], xpos+(i*16), ypos, z );
				break;
			case '8':
				DrawDigit( NumberTextures[8], xpos+(i*16), ypos, z );
				break;
			case '9':
				DrawDigit( NumberTextures[9], xpos+(i*16), ypos, z );
				break;
		}
	}
}

void DrawDigit( pvr_ptr_t tex, int xpos, int ypos, int z )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 32, 32, tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos;
  vert.y = ypos;
  vert.z = z;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+32;
  vert.y = ypos;
  vert.z = z;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+32;
  vert.z = z;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+32;
  vert.y = ypos+32;
  vert.z = z;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
