#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawPlayers()
{
	if ( Players[0].Active == TRUE )
	{
		if ( Players[0].Alive == FALSE )
		{
			DrawSprite( PlayerDead, Players[0].XPos,
				Players[0].YPos, 64, 64, 32, 32 );
		}
		else if ( Players[0].SkipFrame == FALSE )
		{
			DrawPlayerLegs( 0 );
			DrawRedPlayerTorso( 0 );
		}
	}

	if ( Players[1].Active == TRUE )
	{
		if ( Players[1].Alive == FALSE )
		{
			DrawSprite( PlayerDead, Players[1].XPos,
				Players[1].YPos, 64, 64, 32, 32 );
		}
		else if ( Players[1].SkipFrame == FALSE )
		{
			DrawPlayerLegs( 1 );
			DrawYellowPlayerTorso( 1 );
		}
	}

	if ( Players[2].Active == TRUE )
	{
		if ( Players[2].Alive == FALSE )
		{
			DrawSprite( PlayerDead, Players[2].XPos,
				Players[2].YPos, 64, 64, 32, 32 );
		}
		else if ( Players[2].SkipFrame == FALSE )
		{
			DrawPlayerLegs( 2 );
			DrawGreenPlayerTorso( 2 );
		}
	}

	if ( Players[3].Active == TRUE )
	{
		if ( Players[3].Alive == FALSE )
		{
			DrawSprite( PlayerDead, Players[3].XPos,
				Players[3].YPos, 64, 64, 32, 32 );
		}
		else if ( Players[3].SkipFrame == FALSE )
		{
			DrawPlayerLegs( 3 );
			DrawBluePlayerTorso( 3 );
		}
	}
}

void UpdateRedPlayerTorsoAnimation( int playerindex )
{
	if ( Players[playerindex].Shooting==TRUE )
	{
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				UpdatePlayerAnim( RedPlayerTorsoUpShoot, playerindex, TRUE, FALSE );
				break;

			case DOWN:
				UpdatePlayerAnim( RedPlayerTorsoDownShoot, playerindex, TRUE, FALSE );
				break;

			case LEFT:
				UpdatePlayerAnim( RedPlayerTorsoLeftShoot, playerindex, TRUE, FALSE );
				break;

			case RIGHT:
				UpdatePlayerAnim( RedPlayerTorsoRightShoot, playerindex, TRUE, FALSE );
				break;

			case UPLEFT:
				UpdatePlayerAnim( RedPlayerTorsoUpLeftShoot, playerindex, TRUE, FALSE );
				break;

			case UPRIGHT:
				UpdatePlayerAnim( RedPlayerTorsoUpRightShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNLEFT:
				UpdatePlayerAnim( RedPlayerTorsoDownLeftShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNRIGHT:
				UpdatePlayerAnim( RedPlayerTorsoDownRightShoot, playerindex, TRUE, FALSE );
				break;
		}
	}
}

void UpdateBluePlayerTorsoAnimation( int playerindex )
{
	if ( Players[playerindex].Shooting==TRUE )
	{
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				UpdatePlayerAnim( BluePlayerTorsoUpShoot, playerindex, TRUE, FALSE );
				break;

			case DOWN:
				UpdatePlayerAnim( BluePlayerTorsoDownShoot, playerindex, TRUE, FALSE );
				break;

			case LEFT:
				UpdatePlayerAnim( BluePlayerTorsoLeftShoot, playerindex, TRUE, FALSE );
				break;

			case RIGHT:
				UpdatePlayerAnim( BluePlayerTorsoRightShoot, playerindex, TRUE, FALSE );
				break;

			case UPLEFT:
				UpdatePlayerAnim( BluePlayerTorsoUpLeftShoot, playerindex, TRUE, FALSE );
				break;

			case UPRIGHT:
				UpdatePlayerAnim( BluePlayerTorsoUpRightShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNLEFT:
				UpdatePlayerAnim( BluePlayerTorsoDownLeftShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNRIGHT:
				UpdatePlayerAnim( BluePlayerTorsoDownRightShoot, playerindex, TRUE, FALSE );
				break;
		}
	}
}

void UpdateYellowPlayerTorsoAnimation( int playerindex )
{
	if ( Players[playerindex].Shooting==TRUE )
	{
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				UpdatePlayerAnim( YellowPlayerTorsoUpShoot, playerindex, TRUE, FALSE );
				break;

			case DOWN:
				UpdatePlayerAnim( YellowPlayerTorsoDownShoot, playerindex, TRUE, FALSE );
				break;

			case LEFT:
				UpdatePlayerAnim( YellowPlayerTorsoLeftShoot, playerindex, TRUE, FALSE );
				break;

			case RIGHT:
				UpdatePlayerAnim( YellowPlayerTorsoRightShoot, playerindex, TRUE, FALSE );
				break;

			case UPLEFT:
				UpdatePlayerAnim( YellowPlayerTorsoUpLeftShoot, playerindex, TRUE, FALSE );
				break;

			case UPRIGHT:
				UpdatePlayerAnim( YellowPlayerTorsoUpRightShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNLEFT:
				UpdatePlayerAnim( YellowPlayerTorsoDownLeftShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNRIGHT:
				UpdatePlayerAnim( YellowPlayerTorsoDownRightShoot, playerindex, TRUE, FALSE );
				break;
		}
	}
}

void UpdateGreenPlayerTorsoAnimation( int playerindex )
{
	if ( Players[playerindex].Shooting==TRUE )
	{
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				UpdatePlayerAnim( GreenPlayerTorsoUpShoot, playerindex, TRUE, FALSE );
				break;

			case DOWN:
				UpdatePlayerAnim( GreenPlayerTorsoDownShoot, playerindex, TRUE, FALSE );
				break;

			case LEFT:
				UpdatePlayerAnim( GreenPlayerTorsoLeftShoot, playerindex, TRUE, FALSE );
				break;

			case RIGHT:
				UpdatePlayerAnim( GreenPlayerTorsoRightShoot, playerindex, TRUE, FALSE );
				break;

			case UPLEFT:
				UpdatePlayerAnim( GreenPlayerTorsoUpLeftShoot, playerindex, TRUE, FALSE );
				break;

			case UPRIGHT:
				UpdatePlayerAnim( GreenPlayerTorsoUpRightShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNLEFT:
				UpdatePlayerAnim( GreenPlayerTorsoDownLeftShoot, playerindex, TRUE, FALSE );
				break;

			case DOWNRIGHT:
				UpdatePlayerAnim( GreenPlayerTorsoDownRightShoot, playerindex, TRUE, FALSE );
				break;
		}
	}
}

void UpdatePlayerLegAnimation( int playerindex )
{
	if ( Players[playerindex].CurrentAction==WALKING )
		switch ( Players[playerindex].WalkingDirection )
		{
			case UP:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == DOWN ||
						Players[playerindex].ShootingDirection == DOWNLEFT ||
						Players[playerindex].ShootingDirection == DOWNRIGHT )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsDown, playerindex, FALSE, TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsUp, playerindex, FALSE, FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsUp, playerindex, FALSE,  FALSE );
				break;

			case DOWN:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == UP ||
						Players[playerindex].ShootingDirection == UPLEFT ||
						Players[playerindex].ShootingDirection == UPRIGHT )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsUp, playerindex, FALSE,  TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsDown, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsDown, playerindex, FALSE,  FALSE );
				break;

			case LEFT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == RIGHT ||
						Players[playerindex].ShootingDirection == UPRIGHT ||
						Players[playerindex].ShootingDirection == DOWNRIGHT )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsRight, playerindex, FALSE,  TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsLeft, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsLeft, playerindex, FALSE,  FALSE );
				break;

			case RIGHT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == LEFT ||
						Players[playerindex].ShootingDirection == UPLEFT ||
						Players[playerindex].ShootingDirection == DOWNLEFT )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsLeft, playerindex, FALSE,  TRUE );
				    }
					else
						UpdatePlayerAnim( PlayerLegsRight, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsRight, playerindex, FALSE,  FALSE );
				break;

			case UPLEFT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == RIGHT ||
						Players[playerindex].ShootingDirection == DOWNRIGHT ||
						Players[playerindex].ShootingDirection == DOWN )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsDownRight, playerindex, FALSE,  TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsUpLeft, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsUpLeft, playerindex, FALSE,  FALSE );
				break;

			case UPRIGHT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == LEFT ||
						Players[playerindex].ShootingDirection == DOWNLEFT ||
						Players[playerindex].ShootingDirection == DOWN )
						{
							//ResetAnim( playerindex, FALSE );
							UpdatePlayerAnim( PlayerLegsDownLeft, playerindex, FALSE,  TRUE );
					    }
					else
						UpdatePlayerAnim( PlayerLegsUpRight, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsUpRight, playerindex, FALSE,  FALSE );
				break;

			case DOWNLEFT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == UP ||
						Players[playerindex].ShootingDirection == UPRIGHT ||
						Players[playerindex].ShootingDirection == RIGHT )
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsUpRight, playerindex, FALSE,  TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsDownLeft, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsDownLeft, playerindex, FALSE,  FALSE );
				break;

			case DOWNRIGHT:
				if ( Players[playerindex].Shooting == TRUE )
				{
					if ( Players[playerindex].ShootingDirection == UP ||
						Players[playerindex].ShootingDirection == UPLEFT ||
						Players[playerindex].ShootingDirection == LEFT)
					{
						//ResetAnim( playerindex, FALSE );
						UpdatePlayerAnim( PlayerLegsUpLeft, playerindex, FALSE,  TRUE );
					}
					else
						UpdatePlayerAnim( PlayerLegsDownRight, playerindex, FALSE,  FALSE );
				}
				else
					UpdatePlayerAnim( PlayerLegsDownRight, playerindex, FALSE,  FALSE );
				break;
		}

	if ( Players[playerindex].CurrentAction==STANDING )
	{
		ResetPlayerAnim( playerindex, FALSE );
	}
}

void DrawPlayerLegs( int playerindex )
{
	if ( Players[playerindex].Shooting == FALSE )
	{
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				DrawPlayerFrame( PlayerLegsUp, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWN:
				DrawPlayerFrame( PlayerLegsDown, playerindex, Players[playerindex].LegFrame );
				break;

			case LEFT:
				DrawPlayerFrame( PlayerLegsLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case RIGHT:
				DrawPlayerFrame( PlayerLegsRight, playerindex, Players[playerindex].LegFrame );
				break;

			case UPLEFT:
				DrawPlayerFrame( PlayerLegsUpLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case UPRIGHT:
				DrawPlayerFrame( PlayerLegsUpRight, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWNLEFT:
				DrawPlayerFrame( PlayerLegsDownLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWNRIGHT:
				DrawPlayerFrame( PlayerLegsDownRight, playerindex, Players[playerindex].LegFrame );
				break;
		}
	}
	else
	{
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				if ( Players[playerindex].ShootingDirection == DOWN ||
					Players[playerindex].ShootingDirection == DOWNLEFT ||
					Players[playerindex].ShootingDirection == DOWNRIGHT )
						DrawPlayerFrame( PlayerLegsDown, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsUp, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWN:
				if ( Players[playerindex].ShootingDirection == UP ||
					Players[playerindex].ShootingDirection == UPLEFT ||
					Players[playerindex].ShootingDirection == UPRIGHT )
						DrawPlayerFrame( PlayerLegsUp, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsDown, playerindex, Players[playerindex].LegFrame );
				break;

			case LEFT:
				if ( Players[playerindex].ShootingDirection == RIGHT ||
					Players[playerindex].ShootingDirection == UPRIGHT ||
					Players[playerindex].ShootingDirection == DOWNRIGHT )
						DrawPlayerFrame( PlayerLegsRight, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case RIGHT:
				if ( Players[playerindex].ShootingDirection == LEFT ||
					Players[playerindex].ShootingDirection == UPLEFT ||
					Players[playerindex].ShootingDirection == DOWNLEFT )
						DrawPlayerFrame( PlayerLegsLeft, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsRight, playerindex, Players[playerindex].LegFrame );
				break;

			case UPLEFT:
				if ( Players[playerindex].ShootingDirection == RIGHT ||
					Players[playerindex].ShootingDirection == DOWN ||
					Players[playerindex].ShootingDirection == DOWNRIGHT )
						DrawPlayerFrame( PlayerLegsDownRight, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsUpLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case UPRIGHT:
				if ( Players[playerindex].ShootingDirection == LEFT ||
					Players[playerindex].ShootingDirection == DOWN ||
					Players[playerindex].ShootingDirection == DOWNLEFT )
						DrawPlayerFrame( PlayerLegsDownLeft, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsUpRight, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWNLEFT:
				if ( Players[playerindex].ShootingDirection == RIGHT ||
					Players[playerindex].ShootingDirection == UP ||
					Players[playerindex].ShootingDirection == UPRIGHT )
						DrawPlayerFrame( PlayerLegsUpRight, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsDownLeft, playerindex, Players[playerindex].LegFrame );
				break;

			case DOWNRIGHT:
				if ( Players[playerindex].ShootingDirection == UP ||
					Players[playerindex].ShootingDirection == LEFT ||
					Players[playerindex].ShootingDirection == UPLEFT )
						DrawPlayerFrame( PlayerLegsUpLeft, playerindex, Players[playerindex].LegFrame );
				else
					DrawPlayerFrame( PlayerLegsDownRight, playerindex, Players[playerindex].LegFrame );
				break;
		}
	}


}

void DrawRedPlayerTorso( int playerindex )
{
	if ( Players[playerindex].Shooting == FALSE )
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				DrawSprite( RedPlayerTorsoUp.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWN:
				DrawSprite( RedPlayerTorsoDown.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case LEFT:
				DrawSprite( RedPlayerTorsoLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case RIGHT:
				DrawSprite( RedPlayerTorsoRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPLEFT:
				DrawSprite( RedPlayerTorsoUpLeft.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPRIGHT:
				DrawSprite( RedPlayerTorsoUpRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNLEFT:
				DrawSprite( RedPlayerTorsoDownLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNRIGHT:
				DrawSprite( RedPlayerTorsoDownRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;
		}
	else
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				DrawPlayerFrame( RedPlayerTorsoUpShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWN:
				DrawPlayerFrame( RedPlayerTorsoDownShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case LEFT:
				DrawPlayerFrame( RedPlayerTorsoLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case RIGHT:
				DrawPlayerFrame( RedPlayerTorsoRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPLEFT:
				DrawPlayerFrame( RedPlayerTorsoUpLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPRIGHT:
				DrawPlayerFrame( RedPlayerTorsoUpRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNLEFT:
				DrawPlayerFrame( RedPlayerTorsoDownLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNRIGHT:
				DrawPlayerFrame( RedPlayerTorsoDownRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;
		}


}

void DrawGreenPlayerTorso( int playerindex )
{
	if ( Players[playerindex].Shooting == FALSE )
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				DrawSprite( GreenPlayerTorsoUp.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWN:
				DrawSprite( GreenPlayerTorsoDown.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case LEFT:
				DrawSprite( GreenPlayerTorsoLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case RIGHT:
				DrawSprite( GreenPlayerTorsoRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPLEFT:
				DrawSprite( GreenPlayerTorsoUpLeft.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPRIGHT:
				DrawSprite( GreenPlayerTorsoUpRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNLEFT:
				DrawSprite( GreenPlayerTorsoDownLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNRIGHT:
				DrawSprite( GreenPlayerTorsoDownRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;
		}
	else
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				DrawPlayerFrame( GreenPlayerTorsoUpShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWN:
				DrawPlayerFrame( GreenPlayerTorsoDownShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case LEFT:
				DrawPlayerFrame( GreenPlayerTorsoLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case RIGHT:
				DrawPlayerFrame( GreenPlayerTorsoRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPLEFT:
				DrawPlayerFrame( GreenPlayerTorsoUpLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPRIGHT:
				DrawPlayerFrame( GreenPlayerTorsoUpRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNLEFT:
				DrawPlayerFrame( GreenPlayerTorsoDownLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNRIGHT:
				DrawPlayerFrame( GreenPlayerTorsoDownRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;
		}


}

void DrawYellowPlayerTorso( int playerindex )
{
	if ( Players[playerindex].Shooting == FALSE )
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				DrawSprite( YellowPlayerTorsoUp.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWN:
				DrawSprite( YellowPlayerTorsoDown.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case LEFT:
				DrawSprite( YellowPlayerTorsoLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case RIGHT:
				DrawSprite( YellowPlayerTorsoRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPLEFT:
				DrawSprite( YellowPlayerTorsoUpLeft.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPRIGHT:
				DrawSprite( YellowPlayerTorsoUpRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNLEFT:
				DrawSprite( YellowPlayerTorsoDownLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNRIGHT:
				DrawSprite( YellowPlayerTorsoDownRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;
		}
	else
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				DrawPlayerFrame( YellowPlayerTorsoUpShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWN:
				DrawPlayerFrame( YellowPlayerTorsoDownShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case LEFT:
				DrawPlayerFrame( YellowPlayerTorsoLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case RIGHT:
				DrawPlayerFrame( YellowPlayerTorsoRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPLEFT:
				DrawPlayerFrame( YellowPlayerTorsoUpLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPRIGHT:
				DrawPlayerFrame( YellowPlayerTorsoUpRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNLEFT:
				DrawPlayerFrame( YellowPlayerTorsoDownLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNRIGHT:
				DrawPlayerFrame( YellowPlayerTorsoDownRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;
		}
}

void DrawBluePlayerTorso( int playerindex )
{
	if ( Players[playerindex].Shooting == FALSE )
		switch (  Players[playerindex].WalkingDirection )
		{
			case UP:
				DrawSprite( BluePlayerTorsoUp.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWN:
				DrawSprite( BluePlayerTorsoDown.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case LEFT:
				DrawSprite( BluePlayerTorsoLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case RIGHT:
				DrawSprite( BluePlayerTorsoRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPLEFT:
				DrawSprite( BluePlayerTorsoUpLeft.Frames[0],	Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case UPRIGHT:
				DrawSprite( BluePlayerTorsoUpRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNLEFT:
				DrawSprite( BluePlayerTorsoDownLeft.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;

			case DOWNRIGHT:
				DrawSprite( BluePlayerTorsoDownRight.Frames[0], Players[playerindex].XPos,
				Players[playerindex].YPos, 64, 64, 32, 32 );
				break;
		}
	else
		switch (  Players[playerindex].ShootingDirection )
		{
			case UP:
				DrawPlayerFrame( BluePlayerTorsoUpShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWN:
				DrawPlayerFrame( BluePlayerTorsoDownShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case LEFT:
				DrawPlayerFrame( BluePlayerTorsoLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case RIGHT:
				DrawPlayerFrame( BluePlayerTorsoRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPLEFT:
				DrawPlayerFrame( BluePlayerTorsoUpLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case UPRIGHT:
				DrawPlayerFrame( BluePlayerTorsoUpRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNLEFT:
				DrawPlayerFrame( BluePlayerTorsoDownLeftShoot, playerindex, Players[playerindex].TorsoFrame );
				break;

			case DOWNRIGHT:
				DrawPlayerFrame( BluePlayerTorsoDownRightShoot, playerindex, Players[playerindex].TorsoFrame );
				break;
		}


}
