#include <kos.h>
#include <png/png.h>
#include "smashdc.h"
#include "vars.h"

void DrawItem( pvr_ptr_t index, int xpos, int ypos, int width, int height );

void DrawItems()
{
	int i;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Rooms[CurrentRoom].Items[i].Active == TRUE )
		{
			switch( Rooms[CurrentRoom].Items[i].Type )
			{
				case ITEM_1UP:
					DrawItem( Item1Up, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
				case ITEM_MINE:
					DrawItem( ItemMine, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
				case ITEM_ROCKET:
					DrawItem( ItemRocket, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
				case ITEM_MONEY:
					DrawItem( ItemMoney, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
				case ITEM_SILVER:
					DrawItem( ItemSilver, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
				case ITEM_GOLD:
					DrawItem( ItemGold, Rooms[CurrentRoom].Items[i].XPos,
						Rooms[CurrentRoom].Items[i].YPos, 32, 32 );
					break;
			}
		}
	}

}

void DrawItem( pvr_ptr_t index, int xpos, int ypos, int width, int height )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 16, 16, index, PVR_FILTER_NONE);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos-(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos-(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos+(height/2);
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
