#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void UpdateControls()
{
	UpdateControlSet( 0 );
	UpdateControlSet( 1 );
	UpdateControlSet( 2 );
	UpdateControlSet( 3 );
}

//KOS New maple: Replace code by "maple_enum_dev"
maple_device_t * GetPortAddr( int port )
{
	maple_device_t * addr;
	addr = maple_enum_dev( port,0 );
	return addr;
}

//KOS New maple: replace "maple_device_func" :D
int PadInPort( int port )
{
	int retval=FALSE;

	maple_device_t * dev = maple_enum_dev( port, 0 );
	if ( dev->info.functions == MAPLE_FUNC_CONTROLLER )
		retval=TRUE;

	return retval;
}

void UpdateControlSet( uint8 index )
{
	//KOS: Use newer Maple system
	
	maple_device_t * mcont;
	cont_state_t * cond;

	mcont = GetPortAddr( index );
	cond = (cont_state_t *)maple_dev_status(mcont);

	if (!cond)
	{
		//printf("Error getting controller status\n");
	}
	else
	{
		if ((cond->buttons & CONT_DPAD_UP))
			ControlSets[index].Up=TRUE;
		else ControlSets[index].Up=FALSE;

		if ((cond->buttons & CONT_DPAD_DOWN))
			ControlSets[index].Down=TRUE;
		else ControlSets[index].Down=FALSE;

		if ((cond->buttons & CONT_DPAD_LEFT))
			ControlSets[index].Left=TRUE;
		else ControlSets[index].Left=FALSE;

		if ((cond->buttons & CONT_DPAD_RIGHT))
			ControlSets[index].Right=TRUE;
		else ControlSets[index].Right=FALSE;

		if ((cond->buttons & CONT_Y))
			ControlSets[index].ShootUp=TRUE;
		else ControlSets[index].ShootUp=FALSE;

		if ((cond->buttons & CONT_A))
			ControlSets[index].ShootDown=TRUE;
		else ControlSets[index].ShootDown=FALSE;

		if ((cond->buttons & CONT_X))
			ControlSets[index].ShootLeft=TRUE;
		else ControlSets[index].ShootLeft=FALSE;

		if ((cond->buttons & CONT_B))
			ControlSets[index].ShootRight=TRUE;
		else ControlSets[index].ShootRight=FALSE;

		if ((cond->buttons & CONT_START))
		{
			ControlSets[index].Exit=TRUE;
		}
		else
			ControlSets[index].Exit=FALSE;
	}
}

