#include <kos.h>
#include <png/png.h>
#include <zlib/zlib.h>
#include <stdlib.h>
#include <oggvorbis/sndoggvorbis.h>

#include "smashdc.h"
#include "vars.h"

/*
	Most code in this intro was 'borrowed' from the
	PNG example included with KOS 1.1.7.
*/

/* font data */
extern char wfont[];

/* textures */
pvr_ptr_t font_tex;
pvr_ptr_t back_tex;

/* init background */
void LoadWinTextures()
{
    back_tex = pvr_mem_malloc(512*512*2);
    png_to_texture("/cd/data/effects/winback.png", back_tex, PNG_NO_ALPHA);
}

/* init font */
void InitWinFont()
{
    int i,x,y,c;
    unsigned short * temp_tex;

    font_tex = pvr_mem_malloc(256*256*2);
    temp_tex = (unsigned short *)malloc(256*128*2);

    c = 0;
    for(y = 0; y < 128 ; y+=16)
        for(x = 0; x < 256 ; x+=8) {
            for(i = 0; i < 16; i++) {
                temp_tex[x + (y+i) * 256 + 0] = 0xffff * ((wfont[c+i] & 0x80)>>7);
                temp_tex[x + (y+i) * 256 + 1] = 0xffff * ((wfont[c+i] & 0x40)>>6);
                temp_tex[x + (y+i) * 256 + 2] = 0xffff * ((wfont[c+i] & 0x20)>>5);
                temp_tex[x + (y+i) * 256 + 3] = 0xffff * ((wfont[c+i] & 0x10)>>4);
                temp_tex[x + (y+i) * 256 + 4] = 0xffff * ((wfont[c+i] & 0x08)>>3);
                temp_tex[x + (y+i) * 256 + 5] = 0xffff * ((wfont[c+i] & 0x04)>>2);
                temp_tex[x + (y+i) * 256 + 6] = 0xffff * ((wfont[c+i] & 0x02)>>1);
                temp_tex[x + (y+i) * 256 + 7] = 0xffff * (wfont[c+i] & 0x01);
            }
            c+=16;
        }
        
    pvr_txr_load_ex(temp_tex, font_tex, 256, 256, PVR_TXRLOAD_16BPP);
}

/* draw background */
void DrawWinBack(void)
{
	pvr_poly_cxt_t cxt;
	pvr_poly_hdr_t poly;
  	pvr_vertex_t   vert;

	pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, back_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &cxt);
  	pvr_prim(&poly, sizeof(poly));
  
  	vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  	vert.flags = PVR_CMD_VERTEX;
  
    vert.x = 1;
    vert.y = 1;
    vert.z = 1;
    vert.u = 0.0;
    vert.v = 0.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 1;
    vert.z = 1;
    vert.u = 1.0;
    vert.v = 0.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 1;
    vert.y = 480;
    vert.z = 1;
    vert.u = 0.0;
    vert.v = 1.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 480;
    vert.z = 1;
    vert.u = 1.0;
    vert.v = 1.0;
  	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));

}

/* draw one character */
void DrawWinChar(float x1, float y1, float z1, float a, float r, float g, float b, int c, float xs, float ys)
{
  	pvr_vertex_t   vert;

    int             ix, iy;
    float           u1, v1, u2, v2;

    ix = (c % 32) * 8;
    iy = (c / 32) * 16;
    u1 = (ix + 0.5f) * 1.0f / 256.0f;
    v1 = (iy + 0.5f) * 1.0f / 256.0f;
    u2 = (ix+7.5f) * 1.0f / 256.0f;
    v2 = (iy+15.5f) * 1.0f / 256.0f;

	vert.flags = PVR_CMD_VERTEX;
    vert.x = x1;
    vert.y = y1 + 16.0f * ys;
    vert.z = z1;
    vert.u = u1;
    vert.v = v2;
    vert.argb = PVR_PACK_COLOR(a, r, g, b);
  	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  	pvr_prim(&vert, sizeof(vert));

    vert.x = x1;
    vert.y = y1;
    vert.u = u1;
    vert.v = v1;
	pvr_prim(&vert, sizeof(vert));

    vert.x = x1 + 8.0f * xs;
    vert.y = y1 + 16.0f * ys;
    vert.u = u2;
    vert.v = v2;
	pvr_prim(&vert, sizeof(vert));

    vert.x = x1 + 8.0f * xs;
    vert.y = y1;
    vert.u = u2;
    vert.v = v1;
    vert.flags = PVR_CMD_VERTEX_EOL;
    pvr_prim(&vert, sizeof(vert));

}

/* draw a string */
void DrawWinString(float x, float y, float z, float a, float r, float g, float b, char *str, float xs, float ys) {
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  
  float orig_x = x;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_TWIDDLED, 256, 256, font_tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  while (*str) {
    if (*str == '\n')
    {
      x = orig_x;
      y += 40;
      str++;
      continue;
    }
    DrawWinChar(x, y, z, a, r, g, b, *str++, xs, ys);
	x+=((8*xs)+5);
  }
}

/* base y coordinate */
float ypos = 480.0f;
float red=1.0f;
float green=1.0f;
float blue=1.0f;
int direction;

/* draw one frame */
void DrawWinFrame(void)
{
	uint32 secs, msecs;
	timer_ms_gettime( &secs, &msecs);
	srand( msecs );

	red=rand()%255;
	green=rand()%255;
	blue=rand()%255;

	red=(red/255);
	green=(green/255);
	blue=(blue/255);

	pvr_wait_ready();
    pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
    DrawWinBack();
    
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
		
	DrawWinString( 25, ypos, 3, 1, red,green,blue,     "CONGRATULATIONS!", 3, 3 );
	// Space
    DrawWinString( 25, ypos+100, 3, 1, red,green,blue, "YOU DEFEATED THE", 3, 3 );
    DrawWinString( 25, ypos+150, 3, 1, red,green,blue, "EVIL DRWILY AND", 3, 3 );
    DrawWinString( 25, ypos+200, 3, 1, red,green,blue, "RESTORED PEACE TO", 3, 3 );
    DrawWinString( 25, ypos+250, 3, 1, red,green,blue, "THE SMASHTV SET!", 3, 3 );
    // Space
    DrawWinString( 25, ypos+350, 3, 1, red,green,blue, "BE PROUD...", 3, 3 );
    // Space

	pvr_list_finish();
	pvr_scene_finish();
		
    ypos-=0.50f;
}

void DoWin()
{
	int done=FALSE;

	pvr_mem_reset();

	InitWinFont();
    LoadWinTextures();

	sndoggvorbis_start("/cd/data/music/music1.ogg", 1 );

    while( done == FALSE )
    {
		UpdateControls();

		if ( ControlSets[0].Exit == TRUE ||
			ControlSets[1].Exit == TRUE ||
			ControlSets[2].Exit == TRUE ||
			ControlSets[3].Exit == TRUE )
		{
			done = TRUE;
		}

		if ( ypos == -480 )
			done=TRUE;

		DrawWinFrame();
    }
    ExitGame=TRUE;

	sndoggvorbis_stop();
    snd_sfx_unload_all();
	pvr_mem_reset();
}
