#include <kos.h>
#include <png/png.h>
#include <oggvorbis/sndoggvorbis.h>
#include <stdlib.h>
#include "smashdc.h"
#include "vars.h"

int menupos;

void DrawBack();
void DrawLogo( int xpos, int ypos );
void DrawMenuOptions( int xpos, int ypos );
void DrawMenuOption( pvr_ptr_t tex, int xpos, int ypos, int width, int height  );
void DrawContestantsOption();
void DrawDifficultyOption();
void DrawGameModeOption();
void DrawMusicOption();
void DrawMenuCursor();

pvr_ptr_t titleback;
pvr_ptr_t titlelogo;
pvr_ptr_t menuoptions;
pvr_ptr_t one, two, three, four, five, six, seven, eight, nine, ten, none;
pvr_ptr_t easy, normal, hard, sadistic;
pvr_ptr_t vs, normalvs;
pvr_ptr_t menucursor;

sfxhnd_t crash;
sfxhnd_t menubeep;
sfxhnd_t menubeep2;


void DoTitleMenu()
{
	int done;
	uint32 w, h, i;
	int32 xpos, ypos;

	png_load_texture("/cd/data/title/menucursor.png", &menucursor, PNG_MASK_ALPHA, &w, &h);

	png_load_texture("/cd/data/title/titleback.png", &titleback, PNG_NO_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/titlelogo.png", &titlelogo, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/menuoptions.png", &menuoptions, PNG_MASK_ALPHA, &w, &h);

	png_load_texture("/cd/data/title/one.png", &one, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/two.png", &two, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/three.png", &three, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/four.png", &four, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/five.png", &five, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/six.png", &six, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/seven.png", &seven, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/eight.png", &eight, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/nine.png", &nine, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/ten.png", &ten, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/none.png", &none, PNG_MASK_ALPHA, &w, &h);

	png_load_texture("/cd/data/title/easy.png", &easy, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/normal.png", &normal, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/hard.png", &hard, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/sadistic.png", &sadistic, PNG_MASK_ALPHA, &w, &h);

	png_load_texture("/cd/data/title/vs.png", &vs, PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/title/normalvs.png", &normalvs, PNG_MASK_ALPHA, &w, &h);

	crash = snd_sfx_load("/cd/data/sounds/crash.wav");
	menubeep = snd_sfx_load("/cd/data/sounds/menubeep.wav");
	menubeep2 = snd_sfx_load("/cd/data/sounds/menubeep2.wav");

	difficulty=1;
	contestants=0;
	music=1;
	gamemode=0;

	// beginning animation...
	done=FALSE; ypos=0;
	while ( done == FALSE )
	{
		UpdateControls();

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawBack();
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		DrawLogo( 320, ypos );
		pvr_list_finish();
		pvr_scene_finish();
		
		if ( ypos<400 )
			ypos+=4;
		else
			done=TRUE;
	}

	snd_sfx_play( crash, 255, 128 );
	done=FALSE; i=0;
	while ( i < 50 )
	{
		xpos = 320+((rand()%50)-25);
		ypos = 400+((rand()%50)-25);
		i++;

		UpdateControls();

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawBack();
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		DrawLogo( xpos, ypos );;
		pvr_list_finish();
		pvr_scene_finish();
	}

	done=FALSE; menupos=0;
	while ( done == FALSE )
	{
		UpdateControls();

		if ( ControlSets[0].ShootUp == TRUE ||
			ControlSets[0].ShootDown == TRUE ||
			ControlSets[0].ShootLeft == TRUE ||
			ControlSets[0].ShootRight == TRUE ||
			ControlSets[0].Exit == TRUE )
		{
			done=TRUE;
		}

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawBack();
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		DrawLogo( 320, 400 );
		DrawMenuOptions( 300, 340 );
		DrawContestantsOption();
		DrawDifficultyOption();
		DrawGameModeOption();
		DrawMusicOption();
		DrawMenuCursor();
		pvr_list_finish();
		pvr_scene_finish();

		if ( ControlSets[0].Left == TRUE )
		{
			switch( menupos )
			{
				case 0:
					if ( contestants != 0 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						contestants--;
					}
					break;
				case 1:
					if ( difficulty != 0 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						difficulty--;
					}
					break;
				case 2:
					if ( gamemode != 0 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						//gamemode--;
					}
					break;
				case 3:
					if ( music != 0 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						music--;
					}
					break;
			}
			while ( ControlSets[0].Left == TRUE )
				UpdateControls();
		}

		if ( ControlSets[0].Right == TRUE )
		{
			switch( menupos )
			{
				case 0:
					if ( contestants != 3 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						contestants++;
					}
					break;
				case 1:
					if ( difficulty != 2 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						difficulty++;
					}
					break;
				case 2:
					if ( gamemode != 2 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						//gamemode++;
					}
					break;
				case 3:
					if ( music != 10 )
					{
						snd_sfx_play( menubeep2, 255, 128 );
						music++;
					}
					break;
			}
			while ( ControlSets[0].Right == TRUE )
				UpdateControls();
		}

		// Menu controls..
		if ( ControlSets[0].Up == TRUE )
		{
			if ( menupos!=0 )
			{
				menupos--;
				snd_sfx_play( menubeep, 255, 128 );
			}
			while ( ControlSets[0].Up == TRUE )
			{
				UpdateControls();
			}
		}
		else if ( ControlSets[0].Down == TRUE )
		{
			if ( menupos!=3 )
			{
				menupos++;
				snd_sfx_play( menubeep, 255, 128 );
			}
			while ( ControlSets[0].Down == TRUE )
			{
				UpdateControls();
			}
		}
	}
	sndoggvorbis_stop();
	snd_sfx_unload_all();
	pvr_mem_reset();
}

void DrawDifficultyOption()
{
	switch ( difficulty )
	{
		case 0: // Easy
			DrawMenuOption( easy, 350, 375, 128, 128 );
			break;
		case 1: // Normal
			DrawMenuOption( normal, 350, 375, 128, 128 );
			break;
		case 2: // Hard
			DrawMenuOption( hard, 350, 375, 128, 128 );
			break;
		case 3: // Sadistic
			DrawMenuOption( sadistic, 350, 375, 128, 128 );
			break;
	}
}

void DrawGameModeOption()
{
	switch ( gamemode )
	{
		case 0:
			DrawMenuOption( normal, 395, 405, 128, 128 );
			break;
		case 1:
			DrawMenuOption( vs, 395, 405, 128, 128 );
			break;
		case 2:
			DrawMenuOption( normalvs, 395, 405, 256, 256 );
			break;
	}

}

void DrawMusicOption()
{
	switch ( music )
	{
		case 0:
			DrawMenuOption( none, 295, 435, 128, 128 );
			break;
		case 1:
			DrawMenuOption( one, 295, 435, 32, 32 );
			break;
		case 2:
			DrawMenuOption( two, 295, 435, 32, 32 );
			break;
		case 3:
			DrawMenuOption( three, 295, 435, 32, 32 );
			break;
		case 4:
			DrawMenuOption( four, 295, 435, 32, 32 );
			break;
		case 5:
			DrawMenuOption( five, 295, 435, 32, 32 );
			break;
		case 6:
			DrawMenuOption( six, 295, 435, 32, 32 );
			break;
		case 7:
			DrawMenuOption( seven, 295, 435, 32, 32 );
			break;
		case 8:
			DrawMenuOption( eight, 295, 435, 32, 32 );
			break;
		case 9:
			DrawMenuOption( nine, 295, 435, 32, 32 );
			break;
		case 10:
			DrawMenuOption( ten, 295, 435, 32, 32 );
			break;
	}
}

void DrawMenuCursor()
{
	switch ( menupos )
	{
		case 0:
			DrawMenuOption( menucursor, 130, 335, 32, 32 );
			break;
		case 1:
			DrawMenuOption( menucursor, 130, 365, 32, 32 );
			break;
		case 2:
			DrawMenuOption( menucursor, 130, 400, 32, 32 );
			break;
		case 3:
			DrawMenuOption( menucursor, 130, 430, 32, 32 );
			break;
	}
}

void DrawContestantsOption()
{
	switch ( contestants )
	{
		case 0:
			DrawMenuOption( one, 400, 340, 32, 32 );
			break;
		case 1:
			DrawMenuOption( two, 400, 340, 32, 32 );
			break;
		case 2:
			DrawMenuOption( three, 400, 340, 32, 32 );
			break;
		case 3:
			DrawMenuOption( four, 400, 340, 32, 32 );
			break;
	}
}

void DrawMenuOption( pvr_ptr_t tex, int xpos, int ypos, int width, int height  )
{
	  pvr_poly_cxt_t cxt;
  	  pvr_poly_hdr_t poly;
  	  pvr_vertex_t   vert;
  
	  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, width, height, tex, PVR_FILTER_BILINEAR);
	  pvr_poly_compile(&poly, &cxt);
	  pvr_prim(&poly, sizeof(poly));
  
	  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
	  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
	  vert.flags = PVR_CMD_VERTEX;
  
	  vert.x = xpos;
	  vert.y = ypos;
	  vert.z = 2;
	  vert.u = 0.0;
	  vert.v = 0.0;
  	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos+width;
	  vert.y = ypos;
	  vert.z = 2;
	  vert.u = 1.0;
	  vert.v = 0.0;
	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos;
	  vert.y = ypos+height;
	  vert.z = 2;
	  vert.u = 0.0;
	  vert.v = 1.0;
	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos+width;
	  vert.y = ypos+height;
	  vert.z = 2;
	  vert.u = 1.0;
	  vert.v = 1.0;
  	  vert.flags = PVR_CMD_VERTEX_EOL;
	  pvr_prim(&vert, sizeof(vert));

}

void DrawMenuOptions( int xpos, int ypos )
{
 	  pvr_poly_cxt_t cxt;
  	  pvr_poly_hdr_t poly;
  	  pvr_vertex_t   vert;
  	  
	  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 256, 256, menuoptions, PVR_FILTER_BILINEAR);
	  pvr_poly_compile(&poly, &cxt);
	  pvr_prim(&poly, sizeof(poly));
	  
	  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
	  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
	  vert.flags = PVR_CMD_VERTEX;
	  
	  vert.x = xpos-128;
	  vert.y = ypos;
	  vert.z = 2;
	  vert.u = 0.0;
	  vert.v = 0.0;
 	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos+200;
	  vert.y = ypos;
	  vert.z = 2;
	  vert.u = 1.0;
	  vert.v = 0.0;
  	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos-128;
	  vert.y = ypos+256;
	  vert.z = 2;
	  vert.u = 0.0;
	  vert.v = 1.0;
 	  pvr_prim(&vert, sizeof(vert));

	  vert.x = xpos+128;
	  vert.y = ypos+256;
	  vert.z = 2;
	  vert.u = 1.0;
	  vert.v = 1.0;
  	  vert.flags = PVR_CMD_VERTEX_EOL;
  	  pvr_prim(&vert, sizeof(vert));
}

void DrawBack()
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, titleback, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
	  
  vert.x = 0;
  vert.y = 0;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 0;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 0;
  vert.y = 480;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 480;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

void DrawLogo( int xpos, int ypos )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 256, 256, titlelogo, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos-200;
  vert.y = ypos-300;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+200;
  vert.y = ypos-300;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-200;
  vert.y = ypos;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+200;
  vert.y = ypos;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

