#include <kos.h>
#include <png/png.h>
#include <oggvorbis/sndoggvorbis.h>
#include "smashdc.h"
#include "vars.h"

void DrawSplash( pvr_ptr_t splash, float rgb );

sfxhnd_t siggler;

void DoSplashScreens()
{
	int done,fadein;
	float rgb;
	uint32 w, h;
	pvr_ptr_t dcemusplash;
	pvr_ptr_t sigglersplash;

	png_load_texture("/cd/data/splash/dcemu.png", &dcemusplash, PNG_NO_ALPHA, &w, &h);
	png_load_texture("/cd/data/splash/mrsiggler.png", &sigglersplash, PNG_NO_ALPHA, &w, &h);

	siggler = snd_sfx_load("/cd/data/sounds/siggler.wav");

	// begin draw cycle..
	done=FALSE; rgb=0.00f; fadein=TRUE;
	while ( done == FALSE )
	{
		if (rgb > 1.00f) rgb = 1.0f;
		else if (rgb < 0.00f) rgb = 0.0f;
		
		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawSplash( dcemusplash, rgb );
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		pvr_list_finish();
		pvr_scene_finish();
		
		if ( rgb == 1.00f && fadein==TRUE )
		{
			fadein=FALSE;
			timer_spin_sleep( 2000 );
		}
		else if ( rgb == 0.00f && fadein==FALSE )
		{
			done=TRUE;
		}
		else
		{
			if ( fadein==TRUE )
				rgb+=0.01f;
			if ( fadein==FALSE )
				rgb-=0.01f;
		}
		
	}

	done=FALSE; rgb=0.0f; fadein=TRUE;
	while ( done == FALSE )
	{
		if (rgb > 1.00f) rgb = 1.0f;
		else if (rgb < 0.00f) rgb = 0.0f;
	
		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawSplash( sigglersplash, rgb );
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);
		pvr_list_finish();
		pvr_scene_finish();

		if ( rgb == 1.00f && fadein==TRUE )
		{
			fadein=FALSE;
			snd_sfx_play( siggler, 255, 128 );
			timer_spin_sleep( 2500 );
		}
		else if ( rgb == 0.00f && fadein==FALSE )
		{
			done=TRUE;
		}
		else
		{
			if ( fadein==TRUE )
				rgb+=0.01f;
			if ( fadein==FALSE )
				rgb-=0.01f;
		}
		
	}
	
	sndoggvorbis_stop();
	snd_sfx_unload_all();
	pvr_mem_reset();
}

void DrawSplash( pvr_ptr_t splash, float rgb )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, splash, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, rgb, rgb, rgb);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = 0;
  vert.y = 0;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 0;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 0;
  vert.y = 480;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 480;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

