#include <kos.h>
#include <png/png.h>
#include <oggvorbis/sndoggvorbis.h>
#include <stdlib.h>

#include "smashdc.h"
#include "vars.h"
#include "pal.h"

//Init KOS (no romdisk)
KOS_INIT_FLAGS(INIT_DEFAULT);

int main(int argc, char *argv[])
{
	//Init Display and PVR
	int dc_region, ct;
  
	dc_region = flashrom_get_region();
	ct = vid_check_cable();
 
	/* Prompt the user for whether to run in PAL50 or PAL60 if the flashrom says
	the Dreamcast is European and a VGA Box is not hooked up. */
	if(dc_region == FLASHROM_REGION_EUROPE && ct != CT_VGA) {
		if(pal_menu()) {
			vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
		}
		else {
			vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
		}
	}
	else vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
	pvr_init_defaults();
	
	//Init OGG
	snd_stream_init(); //not null
	sndoggvorbis_init();

	DoSplashScreens();
	DoIntro();
	while (1)
	{
		DoTitleMenu();

		BeginLoadingScreen();
		LoadTextures();
		LoadSoundEffects();
		InitRooms();

		GameLoop();
	}

  	return 0;
}

