#include <kos.h>
#include <png/png.h>
#include "smashdc.h"
#include "vars.h"

void DrawFloorAnim( pvr_ptr_t floor, int xpos, int ypos );
void DrawOverlayAnim( pvr_ptr_t overlay, int xpos, int ypos );
void DrawPanelAnim( pvr_ptr_t tex, int xpos, int ypos );

void InitRoom( int room, int floor, int overlay, int amount, int delay, int waves, int n, int e, int s, int w, int boss )
{
	Rooms[room].Floor=floor;
	Rooms[room].Overlay=overlay;
	Rooms[room].EnemiesPerWave=amount;
	Rooms[room].SpawnDelay=delay;
	Rooms[room].BossRoom=boss;

	Rooms[room].North=n;
	Rooms[room].East=e;
	Rooms[room].South=s;
	Rooms[room].West=w;

	Rooms[room].Completed=FALSE;
	Rooms[room].EnemiesPos=0;
	Rooms[room].SpawnDelayPos=0;
	Rooms[room].CurrentWave=0;
	Rooms[room].LastDoorUsed=LEFT;
}

int AllRoomsComplete()
{
	int i;
	int retval = TRUE;

	for ( i=0; i<19; i++ )
	{
		if ( Rooms[i].Completed == FALSE )
			retval=FALSE;

		//printf( "Room%d: %d\n\r", i, Rooms[i].Completed );
	}

	return retval;
}

void InitRooms()
{
	int amount=0;
	int delay=0;
	int waves=0;
	int i,j;


	if ( difficulty == DIFFICULTY_EASY )
	{
		amount=8; delay=100; waves=2;
	}
	else if ( difficulty == DIFFICULTY_NORMAL )
	{
		amount=8; delay=75; waves=4;
	}
	else if ( difficulty == DIFFICULTY_HARD )
	{
		amount=16; delay=50; waves=4;
	}

	InitRoom( 1, 0, 0, amount, delay, waves, 3, 2, 0, 0, FALSE );
	InitRoom( 2, 0, 0, amount, delay, waves, 0, 5, 6, 1, FALSE  );
	InitRoom( 3, 0, 0, amount, delay, waves, 0, 0, 1, 0, FALSE  );
	InitRoom( 4, 0, 0, amount, delay, waves, 0, 0, 5, 0, FALSE  );
	InitRoom( 5, 0, 0, amount, delay, waves, 4, 0, 0, 2, FALSE  );
	InitRoom( 6, 0, 0, amount, delay, waves, 2, 7, 0, 0, FALSE  );
	InitRoom( 7, 0, 0, amount, delay, waves, 0, 8, 0, 6, FALSE  );
	InitRoom( 8, 0, 0, amount, delay, waves, 0, 9, 11, 7, FALSE  );
	InitRoom( 9, 0, 0, amount, delay, waves, 0, 10, 0, 8, FALSE );
	InitRoom( 10, 0, 0, amount, delay, waves, 0, 0, 0, 9, FALSE  );
	InitRoom( 11, 0, 0, amount, delay, waves, 8, 12, 0, 0, FALSE  );
	InitRoom( 12, 0, 0, amount, delay, waves, 0, 15, 13, 11, FALSE  );
	InitRoom( 13, 0, 0, amount, delay, waves, 12, 0, 16, 14, FALSE  );
	InitRoom( 14, 0, 0, amount, delay, waves, 0, 13, 0, 0, FALSE  );
	InitRoom( 15, 0, 0, amount, delay, waves, 0, 0, 0, 12, FALSE  );
	InitRoom( 16, 0, 0, amount, delay, waves, 13, 0, 17, 0, FALSE  );
	InitRoom( 17, 0, 0, amount, delay, waves, 16, 18, 0, 0, FALSE  );
	InitRoom( 18, 0, 0, amount, delay, waves, 0, 19, 0, 17, FALSE  );
	InitRoom( 19, 1, 0, amount, delay, waves, 0, 0, 0, 18, TRUE  ); //Wily Room


	CurrentRoom=1;
	BossActive=FALSE;
	BossDead=FALSE;
	Rooms[0].Completed=TRUE;

	for ( i=0; i<MAX_ENEMIES; i++ )
		Enemies[i].Active=FALSE;

	for ( i=0; i<MAX_BULLETS; i++ )
		PlayerBullets[i].Active=FALSE;

	for ( i=0; i<MAX_ENEMIES; i++ )
		Effects[i].Active=FALSE;

	for ( j=0; j<20; j++ )
	{
		for ( i=0; i<MAX_ENEMIES; i++ )
			Rooms[j].Items[i].Active=FALSE;
	}


}

void ChangeRoom( int roomindex, int direction )
{
	int i,j=0;

	//printf( "Entering room %d\n\r", roomindex );

	if ( roomindex == 19 && AllRoomsComplete() == FALSE )
	{
		printf( "Unable to enter boss room.. finish all rooms!\n\r" );
	}
	else
	{
		if ( roomindex != 0 )
		{
			if ( direction == UP || direction == DOWN )
				j=480;
			else if ( direction == LEFT || direction == RIGHT )
				j=640;

			// animatie the transition..
			for ( i=0; i<j; i+=8 )
			{
				pvr_wait_ready();
				pvr_scene_begin();
				pvr_list_begin(PVR_LIST_OP_POLY);
				switch( direction )
				{
					case UP:
						DrawFloorAnim( Floors[Rooms[CurrentRoom].Floor], 0, i );
						DrawFloorAnim( Floors[Rooms[roomindex].Floor], 0, i-480 );
						pvr_list_finish();
						pvr_list_begin(PVR_LIST_TR_POLY);
						DrawPanelAnim( LifePanels[0], 20, i+25 );
						DrawPanelAnim( LifePanels[1], 465, i+25 );
						DrawPanelAnim( LifePanels[0], 20, (i-480)+25 );
						DrawPanelAnim( LifePanels[1], 465, (i-480)+25 );
						DrawOverlayAnim( Overlays[Rooms[CurrentRoom].Overlay], 0, i );
						DrawOverlayAnim( Overlays[Rooms[roomindex].Overlay], 0, i-480 );
						break;
					case DOWN:
						DrawFloorAnim( Floors[Rooms[CurrentRoom].Floor], 0, -(i) );
						DrawFloorAnim( Floors[Rooms[roomindex].Floor], 0, -(i)+480 );
						pvr_list_finish();
						pvr_list_begin(PVR_LIST_TR_POLY);
						DrawPanelAnim( LifePanels[0], 20, -(i)+25 );
						DrawPanelAnim( LifePanels[1], 465, -(i)+25 );
						DrawPanelAnim( LifePanels[0], 20, (-(i)+480)+25 );
						DrawPanelAnim( LifePanels[1], 465, (-(i)+480)+25 );
						DrawOverlayAnim( Overlays[Rooms[CurrentRoom].Overlay], 0, -(i) );
						DrawOverlayAnim( Overlays[Rooms[roomindex].Overlay], 0, -(i)+480 );
						break;
					case LEFT:
						DrawFloorAnim( Floors[Rooms[CurrentRoom].Floor], i, 0 );
						DrawFloorAnim( Floors[Rooms[roomindex].Floor], i-640, 0 );
						pvr_list_finish();
						pvr_list_begin(PVR_LIST_TR_POLY);
						DrawPanelAnim( LifePanels[0], i+20, 25 );
						DrawPanelAnim( LifePanels[1], i+465, 25 );
						DrawPanelAnim( LifePanels[0], (i-640)+20, 25 );
						DrawPanelAnim( LifePanels[1], (i-640)+465, 25 );
						DrawOverlayAnim( Overlays[Rooms[CurrentRoom].Overlay], i, 0 );
						DrawOverlayAnim( Overlays[Rooms[roomindex].Overlay], i-640, 0 );
						break;
					case RIGHT:
						DrawFloorAnim( Floors[Rooms[CurrentRoom].Floor], -(i), 0 );
						DrawFloorAnim( Floors[Rooms[roomindex].Floor], -(i)+640, 0 );
						pvr_list_finish();
						pvr_list_begin(PVR_LIST_TR_POLY);
						DrawPanelAnim( LifePanels[0], -(i)+20, 25 );
						DrawPanelAnim( LifePanels[1], -(i)+465, 25 );
						DrawPanelAnim( LifePanels[0], (-(i)+640)+20, 25 );
						DrawPanelAnim( LifePanels[1], (-(i)+640)+465, 25 );
						DrawOverlayAnim( Overlays[Rooms[CurrentRoom].Overlay], -(i), 0 );
						DrawOverlayAnim( Overlays[Rooms[roomindex].Overlay], -(i)+640, 0 );
						break;
				}
				pvr_list_finish();
				pvr_scene_finish();
			}
			CurrentRoom=roomindex;

			// reset stuff.
			UpArrowAnimPos=0;
			UpArrowAnimFrame=0;
			DownArrowAnimPos=0;
			DownArrowAnimFrame=0;
			LeftArrowAnimPos=0;
			LeftArrowAnimFrame=0;
			RightArrowAnimPos=0;
			RightArrowAnimFrame=0;


			for ( i=0; i<MAX_ENEMIES; i++ )
				Enemies[i].Active=FALSE;

			for ( i=0; i<MAX_BULLETS; i++ )
				PlayerBullets[i].Active=FALSE;

			for ( i=0; i<MAX_ENEMIES; i++ )
				Effects[i].Active=FALSE;

			// repositition players..
			switch ( direction )
			{
				case UP:
					Players[0].XPos=275;
					Players[0].YPos=470;
					Players[1].XPos=305;
					Players[1].YPos=470;
					Players[2].XPos=335;
					Players[2].YPos=470;
					Players[3].XPos=370;
					Players[3].YPos=470;
					Players[0].WalkingDirection=UP;
					Players[1].WalkingDirection=UP;
					Players[2].WalkingDirection=UP;
					Players[3].WalkingDirection=UP;
					break;
				case DOWN:
					Players[0].XPos=275;
					Players[0].YPos=110;
					Players[1].XPos=305;
					Players[1].YPos=110;
					Players[2].XPos=335;
					Players[2].YPos=110;
					Players[3].XPos=370;
					Players[3].YPos=110;
					Players[0].WalkingDirection=DOWN;
					Players[1].WalkingDirection=DOWN;
					Players[2].WalkingDirection=DOWN;
					Players[3].WalkingDirection=DOWN;
					break;
				case LEFT:
					Players[0].XPos=580;
					Players[0].YPos=250;
					Players[1].XPos=580;
					Players[1].YPos=280;
					Players[2].XPos=580;
					Players[2].YPos=310;
					Players[3].XPos=580;
					Players[3].YPos=330;
					Players[0].WalkingDirection=LEFT;
					Players[1].WalkingDirection=LEFT;
					Players[2].WalkingDirection=LEFT;
					Players[3].WalkingDirection=LEFT;
					break;
				case RIGHT:
					Players[0].XPos=60;
					Players[0].YPos=250;
					Players[1].XPos=60;
					Players[1].YPos=280;
					Players[2].XPos=60;
					Players[2].YPos=310;
					Players[3].XPos=60;
					Players[3].YPos=330;
					Players[0].WalkingDirection=RIGHT;
					Players[1].WalkingDirection=RIGHT;
					Players[2].WalkingDirection=RIGHT;
					Players[3].WalkingDirection=RIGHT;
					break;
			}

		}
	}
}

void DrawOverlayAnim( pvr_ptr_t overlay, int xpos, int ypos )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 512, 512, overlay, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos;
  vert.y = ypos;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+640;
  vert.y = ypos;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+480;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+640;
  vert.y = ypos+480;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

void DrawFloorAnim( pvr_ptr_t floor, int xpos, int ypos )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, floor, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos;
  vert.y = ypos;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+640;
  vert.y = ypos;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+480;
  vert.z = 1;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+640;
  vert.y = ypos+480;
  vert.z = 1;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

void DrawPanelAnim( pvr_ptr_t tex, int xpos, int ypos )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 128, 128, tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = xpos;
  vert.y = ypos;
  vert.z = 5;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+165;
  vert.y = ypos;
  vert.z = 5;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+125;
  vert.z = 5;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+165;
  vert.y = ypos+125;
  vert.z = 5;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

