#include <kos.h>
#include <png/png.h>
#include <stdlib.h>
#include "smashdc.h"
#include "vars.h"

void DrawObject( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight );
void DrawBlankPoly( float r, float g, float b, float a );

void DoPause( int playerindex )
{
	int UnPause = FALSE;
	char buffer[10];

	while ( UnPause == FALSE )
	{
		UpdateControls();

		if ( ControlSets[playerindex].Exit == TRUE )
		{
			if ( StartPressed == FALSE )
			{
				UnPause=TRUE;

				while ( ControlSets[playerindex].Exit == TRUE )
				{ UpdateControls(); }
			}
		}
		else
			StartPressed=FALSE;

		pvr_wait_ready();
		pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawRoom();
		pvr_list_finish();
		
		pvr_list_begin(PVR_LIST_TR_POLY);
		DrawPlayers();
		DrawEnemies();
		DrawItems();
		DrawEffects();
		DrawPlayerBullets();
		DrawLifePanels();
		DrawOverlay( Overlays[Rooms[CurrentRoom].Overlay] );
		sprintf( buffer, "%d", Players[0].Lives );
		DrawNumber( buffer, 42, 50, 6 );
		sprintf( buffer, "%d", Players[1].Lives );
		DrawNumber( buffer, 115, 50, 6 );
		sprintf( buffer, "%d", Players[2].Lives );
		DrawNumber( buffer, 489, 50, 6 );
		sprintf( buffer, "%d", Players[3].Lives );
		DrawNumber( buffer, 561, 50, 6 );
		DrawBlankPoly( 1.0f, 1.0f, 1.0f, 0.75f );
		DrawObject( Map, 55, 150, 512, 256, 256, 256 );
		DrawObject( Player1, 25, 35, 128, 128, 128, 128 );
		sprintf( buffer, "%d", Players[0].Score );
		DrawNumber( buffer, 25, 60, 9 );
		DrawObject( Player2, 450, 35, 128, 128, 128, 128 );
		sprintf( buffer, "%d", Players[1].Score );
		DrawNumber( buffer, 450, 60, 9 );
		DrawObject( Player3, 25, 90, 128, 128, 128, 128 );
		sprintf( buffer, "%d", Players[2].Score );
		DrawNumber( buffer, 25, 120, 9 );
		DrawObject( Player4, 450, 90, 128, 128, 128, 128 );
		sprintf( buffer, "%d", Players[3].Score );
		DrawNumber( buffer, 450, 120, 9 );
		DrawObject( InRoom, 395, 432, 256, 256, 256, 256 );
		sprintf( buffer, "%d", CurrentRoom );
		DrawNumber( buffer, 580, 425, 9 );
		pvr_list_finish();
		pvr_scene_finish();
	}
}

void DrawBlankPoly( float r, float g, float b, float a )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;

  pvr_poly_cxt_col(&cxt, PVR_LIST_TR_POLY);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(a, r, g, b);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = 0;
  vert.y = 0;
  vert.z = 8;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 0;
  vert.z = 8;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 0;
  vert.y = 480;
  vert.z = 8;
  pvr_prim(&vert, sizeof(vert));

  vert.x = 640;
  vert.y = 480;
  vert.z = 8;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}

void DrawObject( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, texwidth, texheight, spriteindex, PVR_FILTER_NONE);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = xpos;
  vert.y = ypos;
  vert.z = 9;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+width;
  vert.y = ypos;
  vert.z = 9;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+height;
  vert.z = 9;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+width;
  vert.y = ypos+height;
  vert.z = 9;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}
