#include <kos.h>
#include <png/png.h>
#include <zlib/zlib.h>
#include <stdlib.h>
#include <oggvorbis/sndoggvorbis.h>

#include "smashdc.h"
#include "vars.h"

void DrawIntroSprite( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight );

/*
	Most code in this intro was 'borrowed' from the
	PNG example included with KOS 1.1.7.
*/


/* font data */
extern char wfont[];

/* textures */
pvr_ptr_t font_tex;
pvr_ptr_t back_tex;

int32 WilyShipXPos=750;
int32 WilyShipYPos=300;
uint32 WilyShipAnimPos;
uint32 WilyShipAnimFrame;

uint32 WilyEnteringShipAnimPos;
uint32 WilyEnteringShipAnimFrame;

uint32 WilyLeavingShipAnimPos;
uint32 WilyLeavingShipAnimFrame;

uint32 WilyHeadAnimPos;
uint32 WilyHeadAnimFrame;

Animation WilyShip;
Animation WilyHead;
Animation WilyEnteringShip;
Animation WilyLeavingShip;

void DrawWilyShipFrame( Animation Anim, int frame )
{
	DrawIntroSprite( Anim.Frames[frame],
			WilyShipXPos, WilyShipYPos,
			256, 256, 128, 128 );
}

void DrawWilyHeadFrame( Animation Anim, int frame )
{
	DrawIntroSprite( Anim.Frames[frame],
			WilyShipXPos, WilyShipYPos-78,
			128, 128, 64, 64 );
}

void UpdateWilyShipAnim( Animation Anim )
{
	if ( WilyShipAnimPos>=Anim.Speed )
	{
		WilyShipAnimFrame++;
		WilyShipAnimPos=0;
	}
	else
		WilyShipAnimPos++;

	if ( WilyShipAnimFrame>Anim.NumOfFrames )
		WilyShipAnimFrame=Anim.LoopFrame;
}

void UpdateWilyHeadAnim( Animation Anim )
{
	if ( WilyHeadAnimPos>=Anim.Speed )
	{
		WilyHeadAnimFrame++;
		WilyHeadAnimPos=0;
	}
	else
		WilyHeadAnimPos++;

	if ( WilyHeadAnimFrame>Anim.NumOfFrames )
		WilyHeadAnimFrame=Anim.LoopFrame;
}

void UpdateWilyEnteringShipAnim( Animation Anim )
{
	if ( WilyEnteringShipAnimPos>=Anim.Speed )
	{
		WilyEnteringShipAnimFrame++;
		WilyEnteringShipAnimPos=0;
	}
	else
		WilyEnteringShipAnimPos++;

	if ( WilyEnteringShipAnimFrame>Anim.NumOfFrames )
		WilyEnteringShipAnimFrame=Anim.LoopFrame;
}

void UpdateWilyLeavingShipAnim( Animation Anim )
{
	if ( WilyLeavingShipAnimPos>=Anim.Speed )
	{
		WilyLeavingShipAnimFrame++;
		WilyLeavingShipAnimPos=0;
	}
	else
		WilyLeavingShipAnimPos++;

	if ( WilyLeavingShipAnimFrame>Anim.NumOfFrames )
		WilyLeavingShipAnimFrame=Anim.LoopFrame;
}

/* init background */
void LoadIntroTextures()
{
	uint32 w, h;

    back_tex = pvr_mem_malloc(512*512*2);
    png_to_texture("/cd/data/intro/introback.png", back_tex, PNG_NO_ALPHA);

    png_load_texture("/cd/data/intro/wilyship/ship/0.png", &WilyShip.Frames[0], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/ship/1.png", &WilyShip.Frames[1], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/ship/2.png", &WilyShip.Frames[2], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/ship/3.png", &WilyShip.Frames[3], PNG_MASK_ALPHA, &w, &h);
	WilyShip.Speed=5;
	WilyShip.LoopFrame=0;
	WilyShip.NumOfFrames=3;

    png_load_texture("/cd/data/intro/wilyship/wilyenter/0.png", &WilyEnteringShip.Frames[0], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/1.png", &WilyEnteringShip.Frames[1], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/2.png", &WilyEnteringShip.Frames[2], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/3.png", &WilyEnteringShip.Frames[3], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/4.png", &WilyEnteringShip.Frames[4], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/5.png", &WilyEnteringShip.Frames[5], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/6.png", &WilyEnteringShip.Frames[6], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/7.png", &WilyEnteringShip.Frames[7], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyenter/8.png", &WilyEnteringShip.Frames[8], PNG_MASK_ALPHA, &w, &h);
	WilyEnteringShip.Speed=5;
	WilyEnteringShip.LoopFrame=8;
	WilyEnteringShip.NumOfFrames=8;

    png_load_texture("/cd/data/intro/wilyship/wilyexit/0.png", &WilyLeavingShip.Frames[0], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/1.png", &WilyLeavingShip.Frames[1], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/2.png", &WilyLeavingShip.Frames[2], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/3.png", &WilyLeavingShip.Frames[3], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/4.png", &WilyLeavingShip.Frames[4], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/5.png", &WilyLeavingShip.Frames[5], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/6.png", &WilyLeavingShip.Frames[6], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/7.png", &WilyLeavingShip.Frames[7], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyexit/8.png", &WilyLeavingShip.Frames[8], PNG_MASK_ALPHA, &w, &h);
	WilyLeavingShip.Speed=5;
	WilyLeavingShip.LoopFrame=8;
	WilyLeavingShip.NumOfFrames=8;

	png_load_texture("/cd/data/intro/wilyship/wilyhead/0.png", &WilyHead.Frames[0], PNG_MASK_ALPHA, &w, &h);
	png_load_texture("/cd/data/intro/wilyship/wilyhead/1.png", &WilyHead.Frames[1], PNG_MASK_ALPHA, &w, &h);
	WilyHead.Speed=5;
	WilyHead.LoopFrame=0;
	WilyHead.NumOfFrames=1;
}

/* init font */
void InitFont()
{
    int i,x,y,c;
    unsigned short * temp_tex;

    font_tex = pvr_mem_malloc(256*256*2);
    temp_tex = (unsigned short *)malloc(256*128*2);

    c = 0;
    for(y = 0; y < 128 ; y+=16)
        for(x = 0; x < 256 ; x+=8) {
            for(i = 0; i < 16; i++) {
                temp_tex[x + (y+i) * 256 + 0] = 0xffff * ((wfont[c+i] & 0x80)>>7);
                temp_tex[x + (y+i) * 256 + 1] = 0xffff * ((wfont[c+i] & 0x40)>>6);
                temp_tex[x + (y+i) * 256 + 2] = 0xffff * ((wfont[c+i] & 0x20)>>5);
                temp_tex[x + (y+i) * 256 + 3] = 0xffff * ((wfont[c+i] & 0x10)>>4);
                temp_tex[x + (y+i) * 256 + 4] = 0xffff * ((wfont[c+i] & 0x08)>>3);
                temp_tex[x + (y+i) * 256 + 5] = 0xffff * ((wfont[c+i] & 0x04)>>2);
                temp_tex[x + (y+i) * 256 + 6] = 0xffff * ((wfont[c+i] & 0x02)>>1);
                temp_tex[x + (y+i) * 256 + 7] = 0xffff * (wfont[c+i] & 0x01);
            }
            c+=16;
        }
	
    pvr_txr_load_ex(temp_tex, font_tex, 256, 256, PVR_TXRLOAD_16BPP);
}

/* draw background */
void DrawIntroBack(void)
{
	pvr_poly_cxt_t cxt;
  	pvr_poly_hdr_t poly;
  	pvr_vertex_t   vert;
  
	pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, back_tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &cxt);
  	pvr_prim(&poly, sizeof(poly));
  
	vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  	vert.flags = PVR_CMD_VERTEX;
  
    vert.x = 1;
    vert.y = 1;
    vert.z = 1;
    vert.u = 0.0;
    vert.v = 0.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 1;
    vert.z = 1;
    vert.u = 1.0;
    vert.v = 0.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 1;
    vert.y = 480;
    vert.z = 1;
    vert.u = 0.0;
    vert.v = 1.0;
  	pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 480;
    vert.z = 1;
    vert.u = 1.0;
    vert.v = 1.0;
    vert.flags = PVR_CMD_VERTEX_EOL;
    pvr_prim(&vert, sizeof(vert));
}

/* draw one character */
void DrawChar(float x1, float y1, float z1, float a, float r, float g, float b, int c, float xs, float ys)
{
    pvr_vertex_t   vert;
	
    int             ix, iy;
    float           u1, v1, u2, v2;

    ix = (c % 32) * 8;
    iy = (c / 32) * 16;
    u1 = (ix + 0.5f) * 1.0f / 256.0f;
    v1 = (iy + 0.5f) * 1.0f / 256.0f;
    u2 = (ix+7.5f) * 1.0f / 256.0f;
    v2 = (iy+15.5f) * 1.0f / 256.0f;

    vert.flags = PVR_CMD_VERTEX;
    vert.x = x1;
    vert.y = y1 + 16.0f * ys;
    vert.z = z1;
    vert.u = u1;
    vert.v = v2;
    vert.argb = PVR_PACK_COLOR(a, r, g, b);
  	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  	pvr_prim(&vert, sizeof(vert));

    vert.x = x1;
    vert.y = y1;
    vert.u = u1;
    vert.v = v1;
    pvr_prim(&vert, sizeof(vert));

    vert.x = x1 + 8.0f * xs;
    vert.y = y1 + 16.0f * ys;
    vert.u = u2;
    vert.v = v2;
    pvr_prim(&vert, sizeof(vert));

    vert.x = x1 + 8.0f * xs;
    vert.y = y1;
    vert.u = u2;
    vert.v = v1;
    vert.flags = PVR_CMD_VERTEX_EOL;
    pvr_prim(&vert, sizeof(vert));
}

/* draw a string */
void DrawString(float x, float y, float z, float a, float r, float g, float b, char *str, float xs, float ys) {
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  	
  float orig_x = x;

  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_TWIDDLED, 256, 256, font_tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));

  while (*str) {
    if (*str == '\n')
    {
      x = orig_x;
      y += 40;
      str++;
      continue;
    }
    DrawChar(x, y, z, a, r, g, b, *str++, xs, ys);
	x+=((8*xs)+5);
  }
}

/* base y coordinate */
float y = 480.0f;
float r=1.0f;
float g=1.0f;
float b=1.0f;
int direction;

/* draw one frame */
void DrawFrame(void)
{
	uint32 secs, msecs;
	timer_ms_gettime( &secs, &msecs);
	srand( msecs );

	r=rand()%255;
	g=rand()%255;
	b=rand()%255;

	r=(r/255);
	g=(g/255);
	b=(b/255);

	//printf( "%f\n\r", r );

	pvr_wait_ready();
    pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);	
    DrawIntroBack();

    pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);

    // Draw Wily's ship..
    if ( y<(-750.0f) )
    {
		DrawWilyShipFrame( WilyShip, WilyShipAnimFrame );
		DrawWilyHeadFrame( WilyEnteringShip, WilyEnteringShipAnimFrame );
	}
	else if ( y<(-70.0f) )
	{
		DrawWilyShipFrame( WilyShip, WilyShipAnimFrame );
		DrawWilyHeadFrame( WilyHead, WilyHeadAnimFrame );
	}
    else if ( y<(-50.0f) )
	{
		DrawWilyShipFrame( WilyShip, WilyShipAnimFrame );
		DrawWilyHeadFrame( WilyLeavingShip, WilyLeavingShipAnimFrame );
	}
    else if ( y<22.0f )
    {
	    DrawWilyShipFrame( WilyShip, WilyShipAnimFrame );
		DrawIntroSprite( WilyEnteringShip.Frames[8], WilyShipXPos, WilyShipYPos-78, 128, 128, 64, 64 );
	}



	// Draw Wily himself..

	DrawString( 65, y, 3, 1, r,g,b, "THE YEAR IS 20XX.", 3, 3 );
    DrawString( 25, y+100, 3, 1, r,g,b, "SMASHTV REMAINS AS", 3, 3 );
    DrawString( 25, y+150, 3, 1, r,g,b, "POPULAR AS EVER...", 3, 3 );
    // Space..
    DrawString( 25, y+250, 3, 1, r,g,b, "WATCHED BY MILLIONS", 3, 3 );
    DrawString( 25, y+300, 3, 1, r,g,b, "WORLD WIDE...  ", 3, 3 );
    // Space
    DrawString( 25, y+400, 3, 1, r,g,b, "EVEN DRWILY..", 3, 3 );
    // Space
    DrawString( 25, y+500, 3, 1, r,g,b, "INFACT, WILY ENJOYED", 3, 3 );
    DrawString( 25, y+550, 3, 1, r,g,b, "THE SHOW SO MUCH,ONE", 3, 3 );
    DrawString( 25, y+600, 3, 1, r,g,b, "DAY HE ATTACKED THE", 3, 3 );
    DrawString( 25, y+650, 3, 1, r,g,b, "SET,CLAIMING THE SHOW", 3, 3 );
    DrawString( 25, y+700, 3, 1, r,g,b, "HIS OWN...", 3, 3 );
    // Space
    DrawString( 25, y+1250, 3, 1, r,g,b, ".......", 3, 3 );
    // Big Space
    DrawString( 25, y+1300, 3, 1, r,g,b, "OK,I ADMIT THIS LAME", 3, 3 );
    DrawString( 25, y+1350, 3, 1, r,g,b, "EXCUSE FOR A PLOT", 3, 3 );
    DrawString( 25, y+1400, 3, 1, r,g,b, "SUCKS BUT HOW ELSE", 3, 3 );
    DrawString( 25, y+1450, 3, 1, r,g,b, "AM I TO EXPLAIN", 3, 3 );
    DrawString( 25, y+1500, 3, 1, r,g,b, "MEGAMAN ENEMIES IN", 3, 3 );
    DrawString( 25, y+1550, 3, 1, r,g,b, "A SMASH TV GAME? ..", 3, 3 );
    // space
    DrawString( 25, y+1650, 3, 1, r,g,b, "BUT, SERIOUSLY...", 3, 3 );
    DrawString( 25, y+1700, 3, 1, r,g,b, "IF YOU CAN THINK OF", 3, 3 );
    DrawString( 25, y+1750, 3, 1, r,g,b, "ANYTHING BETTER, BY", 3, 3 );
    DrawString( 25, y+1800, 3, 1, r,g,b, "ALL MEANS, LET ME ", 3, 3 );
    DrawString( 25, y+1850, 3, 1, r,g,b, "KNOW!....", 3, 3 );
    // space
    DrawString( 25, y+1950, 3, 1, r,g,b, "THAT IS ALL...", 3, 3 );


    pvr_list_finish();
	pvr_scene_finish();

    y-=0.50f;
}

void ProcessWilyShip()
{
	if ( y<(-800.0f) )
	{
		if ( WilyShipXPos > (-500) )
			WilyShipXPos-=4;

		UpdateWilyShipAnim( WilyShip );
	}
	else if ( y<(-750.0f) )
	{
		UpdateWilyEnteringShipAnim( WilyEnteringShip );
		UpdateWilyShipAnim( WilyShip );
	}
	else if ( y<(-70.0f) )
	{
		UpdateWilyHeadAnim( WilyHead );
		UpdateWilyShipAnim( WilyShip );
	}
	else if ( y<(-50.0f) )
	{
		UpdateWilyLeavingShipAnim( WilyLeavingShip );
		UpdateWilyShipAnim( WilyShip );
		// stuff..
	}
	else if ( y<22.0f )
	{
		UpdateWilyShipAnim( WilyShip );
		// move ship to middle..
		if ( WilyShipXPos >= 320 )
			WilyShipXPos-=4;
	}
}

void DoIntro()
{
	int done=FALSE;

	InitFont();
    LoadIntroTextures();

	sndoggvorbis_start("/cd/data/music/music1.ogg", 1 );

    while( done == FALSE )
    {
		UpdateControls();

		if ( ControlSets[0].Exit == TRUE ||
			ControlSets[1].Exit == TRUE ||
			ControlSets[2].Exit == TRUE ||
			ControlSets[3].Exit == TRUE )
		{
			done = TRUE;
		}

		if ( y == -1900 )
			done=TRUE;

		ProcessWilyShip();
		DrawFrame();
    }
	sndoggvorbis_stop();
    snd_sfx_unload_all();
	pvr_mem_reset();
}

void DrawIntroSprite( pvr_ptr_t spriteindex, int xpos, int ypos, int width, int height, int texwidth, int texheight )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, texwidth, texheight, spriteindex, PVR_FILTER_NONE);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;
  
  vert.x = xpos-(width/2);
  vert.y = ypos-height;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos-height;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos-(width/2);
  vert.y = ypos;
  vert.z = 2;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+(width/2);
  vert.y = ypos;
  vert.z = 2;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));
}

