#include <kos.h>
#include <stdlib.h>
#include <oggvorbis/sndoggvorbis.h>
#include <arch/rtc.h>
#include <time.h>
#include "smashdc.h"
#include "vars.h"

void GameLoop()
{
	char buffer[1];
	uint32 secs, msecs;

	//contestants=3;

	switch ( contestants )
	{
		case 0:
			InitPlayers( TRUE, FALSE, FALSE, FALSE );
			break;
		case 1:
			InitPlayers( TRUE, TRUE, FALSE, FALSE );
			break;
		case 2:
			InitPlayers( TRUE, TRUE, TRUE, FALSE );
			break;
		case 3:
			InitPlayers( TRUE, TRUE, TRUE, TRUE );
			break;
	}

	sndoggvorbis_stop();
	switch ( music )
	{
		case 0:
			// Play nothing.
			break;
		case 1:
			sndoggvorbis_start("/cd/data/music/music1.ogg", 0 );
			break;
		case 2:
			sndoggvorbis_start("/cd/data/music/music2.ogg", 0 );
			break;
		case 3:
			sndoggvorbis_start("/cd/data/music/music3.ogg", 0 );
			break;
		case 4:
			sndoggvorbis_start("/cd/data/music/music4.ogg", 0 );
			break;
		case 5:
			sndoggvorbis_start("/cd/data/music/music5.ogg", 0 );
			break;
		case 6:
			sndoggvorbis_start("/cd/data/music/music6.ogg", 0 );
			break;
		case 7:
			sndoggvorbis_start("/cd/data/music/music7.ogg", 0 );
			break;
		case 8:
			sndoggvorbis_start("/cd/data/music/music8.ogg", 0 );
			break;
		case 9:
			sndoggvorbis_start("/cd/data/music/music9.ogg", 0 );
			break;
		case 10:
			sndoggvorbis_start("/cd/data/music/music10.ogg", 0 );
			break;
	}

	ExitGame=FALSE;

	snd_sfx_play( SAMPLE_LEVELSTART, 255, 128 );
	while( ExitGame == FALSE )
	{
		//printf ( "Player Position: %d, %d\n\r", Players[0].XPos, Players[0].YPos );
		timer_ms_gettime( &secs, &msecs);

		if ( sndoggvorbis_isplaying() == 0 && music != 0 )
		{
			switch ( music )
			{
				case 1:
					sndoggvorbis_start("/cd/data/music/music1.ogg", 0 );
					break;
				case 2:
					sndoggvorbis_start("/cd/data/music/music2.ogg", 0 );
					break;
				case 3:
					sndoggvorbis_start("/cd/data/music/music3.ogg", 0 );
					break;
				case 4:
					sndoggvorbis_start("/cd/data/music/music4.ogg", 0 );
					break;
				case 5:
					sndoggvorbis_start("/cd/data/music/music5.ogg", 0 );
					break;
				case 6:
					sndoggvorbis_start("/cd/data/music/music6.ogg", 0 );
					break;
				case 7:
					sndoggvorbis_start("/cd/data/music/music7.ogg", 0 );
					break;
				case 8:
					sndoggvorbis_start("/cd/data/music/music8.ogg", 0 );
					break;
				case 9:
					sndoggvorbis_start("/cd/data/music/music9.ogg", 0 );
					break;
				case 10:
					sndoggvorbis_start("/cd/data/music/music10.ogg", 0 );
					break;
			}
		}

		UpdateControls();
		ProcessPlayers();
		ProcessPlayerBullets();
		UpdateAnimation();
		UpdateEnemyAnimations();
		ProcessEnemies();
		UpdateEffectsAnimations();
		CheckforEnemyBulletCollisions();
		CheckforEnemyPlayerCollisions();
		CheckforItemPlayerCollisions();
		ProcessEffects();

		if ( PadInPort( 0 ) == FALSE )
		{
			Players[0].Active=FALSE;
			Players[0].Lives=0;
		}
		if ( PadInPort( 1 ) == FALSE )
		{
			Players[1].Active=FALSE;
			Players[1].Lives=0;
		}
		if ( PadInPort( 2 ) == FALSE )
		{
			Players[2].Active=FALSE;
			Players[2].Lives=0;
		}
		if ( PadInPort( 3 ) == FALSE )
		{
			Players[3].Active=FALSE;
			Players[3].Lives=0;
		}

		if ( Players[0].Active==FALSE && Players[1].Active==FALSE &&
			Players[2].Active==FALSE && Players[3].Active==FALSE )
		{
			DoGameOver();
			ExitGame=TRUE;
		}

		if ( CurrentRoom == 19 )
		{
			// Boss room!
			// Is boss spawned?
			if ( BossActive == FALSE && Rooms[19].Completed == FALSE )
			{
				SpawnEnemy( 320, 105, DOWN, DRWILY );
				BossActive=TRUE;
			}

			if ( BossActive == TRUE && BossDead == TRUE )
				DoWin();
		}
		else if ( Rooms[CurrentRoom].EnemiesPos == Rooms[CurrentRoom].EnemiesPerWave )
		{
			if ( EnemiesActive() == 0 )
			{
				if ( Rooms[CurrentRoom].CurrentWave <= Rooms[CurrentRoom].Waves )
				{
					Rooms[CurrentRoom].EnemiesPos=0;
					Rooms[CurrentRoom].CurrentWave++;
					//printf( "Wave complete!\n\r" );
				}
				else if ( Rooms[CurrentRoom].Completed == FALSE )
				{
					//printf( "Room complete.\n\r" );
					Rooms[CurrentRoom].Completed=TRUE;
					snd_sfx_play( SAMPLE_ROOMDONE, 255, 128);
				}
			}
		}
		else if ( Rooms[CurrentRoom].SpawnDelayPos > Rooms[CurrentRoom].SpawnDelay )
		{
			srand( msecs );

			switch( Rooms[CurrentRoom].LastDoorUsed )
			{
				case UP:
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 585, 190, LEFT, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 585, 270, LEFT, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					Rooms[CurrentRoom].LastDoorUsed=RIGHT;
					break;
				case DOWN:
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 55, 190, RIGHT, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}

					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 55, 270, RIGHT, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					Rooms[CurrentRoom].LastDoorUsed=LEFT;
					break;
				case LEFT:
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 280, 105, DOWN, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 360, 105, DOWN, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					Rooms[CurrentRoom].LastDoorUsed=UP;
					break;
				case RIGHT:
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 280, 475, UP, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					if ( Rooms[CurrentRoom].EnemiesPos != Rooms[CurrentRoom].EnemiesPerWave )
					{
						if ( SpawnEnemy( 360, 475, UP, rand()%8 ) == TRUE )
							Rooms[CurrentRoom].EnemiesPos++;
					}
					Rooms[CurrentRoom].LastDoorUsed=DOWN;
					break;
			}
			Rooms[CurrentRoom].SpawnDelayPos=0;
		}
		else
			Rooms[CurrentRoom].SpawnDelayPos++;

		pvr_wait_ready();
	    pvr_scene_begin();
		pvr_list_begin(PVR_LIST_OP_POLY);
		DrawRoom();
		pvr_list_finish();
		pvr_list_begin(PVR_LIST_TR_POLY);

		if ( Rooms[CurrentRoom].Completed == TRUE )
		{
			if ( Rooms[CurrentRoom].North != 0 )
				DrawExitArrow( UP, 340, 270, TRUE );
			else
				DrawExitArrow( UP, 340, 270, FALSE );

			if ( Rooms[CurrentRoom].South != 0 )
				DrawExitArrow( DOWN, 340, 338, TRUE );
			else
				DrawExitArrow( DOWN, 340, 338, FALSE );

			if ( Rooms[CurrentRoom].West != 0 )
				DrawExitArrow( LEFT, 310, 295, TRUE );
			else
				DrawExitArrow( LEFT, 310, 295, FALSE );

			if ( Rooms[CurrentRoom].East != 0 )
				DrawExitArrow( RIGHT, 390, 295, TRUE );
			else
				DrawExitArrow( RIGHT, 390, 295, FALSE );
		}
		else
		{
			DrawExitArrow( UP, 340, 270, FALSE );
			DrawExitArrow( DOWN, 340, 338, FALSE );
			DrawExitArrow( LEFT, 310, 295, FALSE );
			DrawExitArrow( RIGHT, 390, 295, FALSE );
		}
		DrawItems();
		DrawPlayers();
		DrawPlayerBullets();
		DrawEnemies();
		DrawEffects();
		DrawLifePanels();
		DrawOverlay( Overlays[Rooms[CurrentRoom].Overlay] );
		sprintf( buffer, "%d", Players[0].Lives );
		DrawNumber( buffer, 42, 50, 6 );
		sprintf( buffer, "%d", Players[1].Lives );
		DrawNumber( buffer, 115, 50, 6 );
		sprintf( buffer, "%d", Players[2].Lives );
		DrawNumber( buffer, 489, 50, 6 );
		sprintf( buffer, "%d", Players[3].Lives );
		DrawNumber( buffer, 561, 50, 6 );

		pvr_list_finish();
		pvr_scene_finish();
		
		//printf( "Enemies Active: %d\n\r", EnemiesActive() );
 	}
}
