#include <kos.h>
#include "smashdc.h"
#include "vars.h"

int SpawnEnemy( int xpos, int ypos, int direction, int type )
{
	int i,j;
	int retval=TRUE;
	int done=FALSE;

	i=0;
	while ( done == FALSE )
	{
		if ( i < MAX_ENEMIES )
		{
			if ( Enemies[i].Active == FALSE )
			{
				// Slot found..
				Enemies[i].Type=type;
				Enemies[i].XPos=xpos;
				Enemies[i].YPos=ypos;
				Enemies[i].Width=38;
				Enemies[i].Height=38;
				Enemies[i].DrawWidth=96;
				Enemies[i].DrawHeight=96;
				Enemies[i].WalkingDirection=direction;
				Enemies[i].Active=TRUE;
				Enemies[i].Points=100;
				Enemies[i].PlayerTarget=NearestPlayer( i );

				switch ( Enemies[i].Type )
				{
					case SNAKEMAN:
						Enemies[i].WalkingSpeed=3;
						Enemies[i].Life=2;
						break;
					case SKULLMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=5;
						break;
					case GEMINIMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=5;
						break;
					case WOODMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=10;
						Enemies[i].Width=45;
						Enemies[i].Height=45;
						Enemies[i].DrawWidth=150;
						Enemies[i].DrawHeight=150;
						Enemies[i].Points=150;
						break;
					case NEEDLEMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=5;
						Enemies[i].Width=45;
						Enemies[i].Height=45;
						Enemies[i].DrawWidth=150;
						Enemies[i].DrawHeight=150;
						Enemies[i].Points=125;
						break;
					case PHARAOHMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=30;
						Enemies[i].Width=45;
						Enemies[i].Height=45;
						Enemies[i].DrawWidth=150;
						Enemies[i].DrawHeight=150;
						Enemies[i].Points=200;
						break;
					case TOPMAN:
						Enemies[i].WalkingSpeed=4;
						Enemies[i].Life=1;
						Enemies[i].Points=110;
						break;
					case BOMBMAN:
						Enemies[i].WalkingSpeed=2;
						Enemies[i].Life=5;
						break;
					case DRWILY:
						Enemies[i].WalkingSpeed=1;
						Enemies[i].Life=500;
						Enemies[i].Width=175;
						Enemies[i].Height=175;
						Enemies[i].DrawWidth=384;
						Enemies[i].DrawHeight=384;
						Enemies[i].Points=1000;
						break;
				}

				// in boundaries?
				if ( Enemies[i].XPos < 50 || Enemies[i].XPos > 590 )
				{
					retval=FALSE;
					Enemies[i].Active=FALSE;
				}
				else if ( Enemies[i].YPos < 100 || Enemies[i].YPos > 480 )
				{
					retval=FALSE;
					Enemies[i].Active=FALSE;
				}

				// collision upon spawn?
				for ( j=0; j<MAX_ENEMIES; j++ )
				{
					if ( EnemyEnemyCollision( i, j ) == TRUE )
					{
						//printf( "Spawn enemy failed!\n\r" );
						retval=FALSE;
						Enemies[i].Active=FALSE;
					}
				}
				done=TRUE;
			}
			else i++;
		}
		else
			done=TRUE;
	}

	//if ( retval == FALSE )
		//printf( "Enemy Spawn Failed at %d,%d of type %d\n\r", xpos, ypos, type );

	return retval;
}
