#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void SpawnEffect( int effecttype, int xpos, int ypos, int width, int height, int duration )
{
	int i=0;
	int done=FALSE;

	while ( done == FALSE )
	{
		if ( i < MAX_ENEMIES )
		{
			if ( Effects[i].Active == FALSE )
			{
				ResetEffectAnim( i );
				Effects[i].Active=TRUE;
				Effects[i].Type=effecttype;
				Effects[i].XPos=xpos;
				Effects[i].YPos=ypos;

				Effects[i].Width=width;
				Effects[i].Height=height;

				Effects[i].DurationPos=0;
				Effects[i].Duration=duration;

				done=TRUE;
			}
				else i++;
		}
		else
			done=TRUE;
	}
}

void ProcessEffect( int effectindex )
{
	if ( Effects[effectindex].DurationPos == Effects[effectindex].Duration )
		Effects[effectindex].Active = FALSE;
	else
		Effects[effectindex].DurationPos++;
}

void ProcessEffects()
{
	int i;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		if ( Effects[i].Active == TRUE )
		{
			ProcessEffect( i );
		}
	}
}
