#include <kos.h>
#include "smashdc.h"
#include "vars.h"

void DrawPanel( pvr_ptr_t tex, int xpos, int ypos )
{
  pvr_poly_cxt_t cxt;
  pvr_poly_hdr_t poly;
  pvr_vertex_t   vert;
  
  pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB1555|PVR_TXRFMT_TWIDDLED, 128, 128, tex, PVR_FILTER_BILINEAR);
  pvr_poly_compile(&poly, &cxt);
  pvr_prim(&poly, sizeof(poly));
  
  vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
  vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
  vert.flags = PVR_CMD_VERTEX;

  vert.x = xpos;
  vert.y = ypos;
  vert.z = 5;
  vert.u = 0.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+165;
  vert.y = ypos;
  vert.z = 5;
  vert.u = 1.0;
  vert.v = 0.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos;
  vert.y = ypos+125;
  vert.z = 5;
  vert.u = 0.0;
  vert.v = 1.0;
  pvr_prim(&vert, sizeof(vert));

  vert.x = xpos+165;
  vert.y = ypos+125;
  vert.z = 5;
  vert.u = 1.0;
  vert.v = 1.0;
  vert.flags = PVR_CMD_VERTEX_EOL;
  pvr_prim(&vert, sizeof(vert));

}

void DrawLifePanels()
{
	DrawPanel( LifePanels[0], 20, 25 );
	DrawPanel( LifePanels[1], 465, 25 );
}

void DrawRoom()
{
	DrawFloor( Floors[Rooms[CurrentRoom].Floor] );
}
