#include <kos.h>
#include <stdlib.h>
#include "smashdc.h"
#include "vars.h"

int CheckBoxCollision( int spr1x, int spr1y, int spr1width, int spr1height,
	int spr2x, int spr2y, int spr2width, int spr2height )
 {
 if ((spr1x>spr2x+spr2width) || (spr2x > spr1x+spr1width) ||
     (spr1y>spr2y+spr2height) || (spr2y> spr1y+spr1height))
  {
     return FALSE;
  }
  else
  {
   return TRUE;
  }
}

void CheckforItemPlayerCollisions()
{
	int i,j;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		for ( j=0; j<MAX_PLAYERS; j++ )
		{
			if ( ItemPlayerCollision( i, j ) == TRUE )
			{
				Rooms[CurrentRoom].Items[i].Active=FALSE;

				switch ( Rooms[CurrentRoom].Items[i].Type )
				{
					case ITEM_1UP:
						snd_sfx_play(SAMPLE_ITEMGRAB1UP, 255, 128);
						Players[j].Lives++;
						break;
					case ITEM_MINE:
						if ( Players[j].Lives == 0 )
						{
							Players[j].Active=FALSE;
						}
						else
						{
							if ( Players[j].Alive == TRUE && Players[j].Invincible == FALSE )
							{
								// Player has lost a life..
								snd_sfx_play(SAMPLE_ITEMGRABMINE, 255, 128);
								Players[j].Alive = FALSE;
								snd_sfx_play(SAMPLE_PLAYERDEATH, 255, 128);
								Players[j].Lives--;
								SpawnEffect( EFFECT_BOMBDEATH, Rooms[CurrentRoom].Items[i].XPos,
									Rooms[CurrentRoom].Items[i].YPos, 128, 128, 30 );
								Players[j].Weapon=WEAPON_BULLET;
							}
							else
								Rooms[CurrentRoom].Items[i].Active=TRUE;
						}
						break;
					case ITEM_MONEY:
						snd_sfx_play(SAMPLE_ITEMGRAB, 255, 128);
						Players[j].Score+=250;
						break;
					case ITEM_SILVER:
						snd_sfx_play(SAMPLE_ITEMGRAB, 255, 128);
						Players[j].Score+=500;
						break;
					case ITEM_GOLD:
						snd_sfx_play(SAMPLE_ITEMGRAB, 255, 128);
						Players[j].Score+=1000;
						break;
					case ITEM_ROCKET:
						snd_sfx_play(SAMPLE_ITEMGRAB, 255, 128);
						Players[j].Weapon=WEAPON_ROCKET;
						break;
				}
			}
		}
	}
}

void CheckforEnemyPlayerCollisions()
{
	int i,j;

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		for ( j=0; j<MAX_PLAYERS; j++ )
		{
			if ( EnemyPlayerCollision( i, j ) == TRUE )
			{
				if ( Players[j].Lives == 0 )
				{
					// Player is gameover..
					Players[j].Active=FALSE;
				}
				else
				{
					if ( Players[j].Alive == TRUE && Players[j].Invincible == FALSE )
					{
						// Player has lost a life..
						Players[j].Alive = FALSE;
						snd_sfx_play(SAMPLE_PLAYERDEATH, 255, 128);
						Players[j].Lives--;
						Players[j].Weapon=WEAPON_BULLET;
					}
				}
			}
		}
	}
}

void CheckforEnemyBulletCollisions()
{
	int i,j;
	//printf( "In check for..\n\r" );

	for ( i=0; i<MAX_ENEMIES; i++ )
	{
		for ( j=0; j<MAX_BULLETS; j++ )
		{
			if ( BulletEnemyCollision( i, j ) == TRUE )
			{
				switch( PlayerBullets[j].Type )
				{
					case WEAPON_BULLET:
						Enemies[i].Life--;
						break;
					case WEAPON_ROCKET:
						Enemies[i].Life-=2;
						break;
				}

				if ( Enemies[i].Life <= 0 ) // enemy dead
				{
					Enemies[i].Active=FALSE;
					PlayerBullets[j].Active=FALSE;
					SpawnEffect( EFFECT_ENEMYDEATH, Enemies[i].XPos, Enemies[i].YPos,
						Enemies[i].Width*2, Enemies[i].Height*2, 20 );
					snd_sfx_play(SAMPLE_ENEMYDEATH, 255, 128);

					Players[PlayerBullets[j].Owner].Score+=Enemies[i].Points;
					SpawnItem( rand()%6, Enemies[i].XPos, Enemies[i].YPos );

					// enemy specific extras..
					switch ( Enemies[i].Type )
					{
						case BOMBMAN:
							SpawnEffect( EFFECT_BOMBDEATH, Enemies[i].XPos, Enemies[i].YPos,
							Enemies[i].Width*6, Enemies[i].Height*6, 20 );
							KillPlayersInBox( Enemies[i].XPos-(Enemies[i].Width*3),
							Enemies[i].YPos-(Enemies[i].Height*3),
							Enemies[i].Width*6, Enemies[i].Height*6 );
							break;
						case NEEDLEMAN:
							// spawn needles..
							break;
						case DRWILY:
							BossDead=TRUE;
							break;
					}
				}
				else // enemy hurt
				{
					PlayerBullets[j].Active=FALSE;
					if ( Enemies[i].Type == DRWILY )
						snd_sfx_play(SAMPLE_BOSSHURT, 255, 128);
					else
						snd_sfx_play(SAMPLE_ENEMYHURT, 255, 128);
				}
			}
		}
	}
}

int EnemyEnemyCollision( int enemyindex1, int enemyindex2 )
{
	int retval=FALSE;

	if ( Enemies[enemyindex1].Active == TRUE && Enemies[enemyindex2].Active == TRUE )
	{
		if ( enemyindex1 != enemyindex2 )
		{
			if ( CheckBoxCollision( Enemies[enemyindex1].XPos-Enemies[enemyindex1].Width/2,
				Enemies[enemyindex1].YPos-Enemies[enemyindex1].Height,
				Enemies[enemyindex1].Width, Enemies[enemyindex1].Height,
				Enemies[enemyindex2].XPos-Enemies[enemyindex2].Width/2,
				Enemies[enemyindex2].YPos-Enemies[enemyindex2].Height,
				Enemies[enemyindex2].Width, Enemies[enemyindex2].Height ) == TRUE )
			{
				retval=TRUE;
			}
		}
	}

	return retval;
}

int BulletEnemyCollision( int enemyindex, int bulletindex )
{
	int retval=FALSE;

	if ( Enemies[enemyindex].Active == TRUE && PlayerBullets[bulletindex].Active == TRUE )
	{
		if ( CheckBoxCollision( PlayerBullets[bulletindex].XPos-4,
			PlayerBullets[bulletindex].YPos-4, 8, 8,
			Enemies[enemyindex].XPos-Enemies[enemyindex].Width/2,
			Enemies[enemyindex].YPos-Enemies[enemyindex].Height,
			Enemies[enemyindex].Width, Enemies[enemyindex].Height ) == TRUE )
		{
			retval=TRUE;
		}
	}

	return retval;
}

int EnemyPlayerCollision( int enemyindex, int playerindex )
{
	int retval=FALSE;

	if ( Enemies[enemyindex].Active == TRUE && Players[playerindex].Active == TRUE )
	{
		if ( CheckBoxCollision( Enemies[enemyindex].XPos-Enemies[enemyindex].Width/2,
			Enemies[enemyindex].YPos-Enemies[enemyindex].Height,
			Enemies[enemyindex].Width, Enemies[enemyindex].Height,
			Players[playerindex].XPos-(26/2), Players[playerindex].YPos-26, 26, 26 ) == TRUE )
		{
			retval=TRUE;
		}
	}

	return retval;
}

int ItemPlayerCollision( int itemindex, int playerindex )
{
	int retval=FALSE;

	if ( Rooms[CurrentRoom].Items[itemindex].Active == TRUE &&
		Players[playerindex].Active == TRUE )
	{
		if ( CheckBoxCollision( Rooms[CurrentRoom].Items[itemindex].XPos-16,
			Rooms[CurrentRoom].Items[itemindex].YPos-16,
			32, 32, Players[playerindex].XPos-(26/2),
			Players[playerindex].YPos-26, 26, 26 ) == TRUE )
		{
			retval=TRUE;
		}
	}

	return retval;
}
