#include <kos.h>
#include "sound.h"
#include "aica_fw.h"		/* AICA firmware code (s3mplay) */
#include "phoenix_samples.h"    /* Phoenix Samples (RAW Format) */

volatile unsigned long *snd_iface = (unsigned long*)0xa080ffc0;

#define SND_STATUS	0
#define SND_MONO	1
#define SND_SMP		2
#define SND_SMP_WHERE	3
#define SND_SMP_SIZE	4
#define SND_SMP_HZ	5

/* Details of the sound effects */
int sfx_addrs[7] = {0x10000,0x12000, 0x15000, 0x1d000, 0x20000, 0x22000, 0x25000}; /* Addresses */
int sfx_sizes[7] = {0x1dec, 0x290e,  0x60f0,  0x3a16,  0xd5c,   0x103e,  0x3aae};  /* Lengths */
int sfx_hz[7]	 = {8012,   11025,   8000,    8012,    8000,    8012,    8012};    /* Sample Hz */

/* ---------------------------------------------------------------------------
   Setup Sound and load samples into memory
 ----------------------------------------------------------------------------*/

void sound_setup()
{
	//Use SPU functions of KOS.
	spu_disable();

	/* Load the sound effects */
	spu_memload(sfx_addrs[0], phoenix_blow, sizeof(phoenix_blow));
	spu_memload(sfx_addrs[1], phoenix_eep, sizeof(phoenix_eep));
	spu_memload(sfx_addrs[2], phoenix_explosion, sizeof(phoenix_explosion));
	spu_memload(sfx_addrs[3], phoenix_hit, sizeof(phoenix_hit));
	spu_memload(sfx_addrs[4], phoenix_laser, sizeof(phoenix_laser));
	spu_memload(sfx_addrs[5], phoenix_shield, sizeof(phoenix_shield));
	spu_memload(sfx_addrs[6], phoenix_shot, sizeof(phoenix_shot));

	/* Check mono mode.. if turned on, tell S3MPlay */
	snd_iface[SND_MONO] = 1;

	/* Load the ARM Code */
	spu_memload(0, s3mplay, sizeof(s3mplay));
	spu_enable();

		/* Wait for program to start (load cycle) */
		while (*snd_iface != 3)
			;
		/* Wait for program to play (end load cycle) */
		while (*snd_iface == 3)
			;
}

/* ---------------------------------------------------------------------------
   Trigger a Sound Effect
 ----------------------------------------------------------------------------*/

void sound_effect(int idx)
{
	snd_iface[SND_SMP_WHERE] = sfx_addrs[idx];
	snd_iface[SND_SMP_SIZE] = sfx_sizes[idx]/2;

	/* Max sample size is 65536, but we have to cut back 32 */
	if (snd_iface[SND_SMP_SIZE] > 65504)
		snd_iface[SND_SMP_SIZE] = 65504;
	snd_iface[SND_SMP_HZ] = sfx_hz[idx];
	snd_iface[SND_SMP] = 1;
}