#include <kos.h>
#include <stdio.h>
#include <stdlib.h>

#include "Z80/Z80.h"
#include "phoenix.h"
#include "gui.h"
#include "gui_graphics.h"		/* Some PCX Graphics */
#include "video.h"
#include "vmulcd.h"			/* VMU LCD Code */

/* ---------------------------------------------------------------------------
   PCX Routines, nicked from somewhere, and slightly modified.
   This is all slightly crusty to say the least, next time I'll preconvert
   the images to the RGB565...

   Also, it's rather lame including them all in the header, but it saves
   messing about burning CDs when testing / or making ISO images etc.
 ----------------------------------------------------------------------------*/

struct pcx_hdr
{
	char   Mfg;               /* manufacturer, always 0xa0         */
	char   Ver;               /* encoder version number (5)        */
	char   Enc;               /* encoding code, always 1           */
	char   Bpp;               /* bits per pixel, 8 in mode 0x13    */
	uint16 Xmin,Ymin;         /* image origin, usually 0,0         */
	uint16 Xmax,Ymax;         /* image dimensions                  */
	uint16 Hres;              /* horizontal resolution value       */
	uint16 Vres;              /* vertical resolution value         */
	char   Pal[48];           /* palette (not in mode 0x13)        */
	char   Reserved;          /* who knows?                        */
	char   ClrPlanes;         /* number of planes, 1 in mode 0x13  */
	uint16 Bpl;               /* bytes per line, 80 in mode 0x13   */
	uint16 plType;            /* Grey or Color palette flag        */
	char   Filler[58];        /* Zsoft wanted a 128 byte header    */
};

Image *load_pcx_ex(unsigned char *pcx, int x)
{
	int	bytes = 0;	/* counts unpacked bytes */
	char	c;		/* byte being processed  */
	int	runlen, i;	/* length of packet      */
	int	num_bytes;
	struct  pcx_hdr pcxh;
	unsigned char *pcxpal;
	Image *rv;

	memcpy(&pcxh, pcx, sizeof(pcxh)); pcx += sizeof(pcxh);

	if (pcxh.Bpp!=8)
		return 0;

	/* Allocate the output structure */
	rv = (Image*)malloc(sizeof(Image));
	rv->width = pcxh.Xmax + 1;
	rv->height = pcxh.Ymax + 1;
	num_bytes = rv->width * rv->height;
	rv->pixel_data = (unsigned short *)malloc(num_bytes * 2);

	/* Do the RLE decoding */
	{
		unsigned char image[num_bytes];
		do
		{
			c = *pcx++;			/* Read one byte */

			if ((c & 0xc0) == 0xc0)
			{				/* high 2 bits set is packet */
				runlen = (c & 0x3f);	/* AND off the high bits */
				c = *pcx++;;
				while(runlen--)
					image[bytes++] = c;
			}
			else
				image[bytes++] = c;
		}

		while (bytes < num_bytes);

		/* Load the palette */
		pcx++;			/* This is a marker before the palette */
		pcxpal = pcx;

		/* Decode the image into RGB565 */
		for (i=0; i<num_bytes; i++)
		{
			int v = image[i];
			int r = pcxpal[v*3+0];
			int g = pcxpal[v*3+1];
			int b = pcxpal[v*3+2];

			v = (((r >> 3) & 0x1f) << 11)
				| (((g >> 2) & 0x3f) << 5)
				| (((b >> 3) & 0x1f) << 0);
			rv->pixel_data[i] = v;
		}
	}

	return rv;
}

Image *load_pcx(unsigned char *pcx)
{
	return load_pcx_ex(pcx, 0);
}

/* ---------------------------------------------------------------------------
   Put the Image structure on the screen
 ----------------------------------------------------------------------------*/

void putimage(int xpos, int ypos, Image *img, unsigned short *vptr)
{
	unsigned long width;
	unsigned long height;
	unsigned short *imgdata;
	short x, y;

	width = img->width;
	height = img->height;
	imgdata = img->pixel_data;

	vptr += xpos + ypos * 640;

	for (y = ypos; y < height + ypos; y++)
	{
		for (x = xpos; x < width + xpos; x++)
		{
			*vptr++ = *imgdata++;
		}
		vptr += 640 - width;
	}
}

/* ---------------------------------------------------------------------------
   Erase an image, stick black there instead
 ----------------------------------------------------------------------------*/

void eraseimage(int xpos, int ypos, Image *img, unsigned short *vptr)
{
	unsigned long width;
	unsigned long height;
	short x, y;

	width = img->width;
	height = img->height;

	vptr += xpos + ypos * 640;

	for (y = ypos; y < height + ypos; y++)
	{
		for (x = xpos; x < width + xpos; x++)
		{
			*vptr++ = 0x0000; /* Black */
			//*vptr++ = 65535; /* White */
		}
		vptr += 640 - width;
	}
}

/* ---------------------------------------------------------------------------
   Do Selector ship and return the option chosen....
   it's crusty, it's musty, it's more dodgy code from myself! yeah!
 ----------------------------------------------------------------------------*/

int do_sub_menu(int no_of_items, int menupos)
{
	maple_device_t *mcont;
	cont_state_t *cond;
	
	maple_device_t *mvmu;

	int phase = 0;				/* For VMU Animation Cycling */
	int itemspace = 30;			/* Space between items */
	int selectorx = 275;			/* X of selector */
	int selectory = 250;			/* Y of selector */
	int oldmenupos = 0;			/* Position in menu */
	Image *select;				/* Holds ship graphic */
	
	
	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER); /* Get Controller Address */
	if (!mcont) return -1;
	
	mvmu = maple_enum_type(0, MAPLE_FUNC_LCD); /* Get LCD Address */

	/* Load selector image thing */
	select = load_pcx(gui_ship);

	/* Draw selector ship */
	if (no_of_items > 1)
		putimage(selectorx, selectory + (itemspace*menupos), select, vram_s);

	/* Wait for user to select something */
	while(1)
	{
	    cond = (cont_state_t *)maple_dev_status(mcont);
		if (!cond) /* error getting controller status */
		{
			return -1;
		}

		/* Moving up the screen, down a menu position */
	    if((cond->buttons  & CONT_DPAD_UP))
		{
			if (menupos>0)
			{
				/* Keep a copy of where we were last for erasing purposes */
				oldmenupos = menupos;
				/* Erase old ship */
				eraseimage(selectorx, selectory + (itemspace*oldmenupos), select, vram_s);
				/* Move down a menu position */
				menupos--;
				/* Draw new one */
				putimage(selectorx, selectory + (itemspace*menupos), select, vram_s);
			}
	 	}

	    if((cond->buttons  & CONT_DPAD_DOWN))
		{
			if (menupos<no_of_items-1 && no_of_items > 0)
			{
				oldmenupos = menupos;
				eraseimage(selectorx, selectory + (itemspace*oldmenupos), select, vram_s);
				menupos++;
				putimage(selectorx, selectory + (itemspace*menupos), select, vram_s);
			}
	 	}

	 	if((cond->buttons & CONT_A))
	 	{
			oldmenupos = menupos;
			if (no_of_items > 0)
				eraseimage(selectorx, selectory + (itemspace*oldmenupos), select, vram_s);

			thd_sleep(150); /* Sleep so we don't skip through multiple menus by accident */
			break;
		}

		if(mvmu)				/* If there's a VMU attached */
		{
			if (phase > 4) phase = 1;	/* Reset to first image */
			vmu_lcd_update(phase, mvmu);	/* Stick Image on VMU */
			phase++;			/* Increment phase of animation */
		}


	 	thd_sleep(150);
	}

	if (mvmu) vmu_lcd_update(1, mvmu); 		/* Stick main image on LCD */
	return menupos; 				/* Return item selected */

}

/* ---------------------------------------------------------------------------
   Draw Main Menu, someone improve for code (please..) :)
 ----------------------------------------------------------------------------*/

void do_menu()
{
	int choice =0;			/* Holds the user's choice from the menu */
	int menu = 0;			/* The menu we are currently displaying */
	int x, y;			/* For Screen Clearing */
	int itemx = 300;		/* X of first text item */
	int itemy = 250;		/* Y of first text item */

	int dip_lives = 3;
	int dip_bonus = 3000;
	int dip_coins = 1;

	/* Set Internal Dip Settings According to Real Dip Switches */
	/* Bit 0 ON */
	if (Dips & 0x01) dip_lives++;
	/* Bit 1 ON */
	if (Dips & 0x02) dip_lives+=2;
	/* Bit 2 ON */
	if (Dips & 0x04) dip_bonus+=1000;
	/* Bit 3 ON */
	if (Dips & 0x08) dip_bonus+=2000;
	/* Bit 4 ON */
	if (Dips & 0x10) dip_coins++;

	game = 0;	/* No game has been selected */

	while(!game)	/* Until the user selects a game display the GUI.... */
	{

		/* Clear menu box thing */

		for(x = 300; x < 585; x++)
			for(y = 250; y < 420; y++)
          			vram_s[640*y + x] = 0;

		switch(menu)
		{
			/* -- Main Menu ---------------------------------------------------------------------- */
			case 0:
				bfont_draw_str(vram_s+(itemy+  0)*640+itemx, 640, 0,"Play Phoenix");
				bfont_draw_str(vram_s+(itemy+ 30)*640+itemx, 640, 0,"Play Pleiads (No Sound)");
				bfont_draw_str(vram_s+(itemy+ 60)*640+itemx, 640, 0,"Settings");
				bfont_draw_str(vram_s+(itemy+ 90)*640+itemx, 640, 0,"About DCPhoenix");
				bfont_draw_str(vram_s+(itemy+120)*640+itemx, 640, 0,"Exit DCPhoenix");

				choice = do_sub_menu(5, 0); /* Get Chosen Option */

				if (choice == 0) game = 1;		/* Phoenix Chosen */
				else if (choice == 1) game = 2;		/* Pleiads Chosen */
				else if (choice == 2) menu = 1;		/* Settings Menu */
				else if (choice == 3) menu = 4;		/* About Menu */
				else if (choice == 4)
					(*(void(**)())0x8c0000e0)(1); 	/* Exit to DC Menu */
				break;
			/* -- Settings Menu ------------------------------------------------------------------ */
			case 1:
				bfont_draw_str(vram_s+(itemy+ 0)*640+itemx, 640, 0,"View Controls");
				bfont_draw_str(vram_s+(itemy+30)*640+itemx, 640, 0,"Change Dipswitches");
				bfont_draw_str(vram_s+(itemy+60)*640+itemx, 640, 0,"Return to Main Menu");

				choice = do_sub_menu(3, 0);

				if (choice == 0) menu = 2;
				else if (choice == 1)
				{
					menu = 3;
					choice = 0;
				}
				else if (choice == 2) menu = 0;
				break;
			/* -- Controls Menu ------------------------------------------------------------------ */
			case 2:
				bfont_draw_str(vram_s+(itemy+ 0)*640+itemx, 640, 0,"D-PAD      Movement");
				bfont_draw_str(vram_s+(itemy+25)*640+itemx, 640, 0,"A          Fire");
				bfont_draw_str(vram_s+(itemy+50)*640+itemx, 640, 0,"B          Shield");
				bfont_draw_str(vram_s+(itemy+75)*640+itemx, 640, 0,"X          Insert Coin");
				bfont_draw_str(vram_s+(itemy+100)*640+itemx, 640,0,"L Trigger  1P Start");
				bfont_draw_str(vram_s+(itemy+125)*640+itemx, 640,0,"R Trigger  2P Start");
				bfont_draw_str(vram_s+(itemy+150)*640+itemx, 640,0,"START      Main Menu");
				choice = do_sub_menu(0, 0);
				menu = 1;
				break;
			/* -- Dipswitch Menu ----------------------------------------------------------------- */
			case 3:

				bfont_draw_str(vram_s+(itemy+ 0)*640+itemx, 640, 0,"Lives");

				if (dip_lives == 3)
					bfont_draw_str(vram_s+(itemy+ 0)*640+(itemx+220), 640, 0,"3");
				else if (dip_lives == 4)
					bfont_draw_str(vram_s+(itemy+ 0)*640+(itemx+220), 640, 0,"4");
				else if (dip_lives == 5)
					bfont_draw_str(vram_s+(itemy+ 0)*640+(itemx+220), 640, 0,"5");
				else if (dip_lives == 6)
					bfont_draw_str(vram_s+(itemy+ 0)*640+(itemx+220), 640, 0,"6");

				bfont_draw_str(vram_s+(itemy+30)*640+itemx, 640, 0,"Bonus");
				if (dip_bonus==3000)
					bfont_draw_str(vram_s+(itemy+ 30)*640+(itemx+220), 640, 0,"3000");
				else if (dip_bonus==4000)
					bfont_draw_str(vram_s+(itemy+ 30)*640+(itemx+220), 640, 0,"4000");
				else if (dip_bonus==5000)
					bfont_draw_str(vram_s+(itemy+ 30)*640+(itemx+220), 640, 0,"5000");
				else if (dip_bonus==6000)
					bfont_draw_str(vram_s+(itemy+ 30)*640+(itemx+220), 640, 0,"6000");

				bfont_draw_str(vram_s+(itemy+60)*640+itemx, 640, 0,"Coins Per Play");
				if (dip_coins==1)
					bfont_draw_str(vram_s+(itemy+60)*640+(itemx+220), 640, 0,"1");
				else
					bfont_draw_str(vram_s+(itemy+60)*640+(itemx+220), 640, 0,"2");

				bfont_draw_str(vram_s+(itemy+90)*640+itemx, 640,0,"Return to Main Menu");
				choice = do_sub_menu(4, choice);

				if (choice == 0)
				{
					if (dip_lives<6) dip_lives ++;
					else dip_lives = 3;
					menu = 3;
				}
				else if (choice == 1)
				{
					if (dip_bonus<6000) dip_bonus+=1000;
					else dip_bonus = 3000;
					menu = 3;
				}
				else if (choice == 2)
				{
					if (dip_coins<2) dip_coins++;
					else dip_coins = 1;
					menu = 3;
				}

				else if (choice == 3) menu = 0; /* Main */
				break;

			/* -- About Menu --------------------------------------------------------------------- */
			case 4:
				bfont_draw_str(vram_s+(itemy+ 0)*640+itemx, 640, 0,"DCPhoenix 0.5");
				bfont_draw_str(vram_s+(itemy+60)*640+itemx, 640, 0,"pointblnk@hotmail.com");
				bfont_draw_str(vram_s+(itemy+90)*640+itemx, 640, 0,"Phoenix Arcade Emulator");
				choice = do_sub_menu(0, 0);
				menu = 0;
				break;
			default:
				break;
		}
		/* End of Switch */
	}
	/* End of While */


	/* Set Dips According to GUI */
	Dips = 64;

	if (dip_lives==4) Dips+=1;
	else if (dip_lives==5) Dips +=2;
	else if (dip_lives==6) Dips +=3;

	if (dip_bonus==4000) Dips +=4;
	else if (dip_bonus==5000) Dips +=8;
	else if (dip_bonus==6000) Dips +=12;

	if (dip_coins > 1) Dips +=16;

}

/* ---------------------------------------------------------------------------
   Make the GUI....
 ----------------------------------------------------------------------------*/

void phoenix_gui()
{
	Image *phmenu;				/* Pointer to image */
	clearscr(640, 480);

	phmenu = load_pcx(gui_main);		/* Load main image, convert to RGB565 */
	putimage(0, 0, phmenu, vram_s);		/* Stick it on the screen */

	do_menu();				/* Draw the menu bit */
}
