#include <kos.h>
#include "video.h"
#include "pallete.h"	/* Colour Information */
#include "Z80/Z80.h"
#include "phoenix.h"

/* ---------------------------------------------------------------------------
   Hey, guess what this does!
 ----------------------------------------------------------------------------*/

void DrawScreen()
{
	int x,y,pos,temp;                     /* declare the vars needed... */
	int scroll = RAM[0x5800];             /* scroll row position */

  	if(skip--) return;                    /* skip frames to speed up */
  	skip = frameskip;                     /* reset skip counter */

	for (pos=0;pos<832;pos++)
  	{				      /* for each byte in video */
    		if (DirtyCharA[pos])
    		{                    	      /* if is is marked... */
      			DirtyCharA[pos]=0;    /*...unmark it... */
      			DrawCharA(pos);       /*...and draw to bitmap */
    		}
    		if (DirtyCharB[pos])
    		{                    	      /* also do the same for */
      			DirtyCharB[pos]=0;    /* the background plane */
      			DrawCharB(pos);       /* while we're at it */
    		}
  	}

  	temp=256-scroll;                      /* split line */

  	/*
  	   This stops the top 8 raster lines of bm3 showing...

  	   Allegro: set_clip(bm3,0,8,208,256);
  	*/

  	/* Here we blit the first part of the scrolling background bg2 onto bg3

	   Allegro: blit(bm2,bm3,0,scroll,0,0,208,temp);
	*/

  	for (x=0; x < 208; x++)
  	{
		int sourcey = scroll;

		/* Ignore top 8 lines to prevent jagged scrolling... */
		for (y = 0; y < 8; y++)
		{
			bm3[x][y] = 0;
			sourcey++;
		}

		/* Display the rest as normal */
          	for (y = 8; y < temp; y++)
  			{
				bm3[x][y] = bm2[x][sourcey];
				sourcey++;
  			}
        }

  	/* Here we blit the second part of background bg2 onto bg3

	   Allegro: blit(bm2,bm3,0,0,0,temp,208,scroll);
	*/

    	for (x=0; x < 208; x++)
    	{
		int desty = temp;

            	for (y = 0; y < scroll; y++)
    			{
  				bm3[x][desty] = bm2[x][y];
  				desty++;
    			}
        }

  	/* This means its ok to draw on all of the bitmap, but I'll
  	   ignore this, as I ignored the first one too...
  	   Allegro: set_clip(bm3,0,0,208,256);
	*/


  	/* Here we do a masked blit, which is the same as a blit, but we
  	   ignore the transparent pixels.

  	   This blits the foreground over the background.

	   Allegro: masked_blit(bm1,bm3,0,0,0,0,208,256);
	*/

  	for (x=0; x < 208; x++)
  	{
          	for (y = 0; y < 240; y++) /* In reality y should be 256 */
  			{
				/* Ignore transparent stuff */
				if (bm1[x][y] == 0 ){}
				/* Otherwise copy */
	          		else
	          			bm3[x][y] = bm1[x][y];
  			}
        }

  	/* Finally we draw bm3 to the screen
  	   Allegro: blit(bm3,screen,0,0,76,4,208,256);
	*/

	/* We only bother drawing y from 0 to 240 instead of 256 to speed things up
	   and to make it fit on the screen */

	for (x=0; x < 208; x++)
	{
        	for (y = 0; y < 240; y++)	/* Ignore bottom of bitmap for now */
			{
        		vram_s[(x+56) + (320*y)] = bm3[x][y];
			}
        }

  return;
}


/* ---------------------------------------------------------------------------
   DrawCharA draws one character to buffer bitmap 1
 ----------------------------------------------------------------------------*/

void DrawCharA(int pos)
{
	int x = 25-(pos/32);                    /* calculate x and */
	int y = pos%32;                         /* y coordinates of pos */
	unsigned int cx,cy;                     /* local char coords */
	unsigned char chr,b1,b2,col,col2;       /* other vars */

  	if (VRAM) chr=VRAM1[(25-x)*32+y];       /* char code from proper */
  	else chr=VRAM0[(25-x)*32+y];            /* bank of VRAM */
	col=4*(chr>>5);				/* calc "base" color index */

	for (cx=0;cx<8;cx++)
	{					/* loop through columns */
		b1=CharA[chr*8+cx];             /* byte from char ROMs */
		b2=CharA[chr*8+cx+0x0800];      /* byte from char ROMs */

    		for (cy=0;cy<8;cy++)
    		{                      		/* loop through each bit */
      			col2=col+2*((b1>>cy)&1);/* adjust color index */
        		col2+=(b2>>cy)&1;       /* accordingly */

			if (col2%4==0) col2=0;  /* for "transparancy" of fg */

			/* Draw the pixel on the bitmap.
        		   Allegro: bm1->line[(y*8)+cy][(x*8)+(7-cx)]=col2; */

			bm1[(x*8)+(7-cx)] [(y*8)+cy] = get_colour(col2);

        		/* direct memory access to the bitmap is supposedly faster */
      		}
	}
}

/* ---------------------------------------------------------------------------
   DrawCharB draws one character to buffer bitmap 2
 ----------------------------------------------------------------------------*/

void DrawCharB(int pos)
{
	int x = 25-(pos/32);                          	/* calculate x and */
	int y = pos%32;                               	/* y coordinates */
	unsigned int cx,cy;                           	/* local char coords */
	unsigned int chr,b1,b2,col,col2;

  	if (VRAM) chr=VRAM1[0x0800+(25-x)*32+y];        /* char code from proper */
  	else chr=VRAM0[0x0800+(25-x)*32+y];             /* bank of VRAM */
	col=4*(chr>>5)+32;                            	/* calc "base" color */

	for (cx=0;cx<8;cx++)
	{						/* loop through columns */
		b1=CharB[chr*8+cx];                     /* bytes from char ROMs */
	  	b2=CharB[chr*8+cx+0x0800];              /* other bitplane */

	  	for (cy=0;cy<8;cy++)
	  	{                      			/* loop through each bit */
			col2=col+2*((b1>>cy)&1);        /* adjust color per */
			col2+=(b2>>cy)&1;               /* bits from char ROMs */

			/* Draw the pixel on the bitmap.
			   Allegro: bm2->line[(y*8)+cy][(x*8)+(7-cx)]=col2; */

			bm2[(x*8)+(7-cx)] [(y*8)+cy] = get_colour(col2);
		}
	}
}


/* ---------------------------------------------------------------------------
   Returns the correct colour from the pallete depending on game
 ----------------------------------------------------------------------------*/

int get_colour(int colour)
{
	if (game==1 && pallete==1)
		return phoenix_pallete1[colour];

	else if (game==1 && pallete==2)
		return phoenix_pallete2[colour];

	else if (game==2 && pallete==1)
		return plieads_pallete1[colour];

	else if (game==2 && pallete==2)
		return plieads_pallete2[colour];
	else
		/* Error */
		return 0;
}



/* ---------------------------------------------------------------------------
   Clear Screen at x x y resolution
 ----------------------------------------------------------------------------*/

void clearscr(int xres, int yres)
{
	int x;
	int y;
	for(x = 0; x < xres; x++)
		for(y = 0; y < yres; y++)
          		vram_s[xres*y + x] = 0;
}

/* ---------------------------------------------------------------------------
   Clear the buffer bitmaps
   This replaces the clear(screen) Allegro function.
   All the screens always are cleared together, so we might as well do that.
 ----------------------------------------------------------------------------*/

void clearbm(void)
{
	int x, y;
	for (x=0; x < 208; x++)
	{
		for(y = 0; y < 256; y++)
		{
			bm1[x][y] = 0;
			bm2[x][y] = 0;
			bm3[x][y] = 0;
		}
	}
}
