#include <kos.h>
#include "Z80/Z80.h"
#include "phoenix.h"
#include "memory.h"

/* ---------------------------------------------------------------------------
   Reads the controller for input
 ----------------------------------------------------------------------------*/

 //KOS 2.X - Use newer MAPLE system :)
void UserInput(void)
{
	maple_device_t *mcont;
	cont_state_t *cond;
	
	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);

	if (!mcont) 				/* no controllers found */
	{
		return;
	}

	cond = (cont_state_t *)maple_dev_status(mcont);
	if (!cond) /* error getting controller status */
	{
		return;
	}

  	RAM[0x7000]=0xFF;                       /* clear input (all bits high) */

  	//if(key[KEY_ESC]) CPURunning=0;        /* stop everything */

  	if((cond->buttons & CONT_X))
  		RAM[0x7000]&=~0x01;          	/* insert coin      (bit 0 low) */

  	if(cond->ltrig)
  		RAM[0x7000]&=~0x02;          	/* press 1PL button (bit 1 low) */

  	if(cond->rtrig)
  		RAM[0x7000]&=~0x04;      	/* press 2PL button (bit 2 low) */

  	if((cond->buttons & CONT_A))
    		RAM[0x7000]&=~0x10;             /* press FIRE button(bit 4 low) */

  	if((cond->buttons & CONT_DPAD_RIGHT))
    		RAM[0x7000]&=~0x20;             /* joystick right   (bit 5 low) */

  	if((cond->buttons & CONT_DPAD_LEFT))
    		RAM[0x7000]&=~0x40;             /* joystick left    (bit 6 low) */

  	if(((cond->buttons & CONT_B)) && game==1)
    		RAM[0x7000]&=~0x80;             /* shield button    (bit 7 low) */

  	if((cond->buttons & CONT_START))	/* resets the whole emulator */
    		ResetMachine();

	/* Uncomment this to enable frameskip toggling with Y button */
    	//if(!(cond.buttons & CONT_Y))
    	//{
     	//	frameskip++;                              /* increment frameskip */
     	//	if(frameskip>fskipmax) frameskip=0;       /* wraparound at max */
  	//}

  	return;
}
