#include <kos.h>
#include "vmulcd.h"
#include "vmu_graphics.h" 	/* Includes VMU Graphics */

/* ---------------------------------------------------------------------------
   vmu_icon_draw outputs to the LCD (nicked from DreamAmp)
 ----------------------------------------------------------------------------*/

void vmu_icon_draw(const char *vmu_icon, maple_device_t *mvmu)
{
	uint8 bitmap[48*32/8] = {0};
	int x, y, xi, xb;

	if (vmu_icon)	/* If the XPM Exists */
	{
		for (y=0; y<32; y++) /* Work through Y Axis */
			for (x=0; x<48; x++) /* Work through X Axis */
			{
				xi = x / 8;
				xb = 0x80 >> (x % 8);
				/* Draw if we find a full stop */
				if (vmu_icon[(31-y)*48+(47-x)] == '.')
					bitmap[y*(48/8)+xi] |= xb;
			}
	}

	vmu_draw_lcd(mvmu, bitmap);
}

/* ---------------------------------------------------------------------------
   vmu_lcd_update draws the selected part of the animation on the screen
 ----------------------------------------------------------------------------*/

void vmu_lcd_update(int phase, maple_device_t *mvmu)
{
	switch (phase)
	{
		case 1:
			vmu_icon_draw(vmu_phoenix1_xpm, mvmu);
			break;
		case 2:
			vmu_icon_draw(vmu_phoenix2_xpm, mvmu);
			break;
		case 3:
			vmu_icon_draw(vmu_phoenix3_xpm, mvmu);
			break;
		case 4:
			vmu_icon_draw(vmu_phoenix1_xpm, mvmu);
			break;
		default:
			vmu_icon_draw(vmu_phoenix1_xpm, mvmu);
			break;
	}
}
