/* ---------------------------------------------------------------------------

 DCPhoenix
 Version 0.5

 Chris White (pointblnk@hotmail.com)
 http://www.alienwebshop.com/pointblank/dc/

 * Based on Jabawape 2.1 Source Code (D. Finck & Th. Strathmann)

 You are free to do what you like with this code, but please read the
 licence for the Z80 emulator in the relevant subdirectory.

 All I ask is that, if you make any improvements, please send me a copy :)

 If you're a DC coder, then I'd encourage you to release your source code.
 We're not going to make any money by keeping it hidden, and we're not going
 to lose anything by releasing it! (apart from helping others).

----------------------------------------------------------------------------*/

#include <kos.h>				/* KOS 2.X flavour */
#include "Z80/Z80.h"			/* Include Z80A CPU emulator */

#include "phoenix.h"
#include "memory.h"
#include "video.h"
#include "sound.h"				/* AICA Firmware and sample support */
#include "vmulcd.h"				/* Include VMU LCD routines */
#include "gui.h"				/* User Interface */

//INIT KOS!
KOS_INIT_FLAGS(INIT_DEFAULT);

/* ---------------------------------------------------------------------------
   Main Method
 ----------------------------------------------------------------------------*/

int main(void)
{
	/* -- Setup Naughty Global Variables ----- */

	VRAM = 0;					/* Current VRAM bank */
	pallete = 1;				/* Select Pallete 1 */
	skip = 0;					/* Set number of skipped frames */
	frameskip = 1;				/* Set Frameskip */
	fskipmax = 3;				/* Used if we enable adjusting of frames within the emulator */
	Dips = 0x41;               	/* default settings of hardware dips (4 Ships) */

	vid_set_mode(DM_640x480, PM_RGB565);	/* Set Graphics Mode 640x480x16 */

	phoenix_gui();				/* Display GUI */

	clearscr(640, 480);			/* Clear Screen */

	//KOS: Has 4 arguments :-P
	bfont_draw_str(vram_s+20*640+20, 640, 0, "DCPhoenix");

	if (AllocateMem())			/* Setup Memory */
		return (1);

	read_roms();				/* Read Game ROMs into Memory */

	bfont_draw_str(vram_s+180*640+20, 640, 0, "Resetting Z80 . . .");
	ResetZ80(&R);				/* Initialise CPU */
	bfont_draw_str(vram_s+210*640+20, 640, 0, "Starting Z80  . . .");

	thd_sleep(1000);				/* Pause for one second */

	clearscr(640, 480);
	vid_set_mode(DM_320x240, PM_RGB565);	/* Switch to 320x240 */

	if (game == 1)
		sound_setup();			/* Initialise Sound */

	Z80(R);					/* Start Z80 CPU */
	vid_set_mode(DM_640x480, PM_RGB565);
	clearscr(640, 480);

	bfont_draw_str(vram_s+20*640+20, 640, 0, "Goodbye!");

	free(RAM);				/* Free Up Memory */

	return (0);
}

/*** Phoenix Hardware Specification ***
Resolution 26x8 = 208 columns x 32x8 = 256 lines

Phoenix memory map
  0000-3fff 16Kb Program ROM
  4000-43ff 1Kb Video RAM Charset A (4340-43ff variables)
  4400-47ff 1Kb Work RAM
  4800-4bff 1Kb Video RAM Charset B (4840-4bff variables)
  4c00-4fff 1Kb Work RAM
  5000-53ff 1Kb Video Control write-only (mirrored)
  5400-47ff 1Kb Work RAM
  5800-5bff 1Kb Video Scroll Register (mirrored)
  5c00-5fff 1Kb Work RAM
  6000-63ff 1Kb Sound Control A (mirrored)
  6400-67ff 1Kb Work RAM
  6800-6bff 1Kb Sound Control B (mirrored)
  6c00-6fff 1Kb Work RAM
  7000-73ff 1Kb 8bit Game Control read-only (mirrored)
  7400-77ff 1Kb Work RAM
  7800-7bff 1Kb 8bit Dip Switch read-only (mirrored)
  7c00-7fff 1Kb Work RAM

  memory mapped ports:

  read-only:
  7000-73ff IN
  7800-7bff DSW

		* IN (all bits are inverted)
		* bit 7 : barrier
		* bit 6 : Left
		* bit 5 : Right
		* bit 4 : Fire
		* bit 3 : -
		* bit 2 : Start 2
		* bit 1 : Start 1
		* bit 0 : Coin

	    * DSW
 	    * bit 7 : VBlank
	    * bit 6 : free play (pleiads only)
	    * bit 5 : attract sound 0 = off 1 = on (pleiads only?)
	    * bit 4 : coins per play	0 = 1 coin	1 = 2 coins
	    * bit 3 :\ bonus
	    * bit 2 :/ 00 = 3000	01 = 4000  10 = 5000  11 = 6000
	    * bit 1 :\ number of lives
	    * bit 0 :/ 00 = 3  01 = 4  10 = 5  11 = 6

		Pallete
		//0 	]
		//1 	] bit 5-7 of video ram value (divides 256 chars in 8 color sections)
		//2 	]
		//3 ] 2 bit pixelcolor
		//4 ] (either from CHAR-A or CHAR-B, depends on Bit5)
		//5 0= CHAR-A, 1= CHAR-B
		//6 palette flag (see video control reg.)
		//7 always 0
*/
