#include "misc.h"
#include <time.h>

void title_init() 
{    
	title_tex = pvr_mem_malloc(512*512*2);
    jpeg_to_texture(TITLE_FILE, title_tex, 512, 1);

	y2k_tex = pvr_mem_malloc(512*512*2);
    jpeg_to_texture(BACK_FILE, y2k_tex, 512, 1);
}

void intro_one_frame()
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;

    /* Begin opaque polygons */
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);

    static_one_frame();
    
    /* Begin translucent polygons */
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);

/* you must send something, or the opaque polys don't get rendered! */
	pvr_poly_cxt_col(&ctx, PVR_LIST_TR_POLY);
	pvr_poly_compile(&poly, &ctx);
	
    /* Finish up */
 	pvr_list_finish();
	pvr_scene_finish();
 
}

void title_one_frame(pvr_ptr_t tex, float a)
{
	pvr_poly_cxt_t ctx;
	pvr_poly_hdr_t poly;
	pvr_vertex_t vert;
	
	pvr_poly_cxt_txr(&ctx, PVR_LIST_TR_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_TWIDDLED, 512, 512, tex, PVR_FILTER_BILINEAR);
	pvr_poly_compile(&poly, &ctx);
    pvr_prim(&poly, sizeof(poly));
	
	vert.argb = PVR_PACK_COLOR(a, 1.0f, 1.0f, 1.0f); //Cool efect fade in / fade out!!
	vert.oargb = PVR_PACK_COLOR(0.0f, 0.0f, 0.0f, 0.0f);
	vert.flags = PVR_CMD_VERTEX;
    
    vert.x = 1;
    vert.y = 1;
    vert.z = 0.0101f;
    vert.u = 0.0;
    vert.v = 0.0;
    pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 1;
    vert.z = 0.0101f;
    vert.u = 1.0;
    vert.v = 0.0;
	pvr_prim(&vert, sizeof(vert));

    
    vert.x = 1;
    vert.y = 480;
    vert.z = 0.0101f;
    vert.u = 0.0;
    vert.v = 1.0;
   	pvr_prim(&vert, sizeof(vert));

    vert.x = 640;
    vert.y = 480;
    vert.z = 0.0101f;
    vert.u = 1.0;
    vert.v = 1.0;
	vert.flags = PVR_CMD_VERTEX_EOL;
	pvr_prim(&vert, sizeof(vert));

}

void do_title()
{
  float a = 0.0;

  time_t start,end;
  double time_spent;

  /* 2 seconds static */
  time(&start);
  while( time_spent < 2.0 ){
      intro_one_frame();
	  time(&end);
	  time_spent = difftime(end, start);
  }

  /* fade in title */
  for(a = 0.0; a <= 1.0 ; a += 0.01) {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
    static_one_frame();
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
	
    title_one_frame(title_tex, a);
	pvr_list_finish();
	pvr_scene_finish();
  }

  /* title 2 seconds */
  pvr_wait_ready();
  pvr_scene_begin();
  pvr_list_begin(PVR_LIST_OP_POLY);
  pvr_list_finish();
  pvr_list_begin(PVR_LIST_TR_POLY);
	
  title_one_frame(title_tex, 1.0);
  pvr_list_finish();
  pvr_scene_finish();
	
  thd_sleep(2000);

  /* fade out title */
  for(a = 1.0; a >= 0.0 ; a -= 0.01) {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
    static_one_frame();
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    title_one_frame(title_tex, a);
	pvr_list_finish();
	pvr_scene_finish();
  }

  /* 2 seconds static */
  time(&start);
  time_spent = 0.0;
  while( time_spent < 2.0){
      intro_one_frame();
	  time(&end);
	  time_spent = difftime(end, start);
  }
  
  /* fade in npm */
  for(a = 0.0; a <= 1.0 ; a += 0.01) {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
    static_one_frame();
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    do_rotozoom(a,0);
	pvr_list_finish();
	pvr_scene_finish();
  }

  /* npm 3 seconds */
  time(&start);	
  time_spent = 0.0;  
  while( time_spent < 3.0)
  {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    do_rotozoom(1.0,1);
	pvr_list_finish();
	pvr_scene_finish();
	
	time(&end);
	time_spent = difftime(end, start);
  }

  /* fade out npm */
  for(a = 1.0; a >= 0.0 ; a -= 0.01) {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
	static_one_frame();
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    do_rotozoom(a,1);
	pvr_list_finish();
	pvr_scene_finish();
  }

  /* 2 seconds static */
  time(&start);
  time_spent = 0.0;  
  while( time_spent < 2.0){
      intro_one_frame();
	  time(&end);
	  time_spent = difftime(end, start);
  }

  /* fade in y2kode */
  for(a = 0.0; a <= 1.0 ; a += 0.01) {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
	static_one_frame();
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    shiver(y2k_tex, a, 16.0f);
	pvr_list_finish();
	pvr_scene_finish();
  
  }

  /* y2kode 1 second */
  time(&start); 
  time_spent = 0.0;
  while( time_spent < 1.0)
  {
	pvr_wait_ready();
	pvr_scene_begin();
	pvr_list_begin(PVR_LIST_OP_POLY);
	
	pvr_list_finish();
	pvr_list_begin(PVR_LIST_TR_POLY);
  
    shiver(y2k_tex, 1.0f, 16.0f);
	pvr_list_finish();
	pvr_scene_finish();
	
	time(&end);
	time_spent = difftime(end, start);
  
  }
}

